/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui.tab;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextArea;
import com.gridnine.xtrip.client.fx.core.res.FxRes;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import javafx.scene.Node;
import javafx.scene.web.WebView;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ContentError {
    NOT_FOUND{

        @Override
        protected String getTemplate() {
            return "not-found.html";
        }

        @Override
        protected String getDescription() {
            return "\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u043d \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d.";
        }

        @Override
        public String getTitle() {
            return Messages.General_Doc_not_found;
        }
    }
    ,
    ACCESS_DENIED{

        @Override
        protected String getTemplate() {
            return "access-denied.html";
        }

        @Override
        protected String getDescription() {
            return "\u0414\u043e\u0441\u0442\u0443\u043f \u043a \u0437\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043d\u043e\u043c\u0443 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0443 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443.";
        }

        @Override
        public String getTitle() {
            return Messages.General_Access_denied1;
        }
    }
    ,
    BAD_CONFIGURATION{

        @Override
        protected String getTemplate() {
            return "bad-configuration.html";
        }

        @Override
        protected String getDescription() {
            return "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043f\u043e\u043a\u0430\u0437\u0430. \u0418\u0437\u043c\u0435\u043d\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u0440\u0430\u0431\u043e\u0447\u0435\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u0438\u043b\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u0442\u0435 \u043f\u0440\u0430\u0432\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u0430.";
        }

        @Override
        public String getTitle() {
            return Messages.Bad_configuration;
        }
    };

    private static final Logger logger;

    public Node createNode(String details) {
        try {
            WebView result = new WebView();
            result.setContextMenuEnabled(false);
            try (InputStream in = FxRes.class.getResourceAsStream("html/" + this.getTemplate());){
                result.getEngine().loadContent(IOUtils.toString((InputStream)in, (String)"utf-8").replace("<!--details-->", details));
            }
            catch (IOException ioe) {
                ErrorHandler.handle(ioe);
                result.getEngine().load(FxRes.class.getResource("html/" + this.getTemplate()).toExternalForm());
            }
            return result;
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            CustomTextArea textArea = new CustomTextArea();
            textArea.setEditable(false);
            textArea.setText(this.getDescription());
            return textArea;
        }
    }

    public abstract String getTitle();

    protected abstract String getTemplate();

    protected abstract String getDescription();

    static {
        logger = LoggerFactory.getLogger(ContentError.class);
    }
}

