/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui.tab;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPaneSkin;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPaneTab;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableListWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.layout.Pane;

public class TabPane
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "xtrip-tab-pane";
    private static final double DEFAULT_TAB_GAP = 0.0;
    private static final double DEFAULT_TAB_SPECIAL_WIDTH = 50.0;
    private static final double DEFAULT_TAB_MIN_WIDTH = 0.0;
    private static final double DEFAULT_TAB_MAX_WIDTH = Double.MAX_VALUE;
    private static final double DEFAULT_CONTROLS_GAP = 0.0;
    private static final double DEFAULT_CONTROLS_WIDTH = 80.0;
    private final ObjectProperty<SingleSelectionModel<TabPaneTab>> specialTabsSelectionModel = new SimpleObjectProperty((Object)this, "specialTabsSelectionModel");
    private final ObjectProperty<SingleSelectionModel<TabPaneTab>> regularTabsSelectionModel = new SimpleObjectProperty((Object)this, "regularTabsSelectionModel");
    private DoubleProperty tabGap;
    private DoubleProperty tabSpecialWidth;
    private DoubleProperty tabMinWidth;
    private DoubleProperty tabMaxWidth;
    private DoubleProperty controlsGap;
    private DoubleProperty controlsWidth;
    private final ObservableList<TabPaneTab> specialTabs = new ObservableListWrapper<TabPaneTab>(FXCollections.observableArrayList());
    private final ObservableList<TabPaneTab> regularTabs = new ObservableListWrapper<TabPaneTab>(FXCollections.observableArrayList());
    private ObjectProperty<Pane> contentPane;

    public TabPane() {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setSpecialTabsSelectionModel(new SpecialTabsSelectionModel(this));
        this.setRegularTabsSelectionModel(new RegularTabsSelectionModel(this));
        this.specialTabs.addListener(c -> {
            while (c.next()) {
                for (TabPaneTab tab : c.getRemoved()) {
                    if (tab == null || this.getSpecialTabs().contains((Object)tab)) continue;
                    tab.setTabPane(null);
                }
                for (TabPaneTab tab : c.getAddedSubList()) {
                    if (tab == null) continue;
                    tab.setTabPane(this);
                    tab.setSpecial(true);
                }
            }
        });
        this.regularTabs.addListener(c -> {
            while (c.next()) {
                for (TabPaneTab tab : c.getRemoved()) {
                    if (tab == null || this.getRegularTabs().contains((Object)tab)) continue;
                    tab.setTabPane(null);
                }
                for (TabPaneTab tab : c.getAddedSubList()) {
                    if (tab == null) continue;
                    tab.setTabPane(this);
                    tab.setSpecial(false);
                }
            }
        });
    }

    public final void setSpecialTabsSelectionModel(SingleSelectionModel<TabPaneTab> value) {
        this.specialTabsSelectionModel.set(value);
    }

    public final SingleSelectionModel<TabPaneTab> getSpecialTabsSelectionModel() {
        return (SingleSelectionModel)this.specialTabsSelectionModel.get();
    }

    public final ObjectProperty<SingleSelectionModel<TabPaneTab>> specialTabsSelectionModelProperty() {
        return this.specialTabsSelectionModel;
    }

    public final void setRegularTabsSelectionModel(SingleSelectionModel<TabPaneTab> value) {
        this.regularTabsSelectionModel.set(value);
    }

    public final SingleSelectionModel<TabPaneTab> getRegularTabsSelectionModel() {
        return (SingleSelectionModel)this.regularTabsSelectionModel.get();
    }

    public final ObjectProperty<SingleSelectionModel<TabPaneTab>> regularTabsSelectionModelProperty() {
        return this.regularTabsSelectionModel;
    }

    public final void setTabGap(double value) {
        this.tabGapProperty().setValue((Number)value);
    }

    public final double getTabGap() {
        return this.tabGap != null ? this.tabGap.getValue() : 0.0;
    }

    public final DoubleProperty tabGapProperty() {
        if (this.tabGap == null) {
            this.tabGap = new StyleableDoubleProperty(0.0){

                public CssMetaData<TabPane, Number> getCssMetaData() {
                    return StyleableProperties.TAB_GAP;
                }

                public Object getBean() {
                    return TabPane.this;
                }

                public String getName() {
                    return "tabGap";
                }
            };
        }
        return this.tabGap;
    }

    public final void setTabSpecialWidth(double value) {
        this.tabSpecialWidthProperty().setValue((Number)value);
    }

    public final double getTabSpecialWidth() {
        return this.tabSpecialWidth != null ? this.tabSpecialWidth.getValue() : 50.0;
    }

    public final DoubleProperty tabSpecialWidthProperty() {
        if (this.tabSpecialWidth == null) {
            this.tabSpecialWidth = new StyleableDoubleProperty(50.0){

                public CssMetaData<TabPane, Number> getCssMetaData() {
                    return StyleableProperties.TAB_SPECIAL_WIDTH;
                }

                public Object getBean() {
                    return TabPane.this;
                }

                public String getName() {
                    return "tabSpecialWidth";
                }
            };
        }
        return this.tabSpecialWidth;
    }

    public final void setTabMinWidth(double value) {
        this.tabMinWidthProperty().setValue((Number)value);
    }

    public final double getTabMinWidth() {
        return this.tabMinWidth != null ? this.tabMinWidth.getValue() : 0.0;
    }

    public final DoubleProperty tabMinWidthProperty() {
        if (this.tabMinWidth == null) {
            this.tabMinWidth = new StyleableDoubleProperty(0.0){

                public CssMetaData<TabPane, Number> getCssMetaData() {
                    return StyleableProperties.TAB_MIN_WIDTH;
                }

                public Object getBean() {
                    return TabPane.this;
                }

                public String getName() {
                    return "tabMinWidth";
                }
            };
        }
        return this.tabMinWidth;
    }

    public final void setTabMaxWidth(double value) {
        this.tabMaxWidthProperty().setValue((Number)value);
    }

    public final double getTabMaxWidth() {
        return this.tabMaxWidth != null ? this.tabMaxWidth.getValue() : Double.MAX_VALUE;
    }

    public final DoubleProperty tabMaxWidthProperty() {
        if (this.tabMaxWidth == null) {
            this.tabMaxWidth = new StyleableDoubleProperty(Double.MAX_VALUE){

                public CssMetaData<TabPane, Number> getCssMetaData() {
                    return StyleableProperties.TAB_MAX_WIDTH;
                }

                public Object getBean() {
                    return TabPane.this;
                }

                public String getName() {
                    return "tabMaxWidth";
                }
            };
        }
        return this.tabMaxWidth;
    }

    public final void setControlsGap(double value) {
        this.controlsGapProperty().setValue((Number)value);
    }

    public final double getControlsGap() {
        return this.controlsGap != null ? this.controlsGap.getValue() : 0.0;
    }

    public final DoubleProperty controlsGapProperty() {
        if (this.controlsGap == null) {
            this.controlsGap = new StyleableDoubleProperty(0.0){

                public CssMetaData<TabPane, Number> getCssMetaData() {
                    return StyleableProperties.CONTROLS_GAP;
                }

                public Object getBean() {
                    return TabPane.this;
                }

                public String getName() {
                    return "controlsGap";
                }
            };
        }
        return this.controlsGap;
    }

    public final void setControlsWidth(double value) {
        this.controlsWidthProperty().setValue((Number)value);
    }

    public final double getControlsWidth() {
        return this.controlsWidth != null ? this.controlsWidth.getValue() : 80.0;
    }

    public final DoubleProperty controlsWidthProperty() {
        if (this.controlsWidth == null) {
            this.controlsWidth = new StyleableDoubleProperty(80.0){

                public CssMetaData<TabPane, Number> getCssMetaData() {
                    return StyleableProperties.CONTROLS_WIDTH;
                }

                public Object getBean() {
                    return TabPane.this;
                }

                public String getName() {
                    return "controlsWidth";
                }
            };
        }
        return this.controlsWidth;
    }

    public final void setContentPane(Pane value) {
        this.contentPaneProperty().set((Object)value);
    }

    public final Pane getContentPane() {
        return this.contentPane != null ? (Pane)this.contentPane.get() : null;
    }

    public final ObjectProperty<Pane> contentPaneProperty() {
        if (this.contentPane == null) {
            this.contentPane = new SimpleObjectProperty((Object)this, "contentPane");
        }
        return this.contentPane;
    }

    public final ObservableList<TabPaneTab> getSpecialTabs() {
        return this.specialTabs;
    }

    public final ObservableList<TabPaneTab> getRegularTabs() {
        return this.regularTabs;
    }

    public List<TabPaneTab> getSpecialTabsHistory() {
        SingleSelectionModel<TabPaneTab> selectionModel = this.getSpecialTabsSelectionModel();
        if (selectionModel instanceof TabsSelectionModel) {
            return ((TabsSelectionModel)selectionModel).getHistory();
        }
        return Collections.emptyList();
    }

    public List<TabPaneTab> getRegularTabsHistory() {
        SingleSelectionModel<TabPaneTab> selectionModel = this.getRegularTabsSelectionModel();
        if (selectionModel instanceof TabsSelectionModel) {
            return ((TabsSelectionModel)selectionModel).getHistory();
        }
        return Collections.emptyList();
    }

    public void selectSpecialPrevious() {
        this.getSpecialTabsSelectionModel().selectPrevious();
    }

    public void selectSpecialNext() {
        this.getSpecialTabsSelectionModel().selectNext();
    }

    public void selectSpecialFirst() {
        this.getSpecialTabsSelectionModel().selectFirst();
    }

    public void selectSpecialLast() {
        this.getSpecialTabsSelectionModel().selectLast();
    }

    public void selectRegularPrevious() {
        this.getRegularTabsSelectionModel().selectPrevious();
    }

    public void selectRegularNext() {
        this.getRegularTabsSelectionModel().selectNext();
    }

    public void selectRegularFirst() {
        this.getRegularTabsSelectionModel().selectFirst();
    }

    public void selectRegularLast() {
        this.getRegularTabsSelectionModel().selectLast();
    }

    protected Skin<?> createDefaultSkin() {
        return new TabPaneSkin(this);
    }

    public Node lookup(String selector) {
        Node node;
        block3: {
            TabPaneTab tab;
            Iterator iterator;
            node = super.lookup(selector);
            if (node == null) {
                iterator = this.specialTabs.iterator();
                while (iterator.hasNext() && (node = (tab = (TabPaneTab)iterator.next()).lookup(selector)) == null) {
                }
            }
            if (node != null) break block3;
            iterator = this.regularTabs.iterator();
            while (iterator.hasNext() && (node = (tab = (TabPaneTab)iterator.next()).lookup(selector)) == null) {
            }
        }
        return node;
    }

    public Set<Node> lookupAll(String selector) {
        if (selector == null) {
            return null;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(super.lookupAll(selector));
        for (TabPaneTab tab : this.specialTabs) {
            nodes.addAll(tab.lookupAll(selector));
        }
        for (TabPaneTab tab : this.regularTabs) {
            nodes.addAll(tab.lookupAll(selector));
        }
        return Collections.unmodifiableSet(new HashSet(nodes));
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TabPane.getClassCssMetaData();
    }

    void closeMultiple(boolean all, boolean includeActive) {
        TabPaneTab activeTab;
        if (!all) {
            if (!includeActive) {
                return;
            }
            TabPaneTab tab = (TabPaneTab)this.getRegularTabsSelectionModel().getSelectedItem();
            if (tab != null) {
                tab.close();
            }
            return;
        }
        ArrayList<TabPaneTab> tabsToClose = new ArrayList<TabPaneTab>((Collection<TabPaneTab>)this.getRegularTabs());
        if (!includeActive && (activeTab = (TabPaneTab)this.getRegularTabsSelectionModel().getSelectedItem()) != null) {
            tabsToClose.remove(activeTab);
        }
        if (tabsToClose.isEmpty()) {
            return;
        }
        if (tabsToClose.size() == 1) {
            ((TabPaneTab)tabsToClose.get(0)).close();
            return;
        }
        Notifications.get().submitTask(() -> {
            for (TabPaneTab tab : tabsToClose) {
                FxUtil.waitForFxThread(() -> tab.close());
            }
        }, Messages.General_Tab_closing);
    }

    private static class RegularTabsSelectionModel
    extends TabsSelectionModel {
        private final TabPane tabPane;
        private boolean adjusting = false;

        public RegularTabsSelectionModel(TabPane tabPane) {
            super(tabPane.getRegularTabs());
            this.tabPane = tabPane;
        }

        @Override
        public void select(int index) {
            if (this.adjusting) {
                return;
            }
            this.adjusting = true;
            if (index >= 0) {
                this.tabPane.getSpecialTabsSelectionModel().select(-1);
            }
            super.select(index);
            if (index < 0) {
                this.tabPane.getSpecialTabsSelectionModel().select(this.tabPane.getSpecialTabs().size() - 1);
            }
            this.adjusting = false;
        }
    }

    private static class SpecialTabsSelectionModel
    extends TabsSelectionModel {
        private final TabPane tabPane;
        private boolean adjusting = false;

        public SpecialTabsSelectionModel(TabPane tabPane) {
            super(tabPane.getSpecialTabs());
            this.tabPane = tabPane;
        }

        @Override
        public void select(int index) {
            if (this.adjusting) {
                return;
            }
            this.adjusting = true;
            if (index >= 0) {
                this.tabPane.getRegularTabsSelectionModel().select(-1);
            }
            super.select(index);
            if (index < 0) {
                this.tabPane.getRegularTabsSelectionModel().select(Math.min(0, this.tabPane.getRegularTabs().size() - 1));
            }
            this.adjusting = false;
        }
    }

    private static class TabsSelectionModel
    extends SingleSelectionModel<TabPaneTab> {
        private final List<TabPaneTab> history = new ArrayList<TabPaneTab>();
        private final ObservableList<TabPaneTab> tabs;

        public TabsSelectionModel(ObservableList<TabPaneTab> tabs) {
            this.tabs = tabs;
            this.tabs.addListener(change -> {
                while (change.next()) {
                    for (TabPaneTab tab : change.getRemoved()) {
                        this.history.remove(tab);
                        if (!tab.isSelected()) continue;
                        this.select(-1);
                        if (this.history.size() <= 0) continue;
                        this.select(this.tabs.indexOf((Object)this.history.get(this.history.size() - 1)));
                    }
                    if (!change.wasAdded() && !change.wasRemoved() || this.getSelectedIndex() == this.tabs.indexOf(this.getSelectedItem())) continue;
                    this.select(this.tabs.indexOf(this.getSelectedItem()));
                }
            });
        }

        public void select(int index) {
            if (index == this.getSelectedIndex()) {
                return;
            }
            if (this.getSelectedItem() != null) {
                ((TabPaneTab)this.getSelectedItem()).setSelected(false);
            }
            this.setSelectedIndex(index);
            this.setSelectedItem(this.getModelItem(index));
            if (this.getSelectedItem() != null) {
                ((TabPaneTab)this.getSelectedItem()).setSelected(true);
            }
            if (index >= 0) {
                this.history.remove(this.getSelectedItem());
                this.history.add((TabPaneTab)this.getSelectedItem());
            }
        }

        protected TabPaneTab getModelItem(int index) {
            if (index >= 0 && index < this.tabs.size()) {
                return (TabPaneTab)this.tabs.get(index);
            }
            return null;
        }

        protected int getItemCount() {
            return this.tabs.size();
        }

        public void selectPrevious() {
            if (this.getSelectedIndex() <= 0) {
                return;
            }
            this.select(this.getSelectedIndex() - 1);
        }

        public void selectNext() {
            if (this.getSelectedIndex() >= this.getItemCount() - 1) {
                return;
            }
            this.select(this.getSelectedIndex() + 1);
        }

        public List<TabPaneTab> getHistory() {
            return Collections.unmodifiableList(this.history);
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<TabPane, Number> TAB_GAP = new CssMetaData<TabPane, Number>("-xtrip-tab-gap", StyleConverter.getSizeConverter(), (Number)0.0){

            public boolean isSettable(TabPane tabPane) {
                return tabPane.tabGap == null || !tabPane.tabGap.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TabPane tabPane) {
                return (StyleableProperty)tabPane.tabGapProperty();
            }
        };
        private static final CssMetaData<TabPane, Number> TAB_SPECIAL_WIDTH = new CssMetaData<TabPane, Number>("-xtrip-tab-special-width", StyleConverter.getSizeConverter(), (Number)50.0){

            public boolean isSettable(TabPane tabPane) {
                return tabPane.tabSpecialWidth == null || !tabPane.tabSpecialWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TabPane tabPane) {
                return (StyleableProperty)tabPane.tabSpecialWidthProperty();
            }
        };
        private static final CssMetaData<TabPane, Number> TAB_MIN_WIDTH = new CssMetaData<TabPane, Number>("-xtrip-tab-min-width", StyleConverter.getSizeConverter(), (Number)0.0){

            public boolean isSettable(TabPane tabPane) {
                return tabPane.tabMinWidth == null || !tabPane.tabMinWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TabPane tabPane) {
                return (StyleableProperty)tabPane.tabMinWidthProperty();
            }
        };
        private static final CssMetaData<TabPane, Number> TAB_MAX_WIDTH = new CssMetaData<TabPane, Number>("-xtrip-tab-max-width", StyleConverter.getSizeConverter(), (Number)Double.MAX_VALUE){

            public boolean isSettable(TabPane tabPane) {
                return tabPane.tabMaxWidth == null || !tabPane.tabMaxWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TabPane tabPane) {
                return (StyleableProperty)tabPane.tabMaxWidthProperty();
            }
        };
        private static final CssMetaData<TabPane, Number> CONTROLS_GAP = new CssMetaData<TabPane, Number>("-xtrip-controls-gap", StyleConverter.getSizeConverter(), (Number)0.0){

            public boolean isSettable(TabPane tabPane) {
                return tabPane.controlsGap == null || !tabPane.controlsGap.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TabPane tabPane) {
                return (StyleableProperty)tabPane.controlsGapProperty();
            }
        };
        private static final CssMetaData<TabPane, Number> CONTROLS_WIDTH = new CssMetaData<TabPane, Number>("-xtrip-controls-width", StyleConverter.getSizeConverter(), (Number)80.0){

            public boolean isSettable(TabPane tabPane) {
                return tabPane.controlsWidth == null || !tabPane.controlsWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TabPane tabPane) {
                return (StyleableProperty)tabPane.controlsWidthProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<TabPane, Number>> styleables = new ArrayList<CssMetaData<TabPane, Number>>(Control.getClassCssMetaData());
            styleables.add(TAB_GAP);
            styleables.add(TAB_SPECIAL_WIDTH);
            styleables.add(TAB_MIN_WIDTH);
            styleables.add(TAB_MAX_WIDTH);
            styleables.add(CONTROLS_GAP);
            styleables.add(CONTROLS_WIDTH);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

