/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.function.Function;
import javafx.util.StringConverter;

public final class Converters {
    public static final StringConverter<SortOrder> SORT_ORDER_CONVERTER = new StringConverter<SortOrder>(){

        public String toString(SortOrder object) {
            if (object == SortOrder.ASC) {
                return Messages.General_By_increase;
            }
            if (object == SortOrder.DESC) {
                return Messages.General_By_decrease;
            }
            return UiUtil.NULL_TEXT;
        }

        public SortOrder fromString(String string) {
            return null;
        }
    };

    public static <T> StringConverter<T> create(final Function<T, String> toStringFunction) {
        return new StringConverter<T>(){

            public String toString(T object) {
                return object == null ? null : (String)toStringFunction.apply(object);
            }

            public T fromString(String string) {
                return null;
            }
        };
    }

    public static StringConverter<Boolean> boolConverter(final String trueValue, final String falseValue) {
        return new StringConverter<Boolean>(){

            public String toString(Boolean object) {
                return Boolean.TRUE.equals(object) ? trueValue : falseValue;
            }

            public Boolean fromString(String string) {
                return null;
            }
        };
    }

    public static StringConverter<Boolean> boolConverter(final String trueValue, final String falseValue, final String nullValue) {
        return new StringConverter<Boolean>(){

            public String toString(Boolean object) {
                return object == null ? nullValue : (object != false ? trueValue : falseValue);
            }

            public Boolean fromString(String string) {
                return null;
            }
        };
    }

    private Converters() {
    }
}

