/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import com.gridnine.xtrip.client.fx.core.util.ErrorHandlers;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.util.TextUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.function.Function;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.transport.http.WebServerError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ErrorHandler {
    public static final Logger LOG = LoggerFactory.getLogger(ErrorHandler.class);

    public static boolean isVersionMismatchError(Throwable error) {
        if (!(error instanceof Xeption)) {
            return false;
        }
        Xeption xeption = (Xeption)error;
        return xeption.getEndUserMessage() != null && L10n.get((String)Messages.BaseSecureServiceImpl_clientVersionDiffersFromTheServer).equals(xeption.getEndUserMessage().getKey());
    }

    public static boolean isUncaughtError(Throwable error) {
        String message = error.getMessage();
        return message != null && message.startsWith("uncaught exception in thread ");
    }

    public static String getMessage(Throwable error) {
        ServiceException se;
        if (error == null) {
            return com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Unknown_logic_error;
        }
        if (error instanceof CannotConnectException) {
            return com.gridnine.xtrip.client.fx.core.l10n.Messages.General_No_server_connection;
        }
        if (error instanceof InvocationTargetException) {
            return ErrorHandler.getMessage(((InvocationTargetException)error).getTargetException());
        }
        if (error instanceof UndeclaredThrowableException) {
            return ErrorHandler.getMessage(error.getCause());
        }
        if (error instanceof WebServerError) {
            return com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Server_returned_error;
        }
        if (ErrorHandler.isVersionMismatchError(error)) {
            return com.gridnine.xtrip.client.fx.core.l10n.Messages.General_System_update_occured_reboot_required;
        }
        String result = null;
        if (error instanceof Xeption) {
            Xeption x = (Xeption)error;
            if (x.getEndUserMessage() != null) {
                result = x.getEndUserMessage().toString();
            } else if (x.getAdminMessage() != null) {
                result = x.getAdminMessage().toString();
            }
        }
        if (error instanceof ServiceException && ((se = (ServiceException)error).isForUser() || se.isForAdmin())) {
            result = se.getUserMessage();
        }
        if (result == null) {
            result = error.getLocalizedMessage();
        }
        if (TextUtil.isBlank(result)) {
            result = com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Unknown_logic_error;
        }
        return result;
    }

    public static String getDetails(Throwable t) {
        String ls = "\n";
        if (t instanceof ServiceException) {
            ServiceException se = (ServiceException)t;
            StringBuilder sb = new StringBuilder();
            sb.append("Exception class: ").append(t.getClass().getName()).append(ls);
            if (se.getDate() != null) {
                sb.append("Exception date: ").append(se.getDate()).append(ls);
            }
            if (se.getDetails() != null) {
                sb.append("Reason stack trace:").append(ls).append(se.getDetails().replace("\r\n", ls)).append(ls);
            }
            sb.append("Exception stack trace:").append(ls).append(TextUtil.getExceptionStackTrace((Throwable)t).replace("\r\n", ls));
            return sb.toString();
        }
        Xeption xeption = (Xeption)IncidentsHelper.findCause((Throwable)t, Xeption.class);
        return (xeption != null ? xeption + ls : "") + TextUtil.getExceptionStackTrace((Throwable)t).replace("\r\n", ls);
    }

    public static void handle(Throwable error) {
        ErrorHandlers.handle(error);
    }

    public static void register(ErrorHandler handler) {
        ErrorHandlers.register(handler);
    }

    public void handleError(Throwable var1);

    public static void registerRepairHandler(Function<Throwable, Boolean> action) {
        ErrorHandlers.registerRepairHandler(action);
    }
}

