/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.Executable;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.model.Xeption;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SubScene;
import javafx.scene.paint.Color;

public final class FxUtil {
    public static <T> void swap(ObservableList<T> list, int i, int j) {
        Object[] arr = list.toArray();
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
        list.setAll(arr);
    }

    public static <T> void move(ObservableList<T> list, int fromPos, int toPos) {
        Object item = list.get(fromPos);
        Object[] arr = list.toArray();
        if (fromPos < toPos) {
            System.arraycopy(arr, fromPos + 1, arr, fromPos, toPos - fromPos);
        } else {
            System.arraycopy(arr, toPos, arr, toPos + 1, fromPos - toPos);
        }
        arr[toPos] = item;
        list.setAll(arr);
    }

    public static void runInFxThread(Runnable job) {
        if (Platform.isFxApplicationThread()) {
            job.run();
        } else {
            Platform.runLater((Runnable)job);
        }
    }

    public static void submitToFxThread(Runnable job) {
        Platform.runLater((Runnable)job);
    }

    public static void waitForFxThread(Executable job) throws Exception {
        if (Platform.isFxApplicationThread()) {
            job.execute();
            return;
        }
        ValueHolder error = new ValueHolder();
        CountDownLatch doneLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                job.execute();
            }
            catch (Exception e) {
                error.set(e);
            }
            finally {
                doneLatch.countDown();
            }
        });
        try {
            doneLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (error.get() != null) {
            throw (Exception)error.get();
        }
    }

    public static void openUrl(String url) {
        if (!Desktop.isDesktopSupported()) {
            ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.Operation_Not_Supported, (Object[])new Object[0]));
            return;
        }
        Runnable job = () -> {
            try {
                Desktop desktop = Desktop.getDesktop();
                if (!desktop.isSupported(Desktop.Action.BROWSE)) {
                    ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.Browse_Not_Available, (Object[])new Object[0]));
                    return;
                }
                Desktop.getDesktop().browse(URI.create(url));
            }
            catch (IOException ioe) {
                ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.Browser_Start_Failed, (Object[])new Object[0]));
            }
        };
        if (Platform.isFxApplicationThread()) {
            Thread thread = new Thread(job, "opening-platform-browser");
            thread.setDaemon(true);
            thread.start();
        } else {
            job.run();
        }
    }

    public static void openFile(File file) {
        if (!Desktop.isDesktopSupported()) {
            ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.General_Not_Supported, (Object[])new Object[0]));
            return;
        }
        try {
            Desktop.getDesktop().open(file);
        }
        catch (IOException ioe) {
            ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.General_File_not_opened, (Throwable)ioe, (Object[])new Object[0]));
        }
    }

    public static void saveToFile(File file, byte[] data) {
        try {
            File parent = file.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.General_Folder_Not_Created, (Object[])new Object[0]));
                return;
            }
            Files.write(file.toPath(), data, new OpenOption[0]);
        }
        catch (IOException ioe) {
            ErrorHandler.handle((Throwable)FxUtil.wrapIOException(ioe));
        }
    }

    public static Xeption wrapIOException(IOException error) {
        if (error instanceof FileSystemException) {
            return Xeption.forEndUser((String)Messages.General_No_Permission, (Throwable)error, (Object[])new Object[0]);
        }
        return Xeption.forEndUser((String)Messages.General_File_Write_Error, (Throwable)error, (Object[])new Object[0]);
    }

    public static String toRGBCode(Color color) {
        return String.format("#%02X%02X%02X", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }

    public static <T> void bind(Property<T> prop, final ObservableValue<T> value) {
        final Object initialValue = prop.getValue();
        Object val = value.getValue();
        if (val != null) {
            prop.setValue(val);
        }
        prop.bind((ObservableValue)new ObjectBinding<T>(){
            {
                this.bind(new Observable[]{value});
            }

            protected T computeValue() {
                Object result = value.getValue();
                return result == null ? initialValue : result;
            }
        });
    }

    public static <T> void addListener(ObservableValue<T> value, ChangeListener<T> listener) {
        value.addListener(listener);
        listener.changed(value, null, value.getValue());
    }

    public static String toString(Node node) {
        return FxUtil.toString(Collections.singletonList(node), item -> {
            if (item instanceof Parent) {
                return ((Parent)item).getChildrenUnmodifiable();
            }
            if (item instanceof SubScene) {
                return Collections.singletonList(((SubScene)item).getRoot());
            }
            return Collections.emptyList();
        }, item -> {
            String result = item.getClass().getSimpleName();
            if (item.getId() != null) {
                result = result + " [" + item.getId() + ']';
            }
            return result;
        });
    }

    public static <T> String toString(Collection<T> items, Function<T, Collection<T>> subItemsSupplier, Function<T, String> itemRenderer) {
        StringBuilder result = new StringBuilder();
        FxUtil.toString(result, items, subItemsSupplier, itemRenderer, "", true);
        return result.toString();
    }

    private static <T> void toString(StringBuilder buf, Collection<T> items, Function<T, Collection<T>> subItemsSupplier, Function<T, String> itemRenderer, String prefix, boolean root) {
        int count = 0;
        for (T item : items) {
            buf.append(FxUtil.getPrefix(prefix, count == items.size() - 1, root, false) + itemRenderer.apply(item) + "\n");
            FxUtil.toString(buf, subItemsSupplier.apply(item), subItemsSupplier, itemRenderer, FxUtil.getPrefix(prefix, count == items.size() - 1, root, true), false);
            ++count;
        }
    }

    private static String getPrefix(String prefix, boolean last, boolean root, boolean transit) {
        return root ? prefix : prefix + (last ? (transit ? "    " : " \u2514\u2500\u2500") : (transit ? " \u2502  " : " \u251c\u2500\u2500"));
    }

    public static String getColor(double percent) {
        int g;
        int r;
        int b = 0;
        if (percent < 0.5) {
            r = 255;
            g = (int)Math.round(510.0 * percent);
        } else {
            g = 255;
            r = (int)Math.round(510.0 - 510.0 * percent);
        }
        return String.format("#%02x%02x%02x", r, g, b);
    }

    private FxUtil() {
    }
}

