/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import com.gridnine.xtrip.common.util.Settings;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class UiSettings
extends Settings {
    private final List<Persister> persistersList;

    public static Persister stagePersister(final Stage stage) {
        return new Persister(){

            @Override
            public void write(Properties props) throws Exception {
                if (stage.isResizable()) {
                    if (stage.isMaximized()) {
                        props.setProperty("maximazed", "true");
                        return;
                    }
                    props.setProperty("width", String.valueOf(stage.getWidth()));
                    props.setProperty("height", String.valueOf(stage.getHeight()));
                }
                props.setProperty("location-x", String.valueOf(stage.getX()));
                props.setProperty("location-y", String.valueOf(stage.getY()));
            }

            @Override
            public void read(Properties props) throws Exception {
                Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
                if (stage.isResizable()) {
                    double minHeight;
                    if ("true".equalsIgnoreCase(props.getProperty("maximazed"))) {
                        stage.setMaximized(true);
                        return;
                    }
                    double width = Double.parseDouble(props.getProperty("width", String.valueOf(stage.getWidth())));
                    double height = Double.parseDouble(props.getProperty("height", String.valueOf(stage.getHeight())));
                    double minWidth = stage.getMinWidth();
                    if (minWidth > 0.0 && width < minWidth) {
                        width = minWidth;
                    }
                    if ((minHeight = stage.getMinHeight()) > 0.0 && height < minHeight) {
                        height = minHeight;
                    }
                    if (width > screenSize.getWidth()) {
                        width = screenSize.getWidth();
                    }
                    if (height > screenSize.getHeight()) {
                        height = screenSize.getHeight();
                    }
                    if (!Double.isNaN(width) && width > 0.0) {
                        stage.setWidth(width);
                    }
                    if (!Double.isNaN(height) && height > 0.0) {
                        stage.setHeight(height);
                    }
                }
                double x = Double.parseDouble(props.getProperty("location-x", String.valueOf(stage.getX())));
                double y = Double.parseDouble(props.getProperty("location-y", String.valueOf(stage.getY())));
                if (x < 0.0 || x > screenSize.getWidth() - 10.0) {
                    x = 10.0;
                }
                if (y < 0.0 || y > screenSize.getHeight() - 10.0) {
                    y = 10.0;
                }
                if (!Double.isNaN(x)) {
                    stage.setX(x);
                }
                if (!Double.isNaN(y)) {
                    stage.setY(y);
                }
            }
        };
    }

    public UiSettings(String name, Persister ... persisters) {
        super(name);
        this.persistersList = Arrays.asList(persisters);
    }

    protected void read(Properties props) throws Exception {
        for (Persister persister : this.persistersList) {
            persister.read(props);
        }
    }

    protected void write(Properties props) throws Exception {
        for (Persister persister : this.persistersList) {
            persister.write(props);
        }
    }

    public static interface Persister {
        public void read(Properties var1) throws Exception;

        public void write(Properties var1) throws Exception;
    }
}

