/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.BooleanConsumer;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Labeled;
import javafx.scene.control.ListView;
import javafx.scene.control.PopupControl;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.stage.Popup;
import javafx.stage.PopupWindow;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.StringConverter;

public final class UiUtil {
    private static final double DEFAULT_FONT_SIZE = 10.5;
    private static final double PT = 1.328147292137146;
    public static final String KEY_MODEL_UID = "model-uid";
    public static final String NULL_TEXT = Messages.General_NoValue;
    public static final String VIEW_NULL_TEXT = "\u2014";
    public static final KeyCodeCombination KEY_COMBINATION_COPY = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY});

    public static <N extends Node> N findViewWithModelUid(Iterable<N> views, String uid) {
        if (uid == null) {
            return null;
        }
        for (Node view : views) {
            if (!MiscUtil.equals((Object)view.getProperties().get((Object)KEY_MODEL_UID), (Object)uid)) continue;
            return (N)view;
        }
        return null;
    }

    public static GridPosition gridPosition(GridPane pane, Node node) {
        return new GridPosition(pane, node);
    }

    public static Object lookupProperty(Node node, Object key) {
        if (node == null) {
            return null;
        }
        if (node.hasProperties() && node.getProperties().containsKey(key)) {
            return node.getProperties().get(key);
        }
        return UiUtil.lookupProperty((Node)node.getParent(), key);
    }

    public static Node lookupNode(Node startNode, Predicate<Node> matcher) {
        if (startNode == null) {
            return null;
        }
        if (matcher.test(startNode)) {
            return startNode;
        }
        return UiUtil.lookupNode((Node)startNode.getParent(), matcher);
    }

    public static Node findNode(Node startNode, Predicate<Node> matcher) {
        if (startNode == null) {
            return null;
        }
        if (matcher.test(startNode)) {
            return startNode;
        }
        if (startNode instanceof Parent) {
            ObservableList children = ((Parent)startNode).getChildrenUnmodifiable();
            for (Node child : children) {
                Node node = UiUtil.findNode(child, matcher);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public static void traverse(Node startNode, Consumer<Node> visitor) {
        if (startNode == null) {
            return;
        }
        visitor.accept(startNode);
        if (!(startNode instanceof Parent)) {
            return;
        }
        ObservableList children = ((Parent)startNode).getChildrenUnmodifiable();
        for (Node child : children) {
            UiUtil.traverse(child, visitor);
        }
    }

    public static void showPopup(PopupWindow popup, Region anchor) {
        Point2D p = anchor.localToScene(0.0, 0.0);
        Scene scene = anchor.getScene();
        if (scene == null) {
            return;
        }
        Window window = scene.getWindow();
        double shiftX = window.getX() + scene.getX();
        double shiftY = window.getY() + scene.getY() + anchor.getHeight();
        popup.show(window, p.getX() + shiftX, p.getY() + shiftY);
    }

    public static PopupControl createPopup(Parent content) {
        PopupControl popup = new PopupControl();
        content.getStyleClass().add((Object)"xtrip-popup");
        popup.getScene().setRoot(content);
        popup.setAutoHide(true);
        return popup;
    }

    public static <T> void showListPopup(List<T> items, final Function<T, String> itemConverter, Consumer<T> selectionHandler, Region anchor) {
        ListView listView = new ListView();
        listView.getItems().addAll(items);
        listView.setCellFactory(TextFieldListCell.forListView((StringConverter)new StringConverter<T>(){

            public String toString(T object) {
                return (String)itemConverter.apply(object);
            }

            public T fromString(String string) {
                return null;
            }
        }));
        StackPane sp = new StackPane(new Node[]{listView});
        sp.getStyleClass().addAll((Object[])new String[]{"combo-box-popup", "xtrip-scroll-alt"});
        sp.setPrefHeight((double)Math.min(10, listView.getItems().size()) * 32.5 + 9.0);
        sp.setMinHeight(Double.NEGATIVE_INFINITY);
        sp.setMaxHeight(Double.NEGATIVE_INFINITY);
        int chars = 10;
        for (Object item : listView.getItems()) {
            if (item == null) continue;
            chars = Math.max(chars, itemConverter.apply(item).length());
        }
        chars = Math.min(30, chars);
        sp.setPrefWidth((double)(chars * 15));
        sp.setMinWidth(Double.NEGATIVE_INFINITY);
        sp.setMaxWidth(Double.NEGATIVE_INFINITY);
        Popup popup = new Popup();
        popup.setAutoFix(true);
        popup.setAutoHide(true);
        popup.setHideOnEscape(true);
        popup.getContent().add((Object)sp);
        popup.sizeToScene();
        listView.setOnMouseClicked(me -> {
            if (me.getButton() == MouseButton.PRIMARY) {
                selectionHandler.accept(listView.getSelectionModel().getSelectedItem());
                popup.hide();
            }
        });
        UiUtil.showPopup((PopupWindow)popup, anchor);
    }

    public static void setTooltip(final Node node, final String text) {
        if (TextUtil.isBlank((String)text)) {
            Tooltip.uninstall((Node)node, null);
            return;
        }
        if (node.getScene() != null) {
            Tooltip.install((Node)node, (Tooltip)new Tooltip(text));
            return;
        }
        node.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
                if (newValue != null) {
                    Tooltip.install((Node)node, (Tooltip)new Tooltip(text));
                    node.sceneProperty().removeListener((ChangeListener)this);
                }
            }
        });
    }

    public static void setTooltip(final Node node, final Supplier<String> textSupplier) {
        if (node.getScene() != null) {
            String text = textSupplier.get();
            if (TextUtil.isBlank((String)text)) {
                Tooltip.uninstall((Node)node, null);
            } else {
                Tooltip.install((Node)node, (Tooltip)new Tooltip(text));
            }
            return;
        }
        node.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
                if (newValue != null) {
                    String text = (String)textSupplier.get();
                    if (TextUtil.isBlank((String)text)) {
                        Tooltip.uninstall((Node)node, null);
                    } else {
                        Tooltip.install((Node)node, (Tooltip)new Tooltip(text));
                    }
                    node.sceneProperty().removeListener((ChangeListener)this);
                }
            }
        });
    }

    public static void setTooltip(final Node node, final ObservableValue<? extends String> textProp) {
        if (node.getScene() != null) {
            Tooltip tooltip = new Tooltip();
            tooltip.textProperty().bind(textProp);
            Tooltip.install((Node)node, (Tooltip)tooltip);
            return;
        }
        node.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
                if (newValue != null) {
                    Tooltip tooltip = new Tooltip();
                    tooltip.textProperty().bind(textProp);
                    Tooltip.install((Node)node, (Tooltip)tooltip);
                    node.sceneProperty().removeListener((ChangeListener)this);
                }
            }
        });
    }

    public static void blink(Node node) {
        if (node == null || node.getScene() == null) {
            return;
        }
        if (!node.getStyleClass().contains((Object)"error-value")) {
            node.getStyleClass().add((Object)"error-value");
        }
        FadeTransition transition = new FadeTransition(Duration.millis((double)300.0), node);
        transition.setToValue(0.0);
        transition.setCycleCount(7);
        transition.setInterpolator(Interpolator.EASE_BOTH);
        transition.setOnFinished(evt -> {
            node.getStyleClass().remove((Object)"error-value");
            node.setOpacity(1.0);
        });
        transition.play();
    }

    public static void configureDnDHighlighting(Node node, Predicate<DragEvent> applicable) {
        node.setOnDragEntered(evt -> {
            evt.consume();
            if (!applicable.test((DragEvent)evt)) {
                return;
            }
            InnerShadow effect = new InnerShadow(10.0, Color.LIGHTGREEN);
            effect.setWidth(90.0);
            effect.setHeight(90.0);
            node.setEffect((Effect)effect);
        });
        node.setOnDragExited(evt -> {
            evt.consume();
            node.setEffect(null);
        });
    }

    public static Bounds computeTextBounds(Labeled labeled) {
        String innerText = labeled.getText() == null ? "" : labeled.getText();
        Text helper = new Text();
        helper.setText(innerText);
        helper.setFont(labeled.getFont());
        return helper.getLayoutBounds();
    }

    public static Bounds computeTextBounds(TextField textField) {
        String innerText = textField.getText() == null || textField.getText().isEmpty() ? textField.getPromptText() : textField.getText();
        Text helper = new Text();
        helper.setText(innerText);
        helper.setFont(textField.getFont());
        return helper.getLayoutBounds();
    }

    public static double computeXOffset(double width, double contentWidth, HPos hpos) {
        if (hpos == null) {
            return 0.0;
        }
        switch (hpos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (width - contentWidth) / 2.0;
            }
            case RIGHT: {
                return width - contentWidth;
            }
        }
        return 0.0;
    }

    public static double computeYOffset(double height, double contentHeight, VPos vpos) {
        if (vpos == null) {
            return 0.0;
        }
        switch (vpos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (height - contentHeight) / 2.0;
            }
            case BOTTOM: {
                return height - contentHeight;
            }
        }
        return 0.0;
    }

    public static void expand(TreeView<?> tree) {
        UiUtil.expand(tree.getRoot(), -1);
    }

    public static void expand(TreeView<?> tree, int depth) {
        UiUtil.expand(tree.getRoot(), depth);
    }

    public static void expand(TreeItem<?> item) {
        UiUtil.expand(item, -1);
    }

    public static void expand(TreeItem<?> item, int depth) {
        if (depth == 0) {
            return;
        }
        for (TreeItem child : item.getChildren()) {
            if (child.isLeaf()) continue;
            UiUtil.expand(child, depth - 1);
        }
        item.setExpanded(true);
    }

    public static void collapse(TreeView<?> tree) {
        UiUtil.collapse(tree.getRoot(), -1);
    }

    public static void collapse(TreeItem<?> item) {
        UiUtil.collapse(item, -1);
    }

    public static void collapse(TreeView<?> tree, int depth) {
        UiUtil.collapse(tree.getRoot(), depth);
    }

    public static void collapse(TreeItem<?> item, int depth) {
        for (TreeItem child : item.getChildren()) {
            if (child.isLeaf()) continue;
            UiUtil.collapse(child, depth - 1);
        }
        if (depth <= 0) {
            item.setExpanded(false);
        }
    }

    public static boolean isRelative(TreeItem<?> ancestor, TreeItem<?> descendant) {
        if (ancestor == null || descendant == null) {
            return false;
        }
        if (ancestor == descendant) {
            return true;
        }
        TreeItem parent = descendant;
        while ((parent = parent.getParent()) != null) {
            if (ancestor != parent) continue;
            return true;
        }
        return false;
    }

    public static <T> List<TreeItem<T>> search(TreeItem<T> item, T value, BiPredicate<T, T> predicate, Function<TreeItem<T>, List<TreeItem<T>>> function) {
        ArrayList<TreeItem<T>> items = new ArrayList<TreeItem<T>>();
        if (predicate.test(item.getValue(), value)) {
            items.add(item);
        }
        for (TreeItem<T> childItem : function.apply(item)) {
            items.addAll(UiUtil.search(childItem, value, predicate, function));
        }
        return items;
    }

    public static void setHidden(Node node, boolean hidden) {
        node.setVisible(!hidden);
        node.setManaged(!hidden);
    }

    public static void scrollToVisible(ScrollPane pane, Node node) {
        Bounds viewport = pane.getViewportBounds();
        double contentHeight = pane.getContent().localToScene(pane.getContent().getBoundsInLocal()).getHeight();
        double nodeMinY = node.localToScene(node.getBoundsInLocal()).getMinY();
        double nodeMaxY = node.localToScene(node.getBoundsInLocal()).getMaxY();
        double vValueDelta = 0.0;
        double vValueCurrent = pane.getVvalue();
        if (nodeMaxY < 0.0) {
            vValueDelta = (nodeMinY - viewport.getHeight()) / contentHeight;
        } else if (nodeMinY > viewport.getHeight()) {
            vValueDelta = (nodeMinY + viewport.getHeight()) / contentHeight;
        }
        pane.setVvalue(vValueCurrent + vValueDelta);
        node.requestFocus();
    }

    public static double convertEmToPixels(double em) {
        return UiUtil.computeFontSize(ClientSettings.get().getScaleFactor()) * 1.328147292137146 * em;
    }

    public static double computeFontSize(int factor) {
        return 10.5 + (double)factor;
    }

    public static double computeScale(int factor) {
        return UiUtil.computeFontSize(factor) / 10.5;
    }

    public static boolean isFileValid(File file) {
        if (file == null) {
            return false;
        }
        boolean isValid = false;
        try {
            file.getCanonicalPath();
            isValid = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isValid;
    }

    public static void updateState(int oldState, int newState, BooleanConsumer readonlyUpdater, BooleanConsumer notEditableUpdater, BooleanConsumer aclNotEditableUpdater, BooleanConsumer aclNotViewableUpdater, BooleanConsumer aclNotCreatableUpdater, BooleanConsumer aclNotDeletableUpdater) {
        if ((oldState & 1) != (newState & 1)) {
            readonlyUpdater.accept(ViewState.isReadonly(newState));
        }
        if ((oldState & 2) != (newState & 2)) {
            notEditableUpdater.accept(ViewState.isNotEditable(newState));
        }
        if ((oldState & 4) != (newState & 4)) {
            aclNotEditableUpdater.accept(ViewState.isAclNotEditable(newState));
        }
        if ((oldState & 8) != (newState & 8)) {
            aclNotViewableUpdater.accept(ViewState.isAclNotViewable(newState));
        }
        if ((oldState & 0x10) != (newState & 0x10)) {
            aclNotCreatableUpdater.accept(ViewState.isAclNotCreatable(newState));
        }
        if ((oldState & 0x20) != (newState & 0x20)) {
            aclNotDeletableUpdater.accept(ViewState.isAclNotDeletable(newState));
        }
    }

    private UiUtil() {
    }

    public static class GridPosition {
        private final GridPane parent;
        private final Node child;
        private Integer columnIndex = 0;
        private Integer rowIndex = 0;
        private Integer columnSpan = 1;
        private Integer rowSpan = 1;
        private Boolean fillWidth = Boolean.TRUE;
        private Boolean fillHeight = Boolean.TRUE;
        private HPos halignment = HPos.CENTER;
        private VPos valignment = VPos.CENTER;
        private Priority hgrow = Priority.ALWAYS;
        private Priority vgrow = Priority.ALWAYS;

        GridPosition(GridPane pane, Node node) {
            this.parent = pane;
            this.child = node;
        }

        public GridPosition col(int value) {
            this.columnIndex = value;
            return this;
        }

        public GridPosition row(int value) {
            this.rowIndex = value;
            return this;
        }

        public GridPosition colSpan(int value) {
            this.columnSpan = value;
            return this;
        }

        public GridPosition rowSpan(int value) {
            this.rowSpan = value;
            return this;
        }

        public GridPosition dontFill() {
            this.fillWidth = Boolean.FALSE;
            this.fillHeight = Boolean.FALSE;
            return this;
        }

        public GridPosition hAlignment(HPos value) {
            this.halignment = value;
            return this;
        }

        public GridPosition vAlignment(VPos value) {
            this.valignment = value;
            return this;
        }

        public GridPosition hGrow(Priority value) {
            this.hgrow = value;
            return this;
        }

        public GridPosition vGrow(Priority value) {
            this.vgrow = value;
            return this;
        }

        public void place() {
            GridPane.setColumnIndex((Node)this.child, (Integer)this.columnIndex);
            GridPane.setRowIndex((Node)this.child, (Integer)this.rowIndex);
            GridPane.setColumnSpan((Node)this.child, (Integer)this.columnSpan);
            GridPane.setRowSpan((Node)this.child, (Integer)this.rowSpan);
            GridPane.setFillWidth((Node)this.child, (Boolean)this.fillWidth);
            GridPane.setFillHeight((Node)this.child, (Boolean)this.fillHeight);
            GridPane.setHalignment((Node)this.child, (HPos)this.halignment);
            GridPane.setValignment((Node)this.child, (VPos)this.valignment);
            GridPane.setHgrow((Node)this.child, (Priority)this.hgrow);
            GridPane.setVgrow((Node)this.child, (Priority)this.vgrow);
            this.parent.getChildren().add((Object)this.child);
        }
    }
}

