/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class ViewState {
    public static final int READONLY = 1;
    public static final int NOT_EDITABLE = 2;
    public static final int ACL_NOT_EDITABLE = 4;
    public static final int ACL_NOT_VIEWABLE = 8;
    public static final int ACL_NOT_CREATABLE = 16;
    public static final int ACL_NOT_DELETABLE = 32;
    private final SimpleIntegerProperty state;

    public static boolean isReadonly(int state) {
        return (state & 1) != 0;
    }

    public static boolean isNotEditable(int state) {
        return (state & 2) != 0;
    }

    public static boolean isAclNotEditable(int state) {
        return (state & 4) != 0;
    }

    public static boolean isAclNotViewable(int state) {
        return (state & 8) != 0;
    }

    public static boolean isAclNotCreatable(int state) {
        return (state & 0x10) != 0;
    }

    public static boolean isAclNotDeletable(int state) {
        return (state & 0x20) != 0;
    }

    public static boolean isImmutable(int state) {
        return state != 0;
    }

    public ViewState() {
        this.state = new SimpleIntegerProperty();
    }

    public ViewState(int initialState) {
        this.state = new SimpleIntegerProperty(initialState);
    }

    public boolean isReadonly() {
        return (this.state.get() & 1) != 0;
    }

    public void setReadonly(boolean value) {
        if (value) {
            this.state.set(this.state.get() | 1);
        } else {
            this.state.set(this.state.get() & 0xFFFFFFFE);
        }
    }

    public boolean isNotEditable() {
        return (this.state.get() & 2) != 0;
    }

    public void setNotEditable(boolean value) {
        if (value) {
            this.state.set(this.state.get() | 2);
        } else {
            this.state.set(this.state.get() & 0xFFFFFFFD);
        }
    }

    public boolean isAclNotEditable() {
        return (this.state.get() & 4) != 0;
    }

    public void setAclNotEditable(boolean value) {
        if (value) {
            this.state.set(this.state.get() | 4);
        } else {
            this.state.set(this.state.get() & 0xFFFFFFFB);
        }
    }

    public boolean isAclNotViewable() {
        return (this.state.get() & 8) != 0;
    }

    public void setAclNotViewable(boolean value) {
        if (value) {
            this.state.set(this.state.get() | 8);
        } else {
            this.state.set(this.state.get() & 0xFFFFFFF7);
        }
    }

    public boolean isAclNotCreatable() {
        return (this.state.get() & 0x10) != 0;
    }

    public void setAclNotCreatable(boolean value) {
        if (value) {
            this.state.set(this.state.get() | 0x10);
        } else {
            this.state.set(this.state.get() & 0xFFFFFFEF);
        }
    }

    public boolean isAclNotDeletable() {
        return (this.state.get() & 0x20) != 0;
    }

    public void setAclNotDeletable(boolean value) {
        if (value) {
            this.state.set(this.state.get() | 0x20);
        } else {
            this.state.set(this.state.get() & 0xFFFFFFDF);
        }
    }

    public boolean isImmutable() {
        return this.isReadonly() || this.isNotEditable() || this.isAclNotEditable();
    }

    public IntegerProperty stateProperty() {
        return this.state;
    }

    public int getState() {
        return this.state.get();
    }

    public void setState(int value) {
        this.state.set(value);
    }

    public static int composeState(boolean readonly, boolean notEditable, boolean aclNotEditable, boolean aclNotViewable, boolean aclNotCreatable, boolean aclNotDeletable) {
        return (readonly ? 1 : 0) + (notEditable ? 2 : 0) + (aclNotEditable ? 4 : 0) + (aclNotViewable ? 8 : 0) + (aclNotCreatable ? 16 : 0) + (aclNotDeletable ? 32 : 0);
    }
}

