/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ens.entity.handlers.exportDocument;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.ens.entity.handlers.exportDocument.ENSExportDocumentContainerControllerInterceptor;
import com.gridnine.xtrip.client.fx.ens.export.model.ENSExportDocumentContainer;
import com.gridnine.xtrip.client.fx.ens.export.model.ENSExportDocumentContainerController;
import com.gridnine.xtrip.client.fx.ens.export.model.ENSExportDocumentContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.common.ens.export.model.ENSExportDocument;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class ENSExportDocumentHandler
extends BaseRootEntityHandler<ENSExportDocument, Void, ENSExportDocumentContainerVM, ENSExportDocumentContainer> {
    public String format(EntityContainer<ENSExportDocument> ctr) {
        return TextUtil.isBlank((String)((ENSExportDocument)ctr.getEntity()).getName()) ? ((ENSExportDocument)ctr.getEntity()).getTitle() : ((ENSExportDocument)ctr.getEntity()).getName();
    }

    public Class<ENSExportDocument> getEntityClass() {
        return ENSExportDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicDocumentIndex.class;
    }

    protected void configureController(List<BiConsumer<DataTransferPackage<ENSExportDocument, Void>, ENSExportDocumentContainerVM>> toVM, List<BiConsumer<ENSExportDocumentContainerVM, DataTransferPackage<ENSExportDocument, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new ENSExportDocumentContainerControllerInterceptor());
        toVM.add((dtp, vm) -> {
            ENSExportDocument model = (ENSExportDocument)dtp.getContainer().getEntity();
            vm.getMainSpecifications().setTitle(model.getTitle());
            vm.getMainSpecifications().setName(model.getName());
            vm.getMainSpecifications().setCreated(DateUtils.asLocalDate((Date)model.getCreated()));
            vm.getMainSpecifications().setOwner(model.getOwner());
            vm.getMainSpecifications().setPcc(model.getPcc());
            vm.getMainSpecifications().setNotification(model.getNotification());
            vm.setDescription(model.getDescription());
            RichData data = new RichData();
            data.setContent(model.getContent());
            data.setContentType(model.getContentType());
            if (data.getContentType() == null) {
                data.setContentType(RichContentHandler.guessContentType((String)model.getName()));
            }
            vm.setContents(data);
        });
        fromVM.add((vm, dtp) -> {
            ENSExportDocument model = (ENSExportDocument)dtp.getContainer().getEntity();
            model.setTitle(vm.getMainSpecifications().getTitle());
            model.setName(vm.getMainSpecifications().getName());
            model.setCreated(DateUtils.asDate((LocalDate)vm.getMainSpecifications().getCreated()));
            model.setOwner(vm.getMainSpecifications().getOwner());
            model.setPcc(vm.getMainSpecifications().getPcc());
            model.setNotification(vm.getMainSpecifications().getNotification());
            model.setDescription(vm.getDescription());
            model.setContent(vm.getContents() == null ? null : vm.getContents().getContent());
            model.setContentType(vm.getContents() == null ? null : vm.getContents().getContentType());
        });
    }

    protected ViewController<ENSExportDocumentContainer, ENSExportDocumentContainerVM> createSpaceController(boolean readonly) {
        return new ENSExportDocumentContainerController(readonly);
    }

    protected ENSExportDocumentContainerVM createVM() {
        return new ENSExportDocumentContainerVM();
    }
}

