/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.gds.entity.handlers.GDSLogDocumentContainerControllerInterceptor;
import com.gridnine.xtrip.client.fx.gds.model.GDSLogDocumentContainer;
import com.gridnine.xtrip.client.fx.gds.model.GDSLogDocumentContainerController;
import com.gridnine.xtrip.client.fx.gds.model.GDSLogDocumentContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.gds.model.GDSLogDocument;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class GDSLogDocumentHandler
extends BaseRootEntityHandler<GDSLogDocument, Void, GDSLogDocumentContainerVM, GDSLogDocumentContainer> {
    public String format(EntityContainer<GDSLogDocument> ctr) {
        return TextUtil.isBlank((String)((GDSLogDocument)ctr.getEntity()).getName()) ? ((GDSLogDocument)ctr.getEntity()).getTitle() : ((GDSLogDocument)ctr.getEntity()).getName();
    }

    public Class<GDSLogDocument> getEntityClass() {
        return GDSLogDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicDocumentIndex.class;
    }

    protected void configureController(List<BiConsumer<DataTransferPackage<GDSLogDocument, Void>, GDSLogDocumentContainerVM>> toVM, List<BiConsumer<GDSLogDocumentContainerVM, DataTransferPackage<GDSLogDocument, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new GDSLogDocumentContainerControllerInterceptor());
        toVM.add((dtp, vm) -> {
            GDSLogDocument model = (GDSLogDocument)dtp.getContainer().getEntity();
            vm.setDescription(model.getDescription());
            vm.getMainSpecifications().setOwner(model.getOwner());
            vm.getMainSpecifications().getOwners().clear();
            vm.getMainSpecifications().getOwners().addAll(model.getOwners());
            vm.getMainSpecifications().setTitle(model.getTitle());
            vm.getMainSpecifications().setName(model.getName());
            vm.getMainSpecifications().setContentType(model.getContentType());
            vm.getMainSpecifications().setGds(model.getGds());
            vm.getMainSpecifications().setPnr(model.getPnr());
            RichData data = new RichData();
            data.setContent(model.getContent());
            data.setContentType(model.getContentType());
            if (data.getContentType() == null) {
                data.setContentType(RichContentHandler.guessContentType((String)model.getName()));
            }
            vm.setContents(data);
            vm.getMainSpecifications().setCreated(DateUtils.asLocalDate((Date)model.getCreated()));
        });
        fromVM.add((vm, dtp) -> {
            GDSLogDocument model = (GDSLogDocument)dtp.getContainer().getEntity();
            model.setTitle(vm.getMainSpecifications().getTitle());
            model.setOwner(vm.getMainSpecifications().getOwner());
            model.getOwners().clear();
            model.getOwners().addAll(vm.getMainSpecifications().getOwners());
            model.setName(vm.getMainSpecifications().getName());
            model.setDescription(vm.getDescription());
            model.setContentType(vm.getMainSpecifications().getContentType());
            model.setGds(vm.getMainSpecifications().getGds());
            model.setPnr(vm.getMainSpecifications().getPnr());
            model.setContent(vm.getContents() == null ? null : vm.getContents().getContent());
            model.setContentType(vm.getContents() == null ? null : vm.getContents().getContentType());
            model.setCreated(DateUtils.asDate((LocalDate)vm.getMainSpecifications().getCreated()));
        });
    }

    protected ViewController<GDSLogDocumentContainer, GDSLogDocumentContainerVM> createSpaceController(boolean readonly) {
        return new GDSLogDocumentContainerController(readonly);
    }

    protected GDSLogDocumentContainerVM createVM() {
        return new GDSLogDocumentContainerVM();
    }
}

