/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.entity.handlers;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.ActionColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.SuperColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.gds.model.GdsTracingDocumentContractRelationVM;
import com.gridnine.xtrip.client.fx.gds.model.GdsTracingDocumentContractRelationsPaneController;
import com.gridnine.xtrip.client.fx.gds.model.GdsTracingDocumentContractRelationsPaneVM;
import com.gridnine.xtrip.client.fx.gds.model.GdsTracingDocumentPartPaneController;
import com.gridnine.xtrip.client.fx.gds.model.GdsTracingDocumentPartPaneVM;
import com.gridnine.xtrip.client.fx.gds.model.GdsTracingDocumentSearchItemVM;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.CurrencyRateData;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Label;

class GdsTracingDocumentPartPaneControllerInterceptor
extends ControllerInterceptor<GdsTracingDocumentPartPaneVM, GdsTracingDocumentPartPaneController> {
    GdsTracingDocumentPartPaneControllerInterceptor() {
    }

    protected Class<GdsTracingDocumentPartPaneController> getControllerClass() {
        return GdsTracingDocumentPartPaneController.class;
    }

    protected void onCreate(GdsTracingDocumentPartPaneController controller) {
        ((ActionColumn)((BigTableWidget)controller.getView().getVariantsCard().getContent()).getColumn("dataLink")).setActionHandler(evt -> {
            if (TextUtil.isBlank((String)((GdsTracingDocumentSearchItemVM)evt.getItem()).getData())) {
                Notifications.get().showFlashNotification("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043f\u043e\u043a\u0430\u0437\u0430.", null);
                return;
            }
            Dialog.message((Node)((Node)evt.getSource()), (String)"\u0414\u0430\u043d\u043d\u044b\u0435", (String)((GdsTracingDocumentSearchItemVM)evt.getItem()).getData());
        });
        ((ActionColumn)((BigTableWidget)controller.getView().getVariantsCard().getContent()).getColumn("flightLink")).setActionHandler(evt -> {
            if (((GdsTracingDocumentSearchItemVM)evt.getItem()).getItem() == null) {
                Notifications.get().showFlashNotification("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043f\u043e\u043a\u0430\u0437\u0430.", null);
                return;
            }
            try {
                Dialog.message((Node)((Node)evt.getSource()), (String)"\u041f\u0435\u0440\u0435\u043b\u0451\u0442", (String)XSUtil.toString((XSSerializable)((GdsTracingDocumentSearchItemVM)evt.getItem()).getItem()));
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        });
        ((ActionColumn)((BigTableWidget)controller.getView().getVariantsCard().getContent()).getColumn("relationsLink")).setActionHandler(evt -> {
            if (((GdsTracingDocumentSearchItemVM)evt.getItem()).getItem() == null || !(((GdsTracingDocumentSearchItemVM)evt.getItem()).getItem() instanceof Flight) || ((Flight)((GdsTracingDocumentSearchItemVM)evt.getItem()).getItem()).getContractRelations().isEmpty()) {
                Notifications.get().showFlashNotification("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u043f\u043e\u043a\u0430\u0437\u0430.", null);
                return;
            }
            new Dialog().setTitle("\u041a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u044b\u0435 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u044f \u0432 \u0430\u0441\u043f\u0435\u043a\u0442\u0435 \u043c\u0443\u043b\u044c\u0442\u0438\u0432\u0430\u043b\u044e\u0442\u043d\u043e\u0441\u0442\u0438").setBody(this.buildRelationsPane((Flight)((GdsTracingDocumentSearchItemVM)evt.getItem()).getItem())).setExpandToParent(true).addButton(DialogButtonStyle.ACCEPT_REGULAR).show((Node)evt.getSource());
        });
        ((SuperColumn)((BigTableWidget)controller.getView().getVariantsCard().getContent()).getColumn("rules")).setActionTextSupplier((i, vm) -> "\u041f\u0440\u0430\u0432\u0438\u043b\u0430");
    }

    private Node buildRelationsPane(Flight flight) {
        if (flight.getContractRelations().isEmpty()) {
            return new Label("\u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043b\u0451\u0442\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u044b\u0445 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439");
        }
        CardsContainer result = new CardsContainer();
        for (Map.Entry entry : flight.getContractRelations().entrySet()) {
            GdsTracingDocumentContractRelationsPaneController controller = new GdsTracingDocumentContractRelationsPaneController(true);
            GdsTracingDocumentContractRelationsPaneVM vm = new GdsTracingDocumentContractRelationsPaneVM();
            String baseCurrency = flight.getGdsCurrencyCode();
            for (GdsContractRelationData relationData : (List)entry.getValue()) {
                GdsTracingDocumentContractRelationVM relationVM = this.buildRelationVM(baseCurrency, relationData);
                vm.getContent().add(relationVM);
                baseCurrency = relationVM.getCurrency();
            }
            controller.readData(vm);
            result.getCards().add((Object)new Card(((DictionaryReference)entry.getKey()).getCode(), UiCardsContainer.Style.EXPANDED, ((DictionaryReference)entry.getKey()).getCaption(), (Node)controller.getView()));
        }
        return result;
    }

    private GdsTracingDocumentContractRelationVM buildRelationVM(String baseCurrency, GdsContractRelationData relationData) {
        GdsTracingDocumentContractRelationVM result = new GdsTracingDocumentContractRelationVM();
        result.setDescription(relationData.getDescription());
        result.setContract(relationData.getGeneralData().getContractData().getContract());
        result.setCalculationTime(DateUtils.asLocalDateTime((Date)relationData.getGeneralData().getCalculationDate()));
        result.setBaseCurrency(baseCurrency);
        result.setCurrency(relationData.getGeneralData().getCurrency() == null ? null : relationData.getGeneralData().getCurrency().getCode());
        ExchangeRateData rate = relationData.getGeneralData().getRate();
        if (rate == null) {
            result.setRate(null);
            result.setRateType(null);
            result.setCoefficient(null);
            result.setRateWithCoefficient(null);
        } else {
            CurrencyRateData currencyRateData = rate.getCurrencyRateData();
            if (currencyRateData == null) {
                result.setRate(null);
                result.setRateType(null);
                result.setCoefficient(null);
                result.setRateWithCoefficient(null);
            } else {
                result.setRate(Double.valueOf(currencyRateData.getRate()));
                result.setRateType(currencyRateData.getType());
                result.setCoefficient(Double.valueOf(rate.getCoefficient()));
                result.setRateWithCoefficient(Double.valueOf(rate.getRateWithCoefficient()));
            }
        }
        return result;
    }
}

