/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableActionHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.gds.model.CommonAirlineSettingsSpace;
import com.gridnine.xtrip.client.fx.gds.model.GdsTracingDocumentRulesItemVM;
import com.gridnine.xtrip.client.fx.gds.model.GdsTracingDocumentRulesPaneController;
import com.gridnine.xtrip.client.fx.gds.model.GdsTracingDocumentRulesPaneVM;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpace;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointSpace;
import com.gridnine.xtrip.client.fx.standard.rules.FullRulesWidget;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.util.Pair;

class GdsTracingDocumentSearchItemDataControllerInterceptor
extends ControllerInterceptor<GdsTracingDocumentRulesPaneVM, GdsTracingDocumentRulesPaneController> {
    GdsTracingDocumentSearchItemDataControllerInterceptor() {
    }

    protected Class<GdsTracingDocumentRulesPaneController> getControllerClass() {
        return GdsTracingDocumentRulesPaneController.class;
    }

    protected void afterReadData(GdsTracingDocumentRulesPaneController controller, final GdsTracingDocumentRulesPaneVM model) {
        super.afterReadData((ViewController)controller, (Object)model);
        DataViewWidget dataViewWidget = (DataViewWidget)controller.getView().getContent();
        dataViewWidget.setHandler((DataViewHandler)new DataViewHandler<GdsTracingDocumentRulesItemVM>(){

            protected int getLimit() {
                return Integer.MAX_VALUE;
            }

            protected int getOffset() {
                return 0;
            }

            protected void reloadData(int offset, List<Pair<String, SortOrder>> sorting) {
                this.getData().setAll((Collection)model.getContent());
            }
        });
        dataViewWidget.reloadData();
    }

    protected void onCreate(GdsTracingDocumentRulesPaneController controller) {
        super.onCreate((ViewController)controller);
        DataViewWidget dataViewWidget = (DataViewWidget)controller.getView().getContent();
        dataViewWidget.getTableView().setActionHandler((TableActionHandler)new TableActionHandler<GdsTracingDocumentRulesItemVM>(){

            public boolean isActive(TableColumn<GdsTracingDocumentRulesItemVM, ?> column, GdsTracingDocumentRulesItemVM item) {
                return "rulesContainer".equals(column.getId()) && item != null && item.getRulesContainer() != null;
            }

            public void onAction(TableColumn<GdsTracingDocumentRulesItemVM, ?> column, GdsTracingDocumentRulesItemVM item) {
                if (!"rulesContainer".equals(column.getId())) {
                    return;
                }
                if (TextUtil.isBlank((String)item.getRuleUid())) {
                    RootEntityEditingService.navigateTo((EntityReference)item.getRulesContainerReference());
                } else {
                    RootEntityEditingService service = RootEntityEditingService.get();
                    if (service == null) {
                        return;
                    }
                    service.open(item.getRulesContainerReference(), false, pane -> {
                        Node editor = pane.getEditor();
                        if (editor instanceof SalesPointSpace) {
                            SalesPointSpace space = (SalesPointSpace)editor;
                            space.expand(space.getRulesTile());
                            this.scrollToRule(item.getRuleUid(), (FullRulesWidget)space.getRulesTile().getFullNode());
                        } else if (editor instanceof ContractSpace) {
                            ContractSpace space = (ContractSpace)editor;
                            space.expand(space.getRulesTile());
                            this.scrollToRule(item.getRuleUid(), (FullRulesWidget)space.getRulesTile().getFullNode());
                        } else if (editor instanceof CommonAirlineSettingsSpace) {
                            CommonAirlineSettingsSpace space = (CommonAirlineSettingsSpace)editor;
                            space.expand(space.getRulesTile());
                            this.scrollToRule(item.getRuleUid(), (FullRulesWidget)space.getRulesTile().getFullNode());
                        }
                    });
                }
            }

            private void scrollToRule(String ruleId, FullRulesWidget widget) {
                widget.selectRule(ruleId);
                widget.scrollToSelected();
            }
        });
    }
}

