/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.rules;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.NestedEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.TripleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.gds.rules.GdsRuleValueRenders;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.PenaltyProperties;
import com.gridnine.xtrip.common.gds.model.TravelDocType;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.TripartiteDiscountDocument;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.LuggageDimensionUnit;
import com.gridnine.xtrip.common.model.dict.LuggageUnit;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.profile.PCCIndex;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public enum GdsRuleResultValueRenderer implements NodeRenderer
{
    PENALTY_PROPERTIES{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(PenaltyProperties.class, readonly);
            widget.setFieldName("\u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0448\u0442\u0440\u0430\u0444\u0430");
            return widget;
        }

        public Object getValue(Node node) {
            return ((EntityBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            EntityReference ref = (EntityReference)value;
            ((EntityBoxWidget)node).setValue(ref);
        }
    }
    ,
    GDS_NAME_LIST{

        public Node createNode(boolean readonly) {
            ValuesWidget paymentTypeNode = new ValuesWidget(readonly);
            paymentTypeNode.setItemsSupplier(Suppliers.createEnumSupplier(GdsName.class));
            return paymentTypeNode;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            ObservableList listType = ((ValuesWidget)node).getValues();
            return listType.toArray(new GdsName[listType.size()]);
        }

        public void setValue(Node node, Object value) {
            if (value != null) {
                GdsName[] arrayType = (GdsName[])value;
                ((ValuesWidget)node).getValues().setAll(Arrays.asList(arrayType));
            }
        }
    }
    ,
    GDS_ACCOUNT_LIST{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(BaseGdsAccount.class, readonly);
            widget.setListParametersSupplier(GdsRuleValueRenders::getGdsAccount);
            widget.setFieldName("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            return widget;
        }

        public Object getValue(Node node) {
            ArrayList<EntityReference> result = new ArrayList<EntityReference>();
            if (node == null) {
                return result;
            }
            ObservableList list = ((MultiEntityWidget)node).getValues();
            for (EntityReference ref : list) {
                if (result.contains(ref)) continue;
                result.add(ref);
            }
            return result;
        }

        public void setValue(Node node, Object value) {
            Collection listRef;
            if (node != null && value != null && !(listRef = (Collection)value).isEmpty()) {
                VMHelper.transfer((Collection)listRef, (Collection)((MultiEntityWidget)node).getValues());
            }
        }
    }
    ,
    GDS_ACCOUNT{

        public Node createNode(boolean readonly) {
            EntityBoxWidget widget = new EntityBoxWidget(BaseGdsAccount.class, readonly);
            widget.setListParametersSupplier(GdsRuleValueRenders::getGdsAccount);
            widget.setFieldName("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((EntityBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (value == null) {
                return;
            }
            ((EntityBoxWidget)node).setValue((EntityReference)value);
        }
    }
    ,
    EXTENDED_LUGGAGE{

        public Node createNode(boolean readonly) {
            PopupWidget widget = new PopupWidget();
            GridContainer container = new GridContainer();
            container.setColumnsCount(1);
            container.setAdaptive(true);
            IntValueWidget piecesWidget = new IntValueWidget(readonly);
            IntValueWidget weightWidget = new IntValueWidget(readonly);
            DictBoxWidget weightUnitWidget = new DictBoxWidget(LuggageUnit.class, readonly);
            IntValueWidget lengthWidget = new IntValueWidget(readonly);
            IntValueWidget widthWidget = new IntValueWidget(readonly);
            IntValueWidget heightWidget = new IntValueWidget(readonly);
            IntValueWidget dimensionsSumWidget = new IntValueWidget(readonly);
            ComboBoxWidget dimensionUnitWidget = new ComboBoxWidget(readonly);
            dimensionUnitWidget.setItemsSupplier(() -> Arrays.asList(LuggageDimensionUnit.values()));
            GridCell piecesCell = new GridCell((Node)piecesWidget);
            piecesCell.setCaption("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043c\u0435\u0441\u0442");
            GridCell weightCell = new GridCell((Node)weightWidget);
            weightCell.setCaption("\u0412\u0435\u0441");
            GridCell weightUnitCell = new GridCell((Node)weightUnitWidget);
            weightUnitCell.setCaption("\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0432\u0435\u0441\u0430");
            GridCell lengthCell = new GridCell((Node)lengthWidget);
            lengthCell.setCaption("\u0414\u043b\u0438\u043d\u0430");
            GridCell widthCell = new GridCell((Node)widthWidget);
            widthCell.setCaption("\u0428\u0438\u0440\u0438\u043d\u0430");
            GridCell heightCell = new GridCell((Node)heightWidget);
            heightCell.setCaption("\u0412\u044b\u0441\u043e\u0442\u0430");
            GridCell dimensionsSumCell = new GridCell((Node)dimensionsSumWidget);
            dimensionsSumCell.setCaption("\u0421\u0443\u043c\u043c\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0439");
            GridCell dimensionUnitCell = new GridCell((Node)dimensionUnitWidget);
            dimensionUnitCell.setCaption("\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0440\u0430\u0437\u043c\u0435\u0440\u0430");
            container.getCells().add(0, (Object)piecesCell);
            container.getCells().add(1, (Object)weightCell);
            container.getCells().add(2, (Object)weightUnitCell);
            container.getCells().add(3, (Object)lengthCell);
            container.getCells().add(4, (Object)widthCell);
            container.getCells().add(5, (Object)heightCell);
            container.getCells().add(6, (Object)dimensionsSumCell);
            container.getCells().add(7, (Object)dimensionUnitCell);
            widget.setFieldName("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0431\u0430\u0433\u0430\u0436\u0430");
            widget.setView((Node)container);
            widget.setActionText("\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0431\u0430\u0433\u0430\u0436\u0430");
            return widget;
        }

        public Object getValue(Node node) {
            PopupWidget widget = (PopupWidget)node;
            GridContainer container = (GridContainer)widget.getView();
            ObservableList listCells = container.getCells();
            GridCell piecesCell = (GridCell)listCells.get(0);
            GridCell weightCell = (GridCell)listCells.get(1);
            GridCell weightUnitCell = (GridCell)listCells.get(2);
            GridCell lengthCell = (GridCell)listCells.get(3);
            GridCell widthCell = (GridCell)listCells.get(4);
            GridCell heightCell = (GridCell)listCells.get(5);
            GridCell dimensionsSumCell = (GridCell)listCells.get(6);
            GridCell dimensionUnitCell = (GridCell)listCells.get(7);
            IntValueWidget piecesWidget = (IntValueWidget)piecesCell.getPayload();
            IntValueWidget weightWidget = (IntValueWidget)weightCell.getPayload();
            DictBoxWidget weightUnitWidget = (DictBoxWidget)weightUnitCell.getPayload();
            IntValueWidget lengthWidget = (IntValueWidget)lengthCell.getPayload();
            IntValueWidget widthWidget = (IntValueWidget)widthCell.getPayload();
            IntValueWidget heightWidget = (IntValueWidget)heightCell.getPayload();
            IntValueWidget dimensionsSumWidget = (IntValueWidget)dimensionsSumCell.getPayload();
            ComboBoxWidget dimensionUnitWidget = (ComboBoxWidget)dimensionUnitCell.getPayload();
            ExtendedLuggageInfo value = new ExtendedLuggageInfo();
            value.setPieces((Integer)piecesWidget.getValue());
            value.setWeight((Integer)weightWidget.getValue());
            value.setWeightUnit(weightUnitWidget.getValue());
            value.setLength((Integer)lengthWidget.getValue());
            value.setWidth((Integer)widthWidget.getValue());
            value.setHeight((Integer)heightWidget.getValue());
            value.setDimensionsSum((Integer)dimensionsSumWidget.getValue());
            value.setDimensionUnit((LuggageDimensionUnit)dimensionUnitWidget.getValue());
            return value;
        }

        public void setValue(Node node, Object value) {
            if (value == null) {
                return;
            }
            PopupWidget widget = (PopupWidget)node;
            GridContainer container = (GridContainer)widget.getView();
            ObservableList listCells = container.getCells();
            GridCell piecesCell = (GridCell)listCells.get(0);
            GridCell weightCell = (GridCell)listCells.get(1);
            GridCell weightUnitCell = (GridCell)listCells.get(2);
            GridCell lengthCell = (GridCell)listCells.get(3);
            GridCell widthCell = (GridCell)listCells.get(4);
            GridCell heightCell = (GridCell)listCells.get(5);
            GridCell dimensionsSumCell = (GridCell)listCells.get(6);
            GridCell dimensionUnitCell = (GridCell)listCells.get(7);
            IntValueWidget piecesWidget = (IntValueWidget)piecesCell.getPayload();
            IntValueWidget weightWidget = (IntValueWidget)weightCell.getPayload();
            DictBoxWidget weightUnitWidget = (DictBoxWidget)weightUnitCell.getPayload();
            IntValueWidget lengthWidget = (IntValueWidget)lengthCell.getPayload();
            IntValueWidget widthWidget = (IntValueWidget)widthCell.getPayload();
            IntValueWidget heightWidget = (IntValueWidget)heightCell.getPayload();
            IntValueWidget dimensionsSumWidget = (IntValueWidget)dimensionsSumCell.getPayload();
            ComboBoxWidget dimensionUnitWidget = (ComboBoxWidget)dimensionUnitCell.getPayload();
            ExtendedLuggageInfo luggageInfo = (ExtendedLuggageInfo)value;
            piecesWidget.setValue((Number)luggageInfo.getPieces());
            weightWidget.setValue((Number)luggageInfo.getWeight());
            weightUnitWidget.setValue(luggageInfo.getWeightUnit());
            lengthWidget.setValue((Number)luggageInfo.getLength());
            widthWidget.setValue((Number)luggageInfo.getWidth());
            heightWidget.setValue((Number)luggageInfo.getHeight());
            dimensionsSumWidget.setValue((Number)luggageInfo.getDimensionsSum());
            dimensionUnitWidget.setValue((Object)luggageInfo.getDimensionUnit());
        }
    }
    ,
    FARE_PRICING{

        public Node createNode(boolean readonly) {
            PopupWidget widget = new PopupWidget();
            GridContainer container = new GridContainer();
            container.setColumnsCount(1);
            container.setAdaptive(true);
            BooleanValueWidget defaultPricingWidget = new BooleanValueWidget(true, readonly);
            TripleValueWidget publicFareWidget = new TripleValueWidget(true, readonly);
            TripleValueWidget refundableAnyWidget = new TripleValueWidget(true, readonly);
            GridCell defaultPricingCell = new GridCell((Node)defaultPricingWidget);
            defaultPricingCell.setCaption("\u0420\u0430\u0441\u0447\u0435\u0442 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
            GridCell publicFareCell = new GridCell((Node)publicFareWidget);
            publicFareCell.setCaption("Public Fare");
            GridCell refundableAnyCell = new GridCell((Node)refundableAnyWidget);
            refundableAnyCell.setCaption("Refundable Any");
            container.getCells().add(0, (Object)defaultPricingCell);
            container.getCells().add(1, (Object)publicFareCell);
            container.getCells().add(2, (Object)refundableAnyCell);
            widget.setFieldName("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438");
            widget.setView((Node)container);
            widget.setActionText("\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438");
            return widget;
        }

        public Object getValue(Node node) {
            PopupWidget widget = (PopupWidget)node;
            GridContainer container = (GridContainer)widget.getView();
            ObservableList listCells = container.getCells();
            GridCell defaultPricingCell = (GridCell)listCells.get(0);
            GridCell publicFareCell = (GridCell)listCells.get(1);
            GridCell refundableAnyCell = (GridCell)listCells.get(2);
            BooleanValueWidget defaultPricingWidget = (BooleanValueWidget)defaultPricingCell.getPayload();
            TripleValueWidget publicFareWidget = (TripleValueWidget)publicFareCell.getPayload();
            TripleValueWidget refundableAnyWidget = (TripleValueWidget)refundableAnyCell.getPayload();
            FarePricingParameters value = new FarePricingParameters();
            value.setDefaultPricing(defaultPricingWidget.getValue());
            value.setPublicFare(publicFareWidget.getValue());
            value.setRefundableAny(refundableAnyWidget.getValue());
            return value;
        }

        public void setValue(Node node, Object value) {
            if (value == null) {
                return;
            }
            PopupWidget widget = (PopupWidget)node;
            GridContainer container = (GridContainer)widget.getView();
            ObservableList listCells = container.getCells();
            GridCell defaultPricingCell = (GridCell)listCells.get(0);
            GridCell publicFareCell = (GridCell)listCells.get(1);
            GridCell refundableAnyCell = (GridCell)listCells.get(2);
            BooleanValueWidget defaultPricingWidget = (BooleanValueWidget)defaultPricingCell.getPayload();
            TripleValueWidget publicFareWidget = (TripleValueWidget)publicFareCell.getPayload();
            TripleValueWidget refundableAnyWidget = (TripleValueWidget)refundableAnyCell.getPayload();
            FarePricingParameters farePricingParameters = (FarePricingParameters)value;
            defaultPricingWidget.setValue(farePricingParameters.isDefaultPricing());
            publicFareWidget.setValue(farePricingParameters.getPublicFare());
            refundableAnyWidget.setValue(farePricingParameters.getRefundableAny());
        }
    }
    ,
    TRIPARTITE_DISCOUNT_DOCUMENT{

        public Node createNode(boolean readonly) {
            PopupWidget widget = new PopupWidget();
            GridContainer container = new GridContainer();
            container.setColumnsCount(1);
            container.setAdaptive(true);
            TextFieldWidget codeWidget = new TextFieldWidget(readonly);
            TextFieldWidget numberWidget = new TextFieldWidget(readonly);
            GridCell codeCell = new GridCell((Node)codeWidget);
            codeCell.setCaption(L10n.get((String)Messages.render_tripartiteDiscountDocumentCode));
            GridCell numberCell = new GridCell((Node)numberWidget);
            numberCell.setCaption(L10n.get((String)Messages.render_tripartiteDiscountDocumentNumber));
            container.getCells().add(0, (Object)codeCell);
            container.getCells().add(1, (Object)numberCell);
            widget.setFieldName(L10n.get((String)Messages.ruleAction_setTripartiteDiscountDocument_fieldName));
            widget.setView((Node)container);
            widget.setActionText(L10n.get((String)Messages.ruleAction_setTripartiteDiscountDocument_actionText));
            return widget;
        }

        public Object getValue(Node node) {
            PopupWidget widget = (PopupWidget)node;
            GridContainer container = (GridContainer)widget.getView();
            ObservableList listCells = container.getCells();
            GridCell codeCell = (GridCell)listCells.get(0);
            GridCell numberCell = (GridCell)listCells.get(1);
            TextFieldWidget codeWidget = (TextFieldWidget)codeCell.getPayload();
            TextFieldWidget numberWidget = (TextFieldWidget)numberCell.getPayload();
            TripartiteDiscountDocument result = new TripartiteDiscountDocument();
            result.setCode(codeWidget.getValue());
            result.setNumber(numberWidget.getValue());
            return result;
        }

        public void setValue(Node node, Object value) {
            if (value == null) {
                return;
            }
            PopupWidget widget = (PopupWidget)node;
            GridContainer container = (GridContainer)widget.getView();
            ObservableList listCells = container.getCells();
            GridCell codeCell = (GridCell)listCells.get(0);
            GridCell numberCell = (GridCell)listCells.get(1);
            TextFieldWidget codeWidget = (TextFieldWidget)codeCell.getPayload();
            TextFieldWidget numberWidget = (TextFieldWidget)numberCell.getPayload();
            TripartiteDiscountDocument doc = (TripartiteDiscountDocument)value;
            codeWidget.setValue(doc.getCode());
            numberWidget.setValue(doc.getNumber());
        }
    }
    ,
    TRAVEL_DOC_TYPE{

        public Node createNode(boolean readonly) {
            ComboBoxWidget widget = new ComboBoxWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(TravelDocType.class));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            ((ComboBoxWidget)node).setValue((Object)((TravelDocType)value));
        }
    }
    ,
    PCC_REF{

        public Node createNode(boolean readonly) {
            NestedEntityBoxWidget widget = new NestedEntityBoxWidget(SalesPoint.class, Pcc.class, false);
            widget.setNestedReferenceBuilder(idx -> {
                PCCIndex index = (PCCIndex)idx;
                return new NestedEntityReference(idx.getSource(), idx.getNavigationKey(), Pcc.class, String.format("%s - %s (%s)", index.getCode(), index.getGdsName(), index.getSource()));
            });
            widget.setListParametersSupplier(() -> {
                IndexListParameters params = new IndexListParameters();
                params.setIndexType(PCCIndex.class);
                TableColumnSettings salesPoint = new TableColumnSettings();
                salesPoint.setId(PCCIndex.Property.salesPoint.name());
                TableColumnSettings gdsName = new TableColumnSettings();
                gdsName.setId(PCCIndex.Property.gdsName.name());
                TableColumnSettings code = new TableColumnSettings();
                code.setId(PCCIndex.Property.code.name());
                params.getColumns().add(salesPoint);
                params.getColumns().add(gdsName);
                params.getColumns().add(code);
                params.getFilters().add(salesPoint);
                return params;
            });
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((NestedEntityBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null || value == null) {
                return;
            }
            ((NestedEntityBoxWidget)node).setValue((EntityReference)((NestedEntityReference)value));
        }

        @Override
        public void setReadonly(boolean readonly, Node node) {
            ((NestedEntityBoxWidget)node).getViewState().setReadonly(readonly);
        }
    };


    public void setReadonly(boolean readonly, Node node) {
        ((HasViewState)node).getViewState().setReadonly(readonly);
    }
}

