/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.rules;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRenderer;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.gds.rules.ConnectionRestrictionValue;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public enum GdsRuleValueRenders implements RuleValueRenderer
{
    ROUTE_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(RouteType.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        public boolean isValueEmpty(Node node) {
            return node == null || ((ValuesWidget)node).getValues().isEmpty();
        }
    }
    ,
    GDS_ACCOUNTS{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(BaseGdsAccount.class, readonly);
            widget.setFieldName("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            widget.setListParametersSupplier(GdsRuleValueRenders::getGdsAccount);
            return widget;
        }

        public Object getValue(Node node) {
            ArrayList<EntityReference> result = new ArrayList<EntityReference>();
            if (node == null) {
                return result;
            }
            ObservableList list = ((MultiEntityWidget)node).getValues();
            for (EntityReference ref : list) {
                if (result.contains(ref)) continue;
                result.add(ref);
            }
            return result;
        }

        public void setValue(Node node, Object value) {
            List listRef;
            if (node != null && value != null && !(listRef = (List)value).isEmpty()) {
                VMHelper.transfer((Collection)listRef, (Collection)((MultiEntityWidget)node).getValues());
            }
        }

        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }
    }
    ,
    CONNECTION_TIME_RESTRICTION{

        public boolean isValueEmpty(Node node) {
            if (node == null) {
                return true;
            }
            PopupWidget widget = (PopupWidget)node;
            String codes = ((Pane)widget.getView()).codesWidget.getValue();
            Integer time = (Integer)((Pane)widget.getView()).timeWidget.getValue();
            return !(!TextUtil.isBlank((String)codes) && !codes.equals("*") || time != null && time > 0);
        }

        public Node createNode(boolean readonly) {
            PopupWidget result = new PopupWidget();
            result.setView((Node)new Pane(readonly));
            result.setActionText("\u0414\u0435\u0442\u0430\u043b\u0438");
            result.setFieldName("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439 \u043d\u0430 \u0441\u0442\u044b\u043a\u043e\u0432\u043a\u0443");
            result.setDialogConfigurator(dialog -> dialog.setExpandToParent(false));
            result.setDialogCloseHandler(() -> this.updateInfo((PopupWidget<Pane>)result));
            this.updateInfo((PopupWidget<Pane>)result);
            return result;
        }

        public Object getValue(Node node) {
            if (node == null || this.isValueEmpty(node)) {
                return null;
            }
            PopupWidget widget = (PopupWidget)node;
            ConnectionRestrictionValue result = new ConnectionRestrictionValue();
            result.getAirportCodes().addAll(TextUtil.string2List((String)((Pane)widget.getView()).codesWidget.getValue(), (String)","));
            result.setMinConnectionTimeInMinutes(((Integer)((Pane)widget.getView()).timeWidget.getValue()).intValue());
            return result;
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            PopupWidget widget = (PopupWidget)node;
            ConnectionRestrictionValue data = (ConnectionRestrictionValue)value;
            ((Pane)widget.getView()).codesWidget.setValue(data == null ? "*" : TextUtil.join((String)",", (Iterable)data.getAirportCodes()));
            ((Pane)widget.getView()).timeWidget.setValue(data == null ? null : Integer.valueOf(data.getMinConnectionTimeInMinutes()));
            this.updateInfo((PopupWidget<Pane>)widget);
        }

        private void updateInfo(PopupWidget<Pane> widget) {
            if (this.isValueEmpty((Node)widget)) {
                widget.setInfoText("\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b");
            } else {
                widget.setInfoText(((Pane)widget.getView()).timeWidget.getValue() + " \u043c\u0438\u043d\u0443\u0442 \u0434\u043b\u044f " + ((Pane)widget.getView()).codesWidget.getValue());
            }
        }

        class Pane
        extends GridContainer
        implements HasViewState {
            final TextFieldWidget codesWidget;
            final IntValueWidget timeWidget;

            Pane(boolean readonly) {
                super(1);
                this.codesWidget = new TextFieldWidget(readonly);
                this.codesWidget.setValue("*");
                GridCell cell = new GridCell("\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438", (Node)this.codesWidget);
                cell.setHelp(() -> new QuickHelp("<html>\u041a\u043e\u0434\u044b \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439 \u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e<br>\u0438\u043b\u0438 *, \u0435\u0441\u043b\u0438 \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u043c\u043e \u043a \u043b\u044e\u0431\u043e\u0439 \u0430/\u043a."));
                this.getCells().add((Object)cell);
                this.timeWidget = new IntValueWidget(readonly);
                this.timeWidget.setValueValidator(time -> time != null && time >= 0);
                cell = new GridCell("\u0412\u0440\u0435\u043c\u044f", (Node)this.timeWidget);
                cell.setHelp(() -> new QuickHelp("<html>\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u0441\u0442\u044b\u043a\u043e\u0432\u043a\u0438 \u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445."));
                this.getCells().add((Object)cell);
                this.timeWidget.getViewState().stateProperty().bind((ObservableValue)this.codesWidget.getViewState().stateProperty());
            }

            public ViewState getViewState() {
                return this.codesWidget.getViewState();
            }
        }
    };


    public String getId() {
        return this.name();
    }

    public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
        RuleProperty property = ruleRestriction.getProperty();
        StringBuilder builder = new StringBuilder();
        property.buildInfo(builder, ruleRestriction.getCondition(), ruleRestriction.getValue());
        out.accept(builder.toString());
    }

    public void setReadonly(boolean readonly, Node node) {
        ((HasViewState)node).getViewState().setReadonly(readonly);
    }

    protected static IndexListParameters<BaseGdsAccount, ?> getGdsAccount() {
        return EntityIndexHandler.forIndexClass(GdsAccountIndex.class).createListParameters();
    }
}

