/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.sirena2000.console;

import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.gds.sirena2000.console.SirenaConsolePane;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class ParametersData
implements Serializable {
    private static final long serialVersionUID = -1453582180661021079L;
    private EntityReference<BaseGdsAccount> gdsAccount;
    private EntityReference<Organization> agency;
    private EntityReference<Organization> subAgency;
    private EntityReference<Organization> client;
    private EntityReference<SalesPoint> salesPoint;
    private EntityReference<Person> agent;
    private EntityReference<Person> customer;
    private boolean secured;
    private boolean privileged;
    private String request;

    static void save(SirenaConsolePane pane) {
        ParametersData data = new ParametersData();
        data.gdsAccount = pane.gdsAccountWidget.getValue();
        data.agency = pane.agencyWidget.getValue();
        data.subAgency = pane.subAgencyWidget.getValue();
        data.client = pane.clientWidget.getValue();
        data.salesPoint = pane.salesPointWidget.getValue();
        data.agent = pane.agentWidget.getValue();
        data.customer = pane.customerWidget.getValue();
        data.secured = pane.securedWidget.getValue();
        data.privileged = pane.privilegedWidget.getValue();
        data.request = pane.requestWidget.getValue();
        File folder = new File(Environment.getDataFolder(), "settings");
        folder.mkdirs();
        try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(new File(folder, "sirena-console.ser"))));){
            out.writeObject(data);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    static void restore(SirenaConsolePane pane) {
        ParametersData data;
        File file = new File(Environment.getDataFolder(), "settings/sirena-console.ser");
        if (!file.isFile()) {
            return;
        }
        try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));){
            data = (ParametersData)in.readObject();
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return;
        }
        pane.gdsAccountWidget.setValue(data.gdsAccount);
        pane.agencyWidget.setValue(data.agency);
        pane.subAgencyWidget.setValue(data.subAgency);
        pane.clientWidget.setValue(data.client);
        pane.salesPointWidget.setValue(data.salesPoint);
        pane.agentWidget.setValue(data.agent);
        pane.customerWidget.setValue(data.customer);
        pane.securedWidget.setValue(data.secured);
        pane.privilegedWidget.setValue(data.privileged);
        pane.requestWidget.setValue(data.request);
    }

    private ParametersData() {
    }
}

