/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.handlers.BaseIssueHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IssueService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.standard.helpers.HttpHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.stage.FileChooser;

public class AddAttachmentAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.ATTACHMENT;
    }

    public String getName(RootEntityPane<?, ?> context) {
        return "\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u0435";
    }

    public String getDescription(RootEntityPane<?, ?> context) {
        return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0435";
    }

    public double getWeight() {
        return 61.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && BaseIssue.class.isAssignableFrom(context.getEntityHandler().getEntityClass()) && ((BaseIssueHandler)context.getEntityHandler()).isPostAvailable();
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return !context.getMode().equals((Object)EditingMode.VIEW);
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        if (context.isDataChanged()) {
            Dialog saveDialog = new Dialog().setTitle("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435").setMessage("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f?").addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.AUXILARY, "\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c \u0431\u0435\u0437 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f", () -> Notifications.get().submitTask(() -> {
                context.reloadData();
                FxUtil.waitForFxThread(() -> this.addAttachmentDialog(source, context));
            }, context.getMutex())).addButton(DialogButtonStyle.ACCEPT_REGULAR, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", () -> {
                if (!context.validate()) {
                    return;
                }
                Notifications.get().submitTask(() -> {
                    context.saveData();
                    FxUtil.waitForFxThread(() -> this.addAttachmentDialog(source, context));
                }, context.getMutex());
            });
            saveDialog.show((Node)source);
        } else {
            this.addAttachmentDialog(source, context);
        }
    }

    private void addAttachmentDialog(Control source, RootEntityPane<?, ?> entityPane) {
        EntityReference ref = entityPane.getData().getContainer().toReference();
        FileChooser fc = new FileChooser();
        File initial_dir = ClientSettings.get().getFileChooserDirectory();
        if (UiUtil.isFileValid((File)initial_dir) && initial_dir.isDirectory()) {
            fc.setInitialDirectory(initial_dir);
        } else {
            fc.setInitialDirectory(Environment.getDataFolder());
        }
        File file = fc.showOpenDialog(source.getScene().getWindow());
        if (file != null) {
            ClientSettings.get().setFileChooserDirectory(file.getParentFile());
            ClientSettings.get().save();
            Document document = this.createDocument(source, file);
            if (document != null) {
                Notifications.get().submitTask(() -> {
                    ((IssueService)RpcServiceManager.get().getService(IssueService.class)).addNewAttachment(ServiceInvocationContext.get(), ref, document);
                    Notifications.get().showFlashNotification("\u0424\u0430\u0439\u043b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043a\u0430\u043a \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0435", file.toString());
                    EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(ref, EntityModification.ModificationType.CHANGE)));
                }, entityPane.getMutex());
            }
        }
    }

    public String getId() {
        return "issue-add-attachment";
    }

    private Document createDocument(Control source, File file) {
        Document doc = null;
        if (file != null && file.isFile() && file.canRead()) {
            if (file.length() < 0xA00000L) {
                byte[] fileArray = null;
                try {
                    fileArray = Files.readAllBytes(file.toPath());
                }
                catch (IOException e) {
                    ErrorHandler.handle((Throwable)e);
                }
                if (fileArray != null) {
                    doc = new Document();
                    doc.setContent(fileArray);
                    doc.setCreated(new Date());
                    doc.setName(file.getName());
                    try {
                        doc.setCheckSum(MiscUtil.getCheckSum((byte[])fileArray));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                    doc.setContentType(HttpHelper.detectContentType((String)file.getName()));
                }
            } else {
                Dialog.info((Node)source, (String)"\u0420\u0430\u0437\u043c\u0435\u0440 \u0444\u0430\u0439\u043b\u0430 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 10 \u041c\u0431.");
            }
        }
        return doc;
    }
}

