/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.actions.dialogs.AddPostDialog;
import com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.handlers.BaseIssueHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IssueService;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import javafx.scene.control.Control;

public class AddPostAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.MESSAGE;
    }

    public String getName(RootEntityPane<?, ?> context) {
        return "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c";
    }

    public String getDescription(RootEntityPane<?, ?> context) {
        return "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439";
    }

    public double getWeight() {
        return 51.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && BaseIssue.class.isAssignableFrom(context.getEntityHandler().getEntityClass()) && ((BaseIssueHandler)context.getEntityHandler()).isPostAvailable();
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() != EditingMode.VIEW;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        RootEntityPane.executeAction(context, () -> {
            EntityContainer container = context.getData().getContainer();
            if (TextUtil.isBlank((String)((BaseIssue)container.getEntity()).getTitle())) {
                Notifications.get().showMessages(new Message[]{this.getMessage(Messages.No_name_specified)});
                return;
            }
            if (((BaseIssue)container.getEntity()).getBooking() == null) {
                Notifications.get().showMessages(new Message[]{this.getMessage(Messages.SelectBookingFile)});
                return;
            }
            new AddPostDialog(source, (EntityContainer<BaseIssue>)container, (post, setAssignee) -> Notifications.get().submitTask(() -> {
                ((IssueService)RpcServiceManager.get().getService(IssueService.class)).addNewPost(ServiceInvocationContext.get(), container.toReference(), post, setAssignee.booleanValue());
                Notifications.get().showFlashNotification("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d", null);
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(container.toReference(), EntityModification.ModificationType.CHANGE)));
            }, context.getMutex())).showDialog();
        });
    }

    public String getId() {
        return "issue-add-post";
    }

    private Message getMessage(String text) {
        Message msg = new Message();
        msg.setType(MessageType.WARNING);
        L10nMessage l10 = new L10nMessage();
        l10.setKey(text);
        msg.setMessage(l10);
        return msg;
    }
}

