/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.ExpandedGroupsWidget;
import com.gridnine.xtrip.client.fx.core.util.ListItemStringConverter;
import com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.handlers.IssuePostWidget;
import com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.handlers.IssueTileHelper;
import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.BaseIssuePostsContainerVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.BaseIssueSpaceVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.IssuePostPanel;
import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.IssuePostPanelController;
import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.IssuePostsContainerController;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.common.fx.ibecorp.model.correspondence.IssueUIData;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueIndex;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.geometry.Pos;
import javafx.scene.Node;

public abstract class BaseIssueHandler<E extends BaseIssue, V extends Node, S extends IssueUIData>
extends BaseRootEntityHandler<E, S, BaseIssueSpaceVM, V> {
    static final ListItemStringConverter<IssuePostPanel> POST_CONVERTER = (panel, idx) -> idx + 1 + ". " + ((IssuePostWidget)panel.getContent()).getCaption();
    static final Function<IssuePostPanel, Pos> CAPTION_ALIGNMENT_SETTER = panel -> {
        boolean isClient = IssuePostPanelController.forView((IssuePostPanel)panel).getData().getContent().isClient();
        return isClient ? Pos.CENTER_LEFT : Pos.CENTER_RIGHT;
    };

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return IssueIndex.class;
    }

    protected BaseIssueSpaceVM createVM() {
        return new BaseIssueSpaceVM();
    }

    protected void configureController(List<BiConsumer<DataTransferPackage<E, S>, BaseIssueSpaceVM>> toVM, List<BiConsumer<BaseIssueSpaceVM, DataTransferPackage<E, S>>> fromVM) {
        toVM.add((dtp, vm) -> {
            BaseIssue model = (BaseIssue)dtp.getContainer().getEntity();
            IssueUIData uiData = (IssueUIData)dtp.getSupplement();
            IssueTileHelper.toVM(model, (IssueUIData)dtp.getSupplement(), vm.getGeneralFull().getMain());
            IssueTileHelper.postsToVM(model, uiData, vm.getGeneralFull().getPosts());
            vm.getGeneralFull().setDescription(model.getDescription());
        });
        fromVM.add((vm, dtp) -> {
            BaseIssue model = (BaseIssue)dtp.getContainer().getEntity();
            IssueTileHelper.fromVM(vm.getGeneralFull().getMain(), model);
            model.setDescription(vm.getGeneralFull().getDescription());
        });
    }

    public abstract boolean isPostAvailable();

    public abstract boolean isAttachmentAvailable();

    static {
        ControllersRegistry.register((ControllerInterceptor)new ControllerInterceptor<BaseIssuePostsContainerVM, IssuePostsContainerController>(){

            protected Class<IssuePostsContainerController> getControllerClass() {
                return IssuePostsContainerController.class;
            }

            protected void onCreate(IssuePostsContainerController controller) {
                ExpandedGroupsWidget widget = (ExpandedGroupsWidget)controller.getView().getContent();
                widget.setConverter(POST_CONVERTER);
                widget.setCaptionAlignment(CAPTION_ALIGNMENT_SETTER);
            }
        });
    }
}

