/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.handlers;

import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.BaseIssueMainPaneVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.BaseIssuePostsContainerVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.IssuePostPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.ibecorp.model.correspondence.IssueUIData;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;

public final class IssueTileHelper {
    private IssueTileHelper() {
    }

    public static void toVM(BaseIssue model, IssueUIData uiData, BaseIssueMainPaneVM vm) {
        vm.setNumber(model.getNumber());
        vm.setTitle(model.getTitle());
        vm.setAssignee(model.getAssignee());
        vm.setStatus(model.getStatus());
        vm.setRelatedToBooingFile(model.getBooking());
        vm.setClient(model.getClient());
        vm.setSubagency(model.getSubagency());
        vm.setAgency(model.getAgency());
        vm.setPhone(uiData.getPhone());
    }

    public static void fromVM(BaseIssueMainPaneVM vm, BaseIssue model) {
        model.setTitle(vm.getTitle());
        model.setAssignee(vm.getAssignee());
        model.setStatus(vm.getStatus());
        model.setBooking(vm.getRelatedToBooingFile());
        model.setClient(vm.getClient());
        model.setSubagency(vm.getSubagency());
        model.setAgency(vm.getAgency());
    }

    static void postsToVM(BaseIssue model, IssueUIData uiData, BaseIssuePostsContainerVM vm) {
        HashMap attUidName = new HashMap();
        uiData.getAttachments().forEach(el -> attUidName.put(el.getDocRef().getUid(), el.getName()));
        HashSet panelsWithAttachment = new HashSet();
        VMHelper.transfer((Collection)model.getPosts(), (Collection)vm.getContent(), mod -> {
            IssuePostPanelVM modVM = new IssuePostPanelVM();
            modVM.getContent().setUid(mod.getUid());
            modVM.getContent().setPost(mod.getContent());
            modVM.getContent().setClient(mod.isClient());
            modVM.getContent().setDate(mod.getDateCreated());
            if (mod.getAuthor() != null) {
                modVM.getContent().setAuthor(mod.getAuthor().toString());
            }
            if (mod.getHotelEmail() != null) {
                modVM.getContent().setHtml(true);
                modVM.getContent().setHotelEmail(mod.getHotelEmail().getSense());
            }
            if (!mod.getAttachments().isEmpty()) {
                modVM.getContent().setAttachments(new ArrayList());
                for (EntityReference docRef : mod.getAttachments()) {
                    String linkName = (String)attUidName.get(docRef.getUid());
                    if (linkName == null) continue;
                    modVM.getContent().getAttachments().add(IssueTileHelper.getDocumentReference(docRef, linkName));
                    panelsWithAttachment.add(docRef.getUid());
                    if (!linkName.equals(mod.getContent())) continue;
                    modVM.getContent().setPost(null);
                }
            }
            return modVM;
        });
        uiData.getAttachments().stream().filter(el -> !panelsWithAttachment.contains(el.getDocRef().getUid())).map(aRef -> {
            IssuePostPanelVM panelVm = new IssuePostPanelVM();
            panelVm.getContent().setDate(aRef.getCreated());
            panelVm.getContent().setPost(null);
            panelVm.getContent().setAttachments(new ArrayList());
            panelVm.getContent().getAttachments().add(IssueTileHelper.getDocumentReference(aRef.getDocRef(), aRef.getName()));
            return panelVm;
        }).collect(Collectors.toCollection(() -> vm.getContent()));
        vm.getContent().sort((o1, o2) -> o1.getContent().getDate() == null ? 1 : (o2.getContent().getDate() == null ? -1 : o1.getContent().getDate().compareTo(o2.getContent().getDate())));
    }

    private static <T extends BaseFileDocument> EntityReference<T> getDocumentReference(EntityReference<T> docRef, String name) {
        EntityReference ref = new EntityReference();
        ref.setUid(docRef.getUid());
        ref.setType(docRef.getType());
        String linkName = name != null ? name : "\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u0435";
        ref.setCaption(linkName);
        return ref;
    }
}

