/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.ibecorp.entity.tasks.BasePrintShipmentDocumentsTask;
import com.gridnine.xtrip.client.fx.ibecorp.entity.tasks.PrintShipmentListDocumentsTask;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;

public class PrintShipmentListDocumentsAction
implements IndexListAction {
    private static final String CHANGE_SETTINGS = Messages.WithChangeSettings;
    private static final String USE_DEFAULT_SETTINGS = Messages.WithoutChangeSettings;

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.PRINT_SHIPMENT_DOCUMENTS;
    }

    public double getWeight() {
        return 31.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ShipmentIndex.class.equals((Object)context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        RadioBoxWidget printModeWidget = new RadioBoxWidget(false);
        printModeWidget.setItemsSupplier(() -> Arrays.asList(USE_DEFAULT_SETTINGS, CHANGE_SETTINGS));
        printModeWidget.setValue((Object)USE_DEFAULT_SETTINGS);
        EntityBoxWidget agentWidget = new EntityBoxWidget(Person.class, false);
        agentWidget.setListParametersSupplier(ControllerInterceptorsHelper::getActiveAgents);
        agentWidget.setValue(Prefetched.getData().getCurrentAgentData().getAgent());
        BooleanValueWidget useDelegateWidget = new BooleanValueWidget(true, false);
        BooleanValueWidget useFacsimileWidget = new BooleanValueWidget(true, false);
        GridContainer gridContainer = new GridContainer(1);
        gridContainer.getCells().addAll((Object[])new GridCell[]{new GridCell(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Agent2, (Node)agentWidget), new GridCell(com.gridnine.xtrip.client.fx.standard.l10n.Messages.useDelegate, (Node)useDelegateWidget), new GridCell(com.gridnine.xtrip.client.fx.standard.l10n.Messages.useFacsimile, (Node)useFacsimileWidget)});
        CardsContainer container = new CardsContainer();
        Card additionalParametersCard = new Card("additionalParameters", UiCardsContainer.Style.COLLAPSED, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Extra_options, (Node)gridContainer);
        container.getCards().add((Object)additionalParametersCard);
        container.setDisable(true);
        printModeWidget.valueProperty().addListener((obj, oldValue, newValue) -> {
            boolean hideAdditionalParameters = !CHANGE_SETTINGS.equals(newValue);
            container.setDisable(hideAdditionalParameters);
            additionalParametersCard.setCollapsed(hideAdditionalParameters);
        });
        VBox wrap = new VBox();
        GridContainer body = new GridContainer(1);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.PrintMode, (Node)printModeWidget);
        cell.setColSpan(Integer.MAX_VALUE);
        cells.add(cell);
        body.getCells().addAll(cells);
        wrap.getChildren().addAll((Object[])new Node[]{body, container});
        new Dialog().setTitle(Messages.PrintSettings).setBody((Node)wrap).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Print, () -> {
            List<EntityReference<Shipment>> selectedItems = context.getSelectedItems().stream().map(EntityIndex::getSource).collect(Collectors.toList());
            BasePrintShipmentDocumentsTask.FinanceDocumentsChangeSettings financeDocumentsChangeSettings = CHANGE_SETTINGS.equals(printModeWidget.getValue()) ? new BasePrintShipmentDocumentsTask.FinanceDocumentsChangeSettings((EntityReference<Person>)agentWidget.getValue(), useDelegateWidget.getValue(), useFacsimileWidget.getValue()) : null;
            Notifications.get().enqueueAsyncTask((ClientTask)new PrintShipmentListDocumentsTask(selectedItems, financeDocumentsChangeSettings));
        }, (BooleanExpression)Bindings.isNotNull((ObservableObjectValue)agentWidget.valueProperty()).or((ObservableBooleanValue)printModeWidget.valueProperty().isEqualTo((Object)USE_DEFAULT_SETTINGS))).show((Node)source);
    }

    public String getId() {
        return "print-shipments-documents";
    }
}

