/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.booking.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.SendBookingDocumentsParametersPaneController;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.SendBookingDocumentsParametersPaneVM;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpModelService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class SendBookingDocumentsToEmailDialog {
    private static final StringConverter<Document> DOCUMENT_STRING_CONVERTER = new StringConverter<Document>(){

        public String toString(Document object) {
            if (object != null) {
                return TextUtil.nonBlank((String)object.getTitle()) ? object.getTitle() : object.getName();
            }
            return "Unnamed document";
        }

        public Document fromString(String string) {
            return null;
        }
    };

    public void showDialog(EntityContainer<BookingFile> bookingCtr) {
        Notifications.get().submitTask(() -> {
            MailDocument mailDocument = ((IbecorpModelService)RpcServiceManager.get().getService(IbecorpModelService.class)).createMailDocument(ServiceInvocationContext.get(), bookingCtr.toReference(), null, new EntityReference[0]);
            this.showDialog(mailDocument);
        }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Notifications_getting_data);
    }

    public void showDialog(EntityReference<? extends BaseEntity> bookingRef, String navigationKey, EntityReference<?> documentRef) {
        Notifications.get().submitTask(() -> {
            MailDocument mailDocument = ((IbecorpModelService)RpcServiceManager.get().getService(IbecorpModelService.class)).createMailDocument(ServiceInvocationContext.get(), bookingRef, navigationKey, new EntityReference[]{documentRef});
            this.showDialog(mailDocument);
        }, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Notifications_getting_data);
    }

    private void showDialog(MailDocument mailDocument) throws Exception {
        Dialog dialog = new Dialog();
        final SendBookingDocumentsParametersPaneController controller = new SendBookingDocumentsParametersPaneController(false);
        SendBookingDocumentsParametersPaneVM model = new SendBookingDocumentsParametersPaneVM();
        controller.getView().getDocumentsNode().setConverter(DOCUMENT_STRING_CONVERTER);
        BooleanBinding availabilityBinding = new BooleanBinding(){
            {
                this.bind(new Observable[]{controller.getRecipients()});
            }

            protected boolean computeValue() {
                return controller.getRecipients().stream().anyMatch(TextUtil::nonBlank);
            }
        };
        RichData body = new RichData();
        body.setContentType(ContentType.HTML);
        body.setContent(mailDocument.getBody().getData());
        List documents = mailDocument.getAttachments().stream().map(mailPart -> {
            Document document = new Document();
            document.setContentType(mailPart.getContentType());
            document.setContent(mailPart.getData());
            document.setName(mailPart.getName());
            document.setTitle(mailPart.getTitle());
            return document;
        }).collect(Collectors.toList());
        model.setBody(body);
        model.setSubject(mailDocument.getSubject());
        model.getRecipients().addAll(mailDocument.getTo().stream().map(MailAddress::getAddress).filter(TextUtil::nonBlank).distinct().collect(Collectors.toList()));
        model.getDocuments().addAll(documents);
        controller.getView().getDocumentsNode().setItemsSupplier(() -> {
            ArrayList<Document> bookingDocuments = new ArrayList<Document>(documents);
            ObservableList selectedDocuments = controller.getView().getDocumentsNode().getValues();
            bookingDocuments.removeIf(arg_0 -> selectedDocuments.contains(arg_0));
            return bookingDocuments;
        }, false);
        controller.readData(model);
        if (TextUtil.isBlank((String)mailDocument.getSubject()) || mailDocument.getBody().getData() == null) {
            Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SendToEmail_EmptySubjectOrBody, (Object[])new Object[0])});
        }
        FxUtil.waitForFxThread(() -> dialog.setTitle(Messages.MailDocumentEditor).setAutoClose(true).setExpandToParent(true).setBody((Node)controller.getView()).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> Notifications.get().submitTask(() -> {
            controller.writeData(model);
            mailDocument.setSubject(model.getSubject());
            mailDocument.getBody().setData(Optional.ofNullable(model.getBody().getContent()).orElse(new byte[0]));
            mailDocument.getTo().clear();
            mailDocument.getTo().addAll(model.getRecipients().stream().filter(Objects::nonNull).map(adr -> {
                MailAddress address = new MailAddress();
                address.setAddress(adr);
                return address;
            }).collect(Collectors.toList()));
            mailDocument.getAttachments().clear();
            mailDocument.getAttachments().addAll(model.getDocuments().stream().filter(Objects::nonNull).map(doc -> {
                MailPart attachment = new MailPart();
                attachment.setContentType(doc.getContentType());
                attachment.setData(doc.getContent());
                attachment.setName(doc.getName());
                attachment.setTitle(doc.getTitle());
                return attachment;
            }).collect(Collectors.toList()));
            ((IbecorpModelService)RpcServiceManager.get().getService(IbecorpModelService.class)).sendMailDocument(ServiceInvocationContext.get(), mailDocument, true);
        }, Messages.SendingMail), (BooleanExpression)availabilityBinding).showGlobal());
    }
}

