/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.booking.controllerinterceptors.hotel;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelParameters;
import com.gridnine.xtrip.client.fx.model.booking.SabreHotelSearchPane;
import com.gridnine.xtrip.client.fx.model.booking.SabreHotelSearchResultItemVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.hotel.HotelSearchConfigurator;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpRpcService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Hotel;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;
import javafx.util.Pair;

public class IbecorpHotelSearchConfigurator
extends HotelSearchConfigurator {
    public void install(BookingFileProductHotelParameters parametersPane, ComboBoxWidget<HotelProvider> provider) {
        parametersPane.getHotelValueNode().setActionHandler((IconShape)StandardIconShapes.SEARCH_12x12, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Hotel_search, node -> {
            SabreHotelSearchPane pane = new SabreHotelSearchPane(false);
            this.configure(pane, (HotelProvider)provider.getValue());
            if (parametersPane.getCityValueNode().getValue() != null) {
                pane.getLocationNode().setValue(parametersPane.getCityValueNode().getValue());
            }
            if (parametersPane.getCountryValueNode().getValue() != null) {
                pane.getCountryNode().setValue(parametersPane.getCountryValueNode().getValue());
            }
            Dialog dialog = new Dialog();
            dialog.setTitle(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Hotel_search).setBody((Node)pane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, Messages.General_Cancel).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Select, () -> {
                SabreHotelSearchResultItemVM vm = (SabreHotelSearchResultItemVM)pane.getSearchResultNode().getTableView().getSelectionModel().getSelectedItem();
                if (vm == null) {
                    return;
                }
                Hotel hotel = vm.getHotel();
                parametersPane.getCodeValueNode().setValue(hotel.getCode());
                parametersPane.getCountryValueNode().setValue(hotel.getCountry());
                parametersPane.getCityValueNode().setValue(hotel.getCity());
                parametersPane.getChainValueNode().setValue(hotel.getBrand() == null ? null : hotel.getBrand().toString());
                parametersPane.getStarsValueNode().setValue((Number)hotel.getStars());
                parametersPane.getHotelValueNode().setValue(hotel.getName());
                parametersPane.getAddressValueNode().setValue(hotel.getAddress() == null ? null : hotel.getAddress().toString());
                parametersPane.getPhoneValueNode().setValue(hotel.getPhone());
                parametersPane.getFaxValueNode().setValue(hotel.getFax());
            }, (BooleanExpression)Bindings.isNotNull((ObservableObjectValue)pane.getSearchResultNode().getTableView().getSelectionModel().selectedItemProperty())).show((Node)node);
        });
    }

    protected DataViewHandler<SabreHotelSearchResultItemVM> createDataViewHandler(final SabreHotelSearchPane pane, final HotelProvider provider) {
        return new DataViewHandler<SabreHotelSearchResultItemVM>(){

            protected void reloadData(int offset, List<Pair<String, SortOrder>> sorting) {
                String hotelId = pane.getHotelIdNode().getValue();
                DictionaryReference country = pane.getCountryNode().getValue();
                DictionaryReference location = pane.getLocationNode().getValue();
                DictionaryReference chain = pane.getChainNode().getValue();
                String name = pane.getNameNode().getValue();
                if (TextUtil.isBlank((String)hotelId) && country == null && location == null && (TextUtil.isBlank((String)name) || name.trim().length() < 2)) {
                    this.getData().clear();
                    return;
                }
                Notifications.get().submitTask(() -> {
                    List hotels = ((IbecorpRpcService)RpcServiceManager.get().getService(IbecorpRpcService.class)).searchHotels2(ServiceInvocationContext.get(), (HotelProvider)(provider != HotelProvider.INTERNAL ? provider : null), hotelId, country, location, chain, name);
                    List vms = hotels.stream().map(hotel -> {
                        SabreHotelSearchResultItemVM vm = new SabreHotelSearchResultItemVM();
                        vm.setHotel(hotel);
                        if (hotel.getCode() != null) {
                            vm.setHotelId(hotel.getCode());
                        }
                        if (hotel.getCountry() != null) {
                            vm.setCountry(hotel.getCountry().toString());
                        }
                        if (hotel.getCity() != null) {
                            vm.setLocation(hotel.getCity().toString());
                        }
                        if (hotel.getBrand() != null) {
                            vm.setChain(hotel.getBrand().toString());
                        }
                        vm.setName(hotel.getName());
                        if (hotel.getAddress() != null) {
                            vm.setAddress(hotel.getAddress().toString());
                        }
                        return vm;
                    }).collect(Collectors.toList());
                    FxUtil.submitToFxThread(() -> this.getData().setAll((Collection)vms));
                }, this.getMutex());
            }

            protected int getOffset() {
                return 0;
            }

            protected int getLimit() {
                return Integer.MAX_VALUE;
            }
        };
    }
}

