/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.contract;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.CompactGroupsWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractAccommodationPanel;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractAdditionalServicesPanelVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractCancellationChargesVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractCancellationPolicyPanel;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractCancellationPolicyPanelVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractClientsGridPanel;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractEarlyCheckInVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractFaresPanel;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractFaresPanelVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractFaresVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractFullContainer;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractLateCheckOutVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractMealVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractPriceListContainer;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractPriceListContainerController;
import com.gridnine.xtrip.client.fx.ibecorp.model.profile.DirectContractPriceListContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpace;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpaceController;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpaceVM;
import com.gridnine.xtrip.client.fx.model.profile.ExtendedSupplierContractMainFullGridPanel;
import com.gridnine.xtrip.client.fx.model.profile.ExtendedSupplierContractMainFullPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.controllerinterceptors.ContractSpaceControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.CompactConverter;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.ibecorp.hotels.RoomSize;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;

public class IbecorpContractSpaceControllerInterceptor
extends ControllerInterceptor<ContractSpaceVM, ContractSpaceController> {
    private static final CompactConverter<DirectContractPriceListContainer> PRICE_LIST_CONVERTER = new CompactConverter(panel -> {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        String name = (String)((DirectContractAccommodationPanel)panel.getAccommodationCard().getContent()).getRoomNameNode().getValue();
        IbecorpContractSpaceControllerInterceptor.join(sb, name);
        RoomSize roomSize = (RoomSize)((DirectContractAccommodationPanel)panel.getAccommodationCard().getContent()).getRoomSizeNode().getValue();
        IbecorpContractSpaceControllerInterceptor.join(sb, roomSize);
        if (sb.length() != 0) {
            sb.append(".");
        }
        TableWidget widget = ((DirectContractFaresPanel)panel.getFaresCard().getContent()).getFaresNode();
        for (DirectContractFaresVM price : widget.getRowsData()) {
            LocalDate endDate;
            int p = sb.length();
            Money fare = price.getFare();
            IbecorpContractSpaceControllerInterceptor.join(sb, fare);
            LocalDate startDate = price.getStartDate();
            if (startDate != null) {
                IbecorpContractSpaceControllerInterceptor.join(sb, Messages.Since);
                IbecorpContractSpaceControllerInterceptor.join(sb, startDate.format(DateTimeFormatter.ofPattern(LocaleManager.get().getCurrentLocaleData().getDateFormatPattern())));
            }
            if ((endDate = price.getEndDate()) != null) {
                IbecorpContractSpaceControllerInterceptor.join(sb, Messages.Po);
                IbecorpContractSpaceControllerInterceptor.join(sb, endDate.format(DateTimeFormatter.ofPattern(LocaleManager.get().getCurrentLocaleData().getDateFormatPattern())));
            }
            List listDays = price.getDaysOfWeek();
            for (DayOfWeek day : listDays) {
                IbecorpContractSpaceControllerInterceptor.join(sb, IbecorpContractSpaceControllerInterceptor.getShortName(day));
            }
            if (sb.length() == p) continue;
            sb.append(";");
        }
        list.add(sb.toString());
        return list;
    });

    private static void join(StringBuilder sb, Object obj) {
        if (null == obj) {
            return;
        }
        String text = obj.toString();
        if (TextUtil.isBlank((String)text)) {
            return;
        }
        if (sb.length() != 0 && sb.charAt(sb.length() - 1) != ' ') {
            sb.append(' ');
        }
        sb.append(text.trim());
    }

    protected void onCreate(ContractSpaceController controller) {
        ((ExtendedSupplierContractMainFullGridPanel)((ExtendedSupplierContractMainFullPanel)controller.getView().getExtendedSupplierContractTile().getFullNode()).getSupplierContractCard().getContent()).getHotelProviderValueNode().valueProperty().addListener((s, o, n) -> {
            this.setTileVisible(controller.getView(), controller.getView().getDirectContractTile(), HotelProvider.INTERNAL == n);
            ((ExtendedSupplierContractMainFullPanel)controller.getView().getExtendedSupplierContractTile().getFullNode()).getDirectContractClientsCard().setHidden(HotelProvider.INTERNAL != n);
        });
        this.setTileVisible(controller.getView(), controller.getView().getDirectContractTile(), false);
        ((ExtendedSupplierContractMainFullPanel)controller.getView().getExtendedSupplierContractTile().getFullNode()).getDirectContractClientsCard().setHidden(true);
        EntityBoxWidgetColumn clientWidget = (EntityBoxWidgetColumn)((DirectContractClientsGridPanel)((ExtendedSupplierContractMainFullPanel)controller.getView().getExtendedSupplierContractTile().getFullNode()).getDirectContractClientsCard().getContent()).getClientsNode().getColumn("client");
        clientWidget.setListParametersSupplier(ControllerInterceptorsHelper::getClients);
        ((CompactGroupsWidget)((DirectContractFullContainer)controller.getView().getDirectContractTile().getFullNode()).getPriceListCard().getContent()).setConverter(PRICE_LIST_CONVERTER);
        CompactGroupsWidget priceListWidget = (CompactGroupsWidget)((DirectContractFullContainer)controller.getView().getDirectContractTile().getFullNode()).getPriceListCard().getContent();
        priceListWidget.setNewViewHandler(view -> {
            IbecorpContractSpaceControllerInterceptor.preparePriceList(view);
            DirectContractPriceListContainer selectedView = (DirectContractPriceListContainer)priceListWidget.getSelectedView();
            if (selectedView != null) {
                DirectContractPriceListContainerController selectedController = new DirectContractPriceListContainerController(selectedView, false);
                DirectContractPriceListContainerVM selectedVM = new DirectContractPriceListContainerVM();
                selectedController.writeData(selectedVM);
                this.copyPrices(selectedVM.getFares());
                this.copyCancellationPolicy(selectedVM.getCancellationPolicy());
                this.copyAdditionalServices(selectedVM.getAdditionalServices());
                DirectContractPriceListContainerController viewController = new DirectContractPriceListContainerController(view, false);
                viewController.readData(selectedVM);
            }
        });
    }

    protected void afterReadData(ContractSpaceController controller, ContractSpaceVM model) {
        ((CompactGroupsWidget)((DirectContractFullContainer)controller.getView().getDirectContractTile().getFullNode()).getPriceListCard().getContent()).getViews().forEach(v -> {
            IbecorpContractSpaceControllerInterceptor.preparePriceList(v);
            IbecorpContractSpaceControllerInterceptor.onNonCancelableChanged(v, ((DirectContractCancellationPolicyPanel)v.getCancellationPolicyCard().getContent()).getNonCancelableNode().getValue());
        });
    }

    private static void preparePriceList(DirectContractPriceListContainer view) {
        ((DirectContractCancellationPolicyPanel)view.getCancellationPolicyCard().getContent()).getNonCancelableNode().setConverter(Converters.boolConverter((String)Messages.DirectContractNonCancelable, (String)Messages.DirectContractCancelable));
        ((DirectContractCancellationPolicyPanel)view.getCancellationPolicyCard().getContent()).getNonCancelableNode().valueProperty().addListener((s, o, n) -> IbecorpContractSpaceControllerInterceptor.onNonCancelableChanged(view, n));
    }

    private static void onNonCancelableChanged(DirectContractPriceListContainer view, boolean n) {
        ((DirectContractCancellationPolicyPanel)view.getCancellationPolicyCard().getContent()).getCancellationChargesCell().setHidden(n);
    }

    private void setTileVisible(ContractSpace view, Tile<Node, ?> tile, boolean visible) {
        if (visible) {
            view.getHiddenTiles().remove(tile);
            ContractSpaceControllerInterceptor.getHiddenTilesFromOthersPlugins().remove(tile);
        } else {
            view.getHiddenTiles().add(tile);
            ContractSpaceControllerInterceptor.getHiddenTilesFromOthersPlugins().add(tile);
        }
    }

    private void copyPrices(DirectContractFaresPanelVM faresVM) {
        faresVM.getFares().replaceAll(priceVM -> {
            DirectContractFaresVM vm = new DirectContractFaresVM();
            vm.setEndDate(priceVM.getEndDate());
            vm.setStartDate(priceVM.getStartDate());
            vm.getDaysOfWeek().addAll(priceVM.getDaysOfWeek());
            vm.setFare(MoneyHelper.cloneMoney((Money)priceVM.getFare()));
            vm.setRackRate(MoneyHelper.cloneMoney((Money)priceVM.getRackRate()));
            return vm;
        });
    }

    private void copyCancellationPolicy(DirectContractCancellationPolicyPanelVM cancellationPolicy) {
        cancellationPolicy.getCancellationCharges().replaceAll(cancellationChargesVM -> {
            DirectContractCancellationChargesVM vm = new DirectContractCancellationChargesVM();
            vm.setDays(cancellationChargesVM.getDays());
            vm.setAnchor(cancellationChargesVM.getAnchor());
            vm.setPenalty(IbecorpContractSpaceControllerInterceptor.cloneRateMoney(cancellationChargesVM.getPenalty()));
            vm.setVatRate(cancellationChargesVM.getVatRate());
            return vm;
        });
    }

    private void copyAdditionalServices(DirectContractAdditionalServicesPanelVM additionalServices) {
        additionalServices.getMeals().replaceAll(mealVM -> {
            DirectContractMealVM vm = new DirectContractMealVM();
            vm.setMeal(mealVM.getMeal());
            vm.setPrice(MoneyHelper.cloneMoney((Money)mealVM.getPrice()));
            vm.setVatRate(mealVM.getVatRate());
            return vm;
        });
        additionalServices.getEarlyCheckIn().replaceAll(earlyCheckInVM -> {
            DirectContractEarlyCheckInVM vm = new DirectContractEarlyCheckInVM();
            vm.setStartTime(earlyCheckInVM.getStartTime());
            vm.setEndTime(earlyCheckInVM.getEndTime());
            vm.setPrice(IbecorpContractSpaceControllerInterceptor.cloneRateMoney(earlyCheckInVM.getPrice()));
            vm.setVatRate(earlyCheckInVM.getVatRate());
            return vm;
        });
        additionalServices.getLateCheckOut().replaceAll(lateCheckOutVM -> {
            DirectContractLateCheckOutVM vm = new DirectContractLateCheckOutVM();
            vm.setStartTime(lateCheckOutVM.getStartTime());
            vm.setEndTime(lateCheckOutVM.getEndTime());
            vm.setPrice(IbecorpContractSpaceControllerInterceptor.cloneRateMoney(lateCheckOutVM.getPrice()));
            vm.setVatRate(lateCheckOutVM.getVatRate());
            return vm;
        });
    }

    private static RateMoney cloneRateMoney(RateMoney money) {
        if (money == null) {
            return null;
        }
        RateMoney newMoney = new RateMoney();
        newMoney.setMoney(MoneyHelper.cloneMoney((Money)money.getMoney()));
        newMoney.setRate(money.getRate());
        return newMoney;
    }

    protected Class<ContractSpaceController> getControllerClass() {
        return ContractSpaceController.class;
    }

    public static String getShortName(DayOfWeek weekDay) {
        if (null == weekDay) {
            return null;
        }
        switch (weekDay) {
            case MONDAY: {
                return Messages.Monday;
            }
            case TUESDAY: {
                return Messages.Tuesday;
            }
            case WEDNESDAY: {
                return Messages.Wednesday;
            }
            case THURSDAY: {
                return Messages.Thursday;
            }
            case FRIDAY: {
                return Messages.Friday;
            }
            case SATURDAY: {
                return Messages.Saturday2;
            }
            case SUNDAY: {
                return Messages.Sunday2;
            }
        }
        return "unknown";
    }
}

