/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpRpcService;
import com.gridnine.xtrip.common.hotels2.model.HotelSummary;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.util.Pair;

class HotelDataPane {
    final HotelProvider provider;
    private final GridContainer container;
    private final DataViewWidget<HotelSummary> dataView;
    final TextFieldWidget patternWidget;

    HotelDataPane(HotelProvider pr) {
        this.provider = pr;
        this.container = new GridContainer(4);
        this.dataView = new DataViewWidget(true);
        this.patternWidget = new TextFieldWidget(false);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        cells.add(new GridCell(Messages.Name, (Node)this.patternWidget));
        HyperlinkWidget link = new HyperlinkWidget();
        link.setText(Messages.Search);
        cells.add(new GridCell((Node)link));
        link.setOnAction(evt -> this.dataView.reloadData());
        cells.add(GridCell.NEW_ROW_MARKER);
        GridCell cell = new GridCell(this.dataView);
        cell.setColSpan(4);
        cells.add(cell);
        this.container.getCells().addAll(cells);
        TableColumnSettings col = new TableColumnSettings();
        col.setId("number");
        col.setDisplayName(Messages.Number);
        col.setSortable(false);
        this.dataView.getTableView().getColumns().add((Object)col.createColumn(HotelSummary::getNumber));
        col = new TableColumnSettings();
        col.setId("name");
        col.setDisplayName(Messages.Name);
        col.setSortable(false);
        this.dataView.getTableView().getColumns().add((Object)col.createColumn(HotelSummary::getName));
        col = new TableColumnSettings();
        col.setId("location");
        col.setDisplayName(Messages.Location);
        col.setSortable(false);
        this.dataView.getTableView().getColumns().add((Object)col.createColumn(item -> {
            StringBuilder sb = new StringBuilder();
            Address address = item.getAddress();
            if (address != null) {
                String text;
                if (address.getCountry() != null) {
                    text = MiscUtil.guarded((String)address.getCountry().getCaption());
                    sb.append(text);
                    if (text.length() != 0) {
                        sb.append(", ");
                    }
                }
                if (address.getCity() != null) {
                    text = MiscUtil.guarded((String)address.getCity().getCaption());
                    sb.append(text);
                    if (text.length() != 0) {
                        sb.append(", ");
                    }
                }
                if (address.getAddress() != null) {
                    sb.append(MiscUtil.guarded((String)address.getAddress().toString()));
                }
            }
            if (sb.length() == 0) {
                sb.append("\u2014");
            }
            return sb.toString();
        }));
        this.dataView.setHandler((DataViewHandler)new DataViewHandler<HotelSummary>(){

            protected void reloadData(int offset, List<Pair<String, SortOrder>> sorting) {
                String pattern = HotelDataPane.this.patternWidget.getValue();
                if (TextUtil.isBlank((String)pattern)) {
                    this.getData().clear();
                    return;
                }
                Notifications.get().submitTask(() -> {
                    List res = ((IbecorpRpcService)RpcServiceManager.get().getService(IbecorpRpcService.class)).searchHotels(ServiceInvocationContext.get(), HotelDataPane.this.patternWidget.getValue());
                    FxUtil.submitToFxThread(() -> this.getData().setAll((Collection)res));
                }, this.getMutex());
            }

            protected int getOffset() {
                return 0;
            }

            protected int getLimit() {
                return Integer.MAX_VALUE;
            }
        });
        FxUtil.submitToFxThread(() -> this.dataView.reloadData());
    }

    GridContainer getPane() {
        return this.container;
    }

    DataViewWidget<HotelSummary> getDataView() {
        return this.dataView;
    }
}

