/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.site;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ValuesWidgetColumn;
import com.gridnine.xtrip.client.fx.core.service.IndexListService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.IBERulesHolderSpace;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.IBERulesHolderSpaceController;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.IBERulesHolderSpaceVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.IBERulesTablePanel;
import com.gridnine.xtrip.client.fx.standard.rules.RulesViewConfiguration;
import com.gridnine.xtrip.client.fx.standard.rules.RulesWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.rules.StandardFilters;
import com.gridnine.xtrip.common.fx.model.RulesHolderUIData;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.gds.rules.FilteringCategories;
import com.gridnine.xtrip.common.hotels2.rules.HotelsFilteringCategories;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpFilteringCategories;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.rules.passport.PassportFilteringCategories;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyFilteringCategories;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.transfers.rules.TransferFilteringCategories;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javafx.event.EventHandler;
import javafx.scene.Node;

public class RulesHolderControllerInterceptor
extends ControllerInterceptor<IBERulesHolderSpaceVM, IBERulesHolderSpaceController> {
    private static final List<RuleFilteringCategory> DISABLED_SITE_FILTERING_CATEGORIES = Arrays.asList(FilteringCategories.SEARCH_PCC_SETTINGS, FilteringCategories.ADDITIONAL_PARAMETERS, TravelPolicyFilteringCategories.TRAVEL_POLICY, TravelPolicyFilteringCategories.ORG_TRAVEL_POLICY, TravelPolicyFilteringCategories.ORG_TRAVEL_POLICY_AUTHORIZATION, IbecorpFilteringCategories.HOTEL_PREPROCESSING, IbecorpFilteringCategories.NOTIFICATION_EXTERNAL_FINDOCS, IbecorpFilteringCategories.NOTIFICATION_TEMPLATE_ISSUE, IbecorpFilteringCategories.NOTIFICATION_TEMPLATE_SITE, IbecorpFilteringCategories.NOTIFICATION_TEMPLATE_BALANCE);

    protected Class<IBERulesHolderSpaceController> getControllerClass() {
        return IBERulesHolderSpaceController.class;
    }

    protected void onCreate(IBERulesHolderSpaceController controller) {
        RuleFilteringCategory rfc;
        IBERulesHolderSpace view = controller.getView();
        ValuesWidgetColumn valCol = (ValuesWidgetColumn)((TableWidget)((IBERulesTablePanel)view.getAirlineInfosTile().getFullNode()).getTableCard().getContent()).getColumn("cardType");
        valCol.setItemsSupplier(() -> Arrays.asList(CardVendor.values()));
        view.getOverviewNode().getNameNode().getViewState().setNotEditable(true);
        EventHandler handler = evt -> {
            DataTransferPackage dtp = Objects.requireNonNull(RootEntityPane.lookup((Node)controller.getView())).getData();
            if (dtp == null || dtp.getContainer() == null) {
                Notifications.get().showFlashNotification(Messages.Save_object, null);
                return;
            }
            RulesHolderUIData uiData = (RulesHolderUIData)dtp.getSupplement();
            EntityReference ref = dtp.getContainer().toReference();
            IndexListParameters params = new IndexListParameters();
            params.setIndexType(OrganizationIndex.class);
            Object[] siteUids = uiData.getSiteUids().toArray();
            params.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.in((String)OrganizationIndex.Property.b2bSite.name(), (Object[])siteUids), SearchCriterion.in((String)OrganizationIndex.Property.b2cSite.name(), (Object[])siteUids)}));
            TableColumnSettings filter = new TableColumnSettings();
            filter.setId(OrganizationIndex.Property.code.name());
            params.getFilters().add(filter);
            filter = new TableColumnSettings();
            filter.setId(OrganizationIndex.Property.shortName.name());
            params.getFilters().add(filter);
            TableColumnSettings col = new TableColumnSettings();
            col.setId(OrganizationIndex.Property.code.name());
            params.getColumns().add(col);
            col = new TableColumnSettings();
            col.setId(OrganizationIndex.Property.shortName.name());
            params.getColumns().add(col);
            Objects.requireNonNull(IndexListService.get()).open("organizations-for-" + ref.getUid(), Messages.OrganizationsUsingThisSiteRule + ref, params);
        };
        view.getOverviewNode().getOrganizationsUsingThisRuleNode().setOnAction(handler);
        RulesViewConfiguration config = new RulesViewConfiguration();
        boolean granted = false;
        try {
            granted = true;
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        ArrayList<Object> rfcList = new ArrayList<Object>();
        rfcList.addAll(Arrays.asList(FilteringCategories.values()));
        rfcList.addAll(Arrays.asList(com.gridnine.xtrip.common.pg.rules.FilteringCategories.values()));
        rfcList.retainAll(RulesEnvironment.get().getFilteringCategories());
        ListIterator iterator = rfcList.listIterator();
        while (iterator.hasNext()) {
            rfc = (RuleFilteringCategory)iterator.next();
            if (granted || !RulesHolderControllerInterceptor.isInternal(rfc)) continue;
            iterator.remove();
        }
        rfcList.addAll(Arrays.asList(PassportFilteringCategories.values()));
        rfcList.addAll(Arrays.asList(IbecorpFilteringCategories.values()));
        rfcList.addAll(Arrays.asList(HotelsFilteringCategories.values()));
        rfcList.addAll(Arrays.asList(TransferFilteringCategories.values()));
        rfcList.retainAll(RulesEnvironment.get().getFilteringCategories());
        iterator = rfcList.listIterator();
        while (iterator.hasNext()) {
            rfc = (RuleFilteringCategory)iterator.next();
            if ((granted || !RulesHolderControllerInterceptor.isInternal(rfc)) && !RulesHolderControllerInterceptor.isDisabled(rfc)) continue;
            iterator.remove();
        }
        config.getCategories().addAll(rfcList);
        config.getFilters().addAll(Arrays.asList(StandardFilters.TEXT, StandardFilters.ACTUAL_ONLY));
        config.setCollapsible(false);
        RulesWidgetHelper.initTile((Tile)view.getRulesTile(), (RulesViewConfiguration)config);
    }

    private static boolean isInternal(RuleFilteringCategory filteringCategory) {
        if (FilteringCategories.INTERNAL_GDS == filteringCategory) {
            return true;
        }
        if (com.gridnine.xtrip.common.pg.rules.FilteringCategories.INTERNAL_PG == filteringCategory) {
            return true;
        }
        if (FilteringCategories.SUBSIDIZED_TARIFFS == filteringCategory) {
            return true;
        }
        if (FilteringCategories.ADDITIONAL_PARAMETERS == filteringCategory) {
            return true;
        }
        if (FilteringCategories.SEARCH_PCC_SETTINGS == filteringCategory) {
            return true;
        }
        return FilteringCategories.REMARKS == filteringCategory;
    }

    private static boolean isDisabled(RuleFilteringCategory filteringCategory) {
        return DISABLED_SITE_FILTERING_CATEGORIES.contains(filteringCategory);
    }
}

