/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.site;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.SMGeneralSettingsBookingRestrictionsPanel;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.SMGeneralSettingsContainer;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.SMGeneralSettingsContainerController;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.SMGeneralSettingsContainerVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.SMGeneralSettingsGeneralPanel;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.TimeZoneEx;
import com.gridnine.xtrip.common.model.ibecorp.sm.GeocoderApiTokenType;
import com.gridnine.xtrip.common.model.transfers.IwayGdsAccount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.scene.Node;
import javafx.util.StringConverter;

class SMGeneralSettingsControllerInterceptor
extends ControllerInterceptor<SMGeneralSettingsContainerVM, SMGeneralSettingsContainerController> {
    SMGeneralSettingsControllerInterceptor() {
    }

    private static void hideConnectionCards(SMGeneralSettingsContainer view) {
        view.getCards().forEach(card -> card.setHidden(true));
        view.getGeneralCard().setHidden(false);
        view.getBookingRestrictionsCard().setHidden(false);
        view.getCurrencyConverterCard().setHidden(false);
        view.getErrorMessageCard().setHidden(false);
    }

    protected Class<SMGeneralSettingsContainerController> getControllerClass() {
        return SMGeneralSettingsContainerController.class;
    }

    protected void afterReadData(SMGeneralSettingsContainerController controller, SMGeneralSettingsContainerVM model) {
        RootEntityPane pane = RootEntityPane.lookup((Node)controller.getView());
        if (pane != null) {
            pane.descriptionProperty().setValue(L10n.replace((String)Messages.SMGeneralSettings_name, (Object[])new Object[]{((SMGeneralSettingsGeneralPanel)controller.getView().getGeneralCard().getContent()).getSiteNode().getValue().getCaption()}));
        }
    }

    protected void onCreate(SMGeneralSettingsContainerController controller) {
        SMGeneralSettingsContainer view = controller.getView();
        SMGeneralSettingsControllerInterceptor.hideConnectionCards(view);
        SMGeneralSettingsGeneralPanel generalPanel = (SMGeneralSettingsGeneralPanel)view.getGeneralCard().getContent();
        generalPanel.getPersonalCabinetEnabledNode().setConverter(Converters.boolConverter((String)Messages.ON2, (String)Messages.OFF2));
        generalPanel.getHideUnavailableServicesNode().setConverter(Converters.boolConverter((String)Messages.SMGeneralSettingsGeneralPanel_hideUnavailableServices_true, (String)Messages.SMGeneralSettingsGeneralPanel_hideUnavailableServices_false));
        generalPanel.getGeocoderIwayGdsAccountNode().setListParametersSupplier(this.getGeocoderIwayGdsAccountSupplier());
        ((SMGeneralSettingsBookingRestrictionsPanel)view.getBookingRestrictionsCard().getContent()).getBannedDaysNode().setItemsSupplier(() -> Arrays.asList(Messages.Saturday, Messages.Sunday));
        ((SMGeneralSettingsBookingRestrictionsPanel)view.getBookingRestrictionsCard().getContent()).getDaysShiftNode().setConverter((StringConverter)new StringConverter<Integer>(){

            public String toString(Integer object) {
                if (object == null) {
                    return null;
                }
                return "+" + object.toString();
            }

            public Integer fromString(String string) {
                return null;
            }
        });
        ((SMGeneralSettingsBookingRestrictionsPanel)view.getBookingRestrictionsCard().getContent()).getDaysShiftNode().setItemsSupplier(() -> IntStream.range(0, 31).boxed().collect(Collectors.toList()));
        ((SMGeneralSettingsBookingRestrictionsPanel)view.getBookingRestrictionsCard().getContent()).getDaysShiftNode().setSortItems(false);
        ((SMGeneralSettingsBookingRestrictionsPanel)view.getBookingRestrictionsCard().getContent()).getStopTimeNode().setConverter((StringConverter)new StringConverter<Integer>(){

            public String toString(Integer object) {
                if (object == null) {
                    return null;
                }
                return object.toString() + ":00";
            }

            public Integer fromString(String string) {
                return null;
            }
        });
        ((SMGeneralSettingsBookingRestrictionsPanel)view.getBookingRestrictionsCard().getContent()).getStopTimeNode().setItemsSupplier(() -> IntStream.range(0, 24).boxed().collect(Collectors.toList()));
        ((SMGeneralSettingsBookingRestrictionsPanel)view.getBookingRestrictionsCard().getContent()).getStopTimeNode().setSortItems(false);
        generalPanel.getTimeZoneNode().setConverter((StringConverter)new StringConverter<TimeZoneEx>(){

            public String toString(TimeZoneEx object) {
                if (object == null) {
                    return null;
                }
                return SMGeneralSettingsControllerInterceptor.this.getTimeZoneDisplayName(object);
            }

            public TimeZoneEx fromString(String string) {
                return null;
            }
        });
        generalPanel.getDefaultLocaleNode().setItemsSupplier(() -> new ArrayList(SystemHelper.getAvailableLocales()));
        generalPanel.getAdditionalLocalesNode().setItemsSupplier(() -> new ArrayList(SystemHelper.getAvailableLocales()), false);
        generalPanel.getDefaultLocaleNode().setConverter((StringConverter)new StringConverter<Locale>(){

            public String toString(Locale object) {
                if (object == null) {
                    return null;
                }
                return object.getDisplayLanguage();
            }

            public Locale fromString(String string) {
                return null;
            }
        });
        generalPanel.getAdditionalLocalesNode().setConverter((StringConverter)new StringConverter<Locale>(){

            public String toString(Locale object) {
                if (object == null) {
                    return null;
                }
                return object.getDisplayLanguage();
            }

            public Locale fromString(String string) {
                return null;
            }
        });
        generalPanel.getGeocoderApiTokenTypeNode().setValue((Object)GeocoderApiTokenType.YANDEX);
    }

    private Supplier<IndexListParameters<IwayGdsAccount, ?>> getGeocoderIwayGdsAccountSupplier() {
        return () -> {
            IndexListParameters listParameters = EntityIndexHandler.forIndexClass(GdsAccountIndex.class).createListParameters();
            listParameters.getSearchCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.gds.name(), (Object)GdsName.IWAY));
            return listParameters;
        };
    }

    protected void beforeWriteData(SMGeneralSettingsContainerController controller, SMGeneralSettingsContainerVM model) {
        super.beforeWriteData((ViewController)controller, (Object)model);
        if (model.getGeneral().getGeocoderApiTokenType() == null && controller.getGeneral().getGeocoderApiTokenType() == null && controller.getGeneral().getGeocoderApiToken() != null) {
            controller.getGeneral().setGeocoderApiTokenType(GeocoderApiTokenType.YANDEX);
            model.getGeneral().setGeocoderApiTokenType(GeocoderApiTokenType.YANDEX);
        }
    }

    final String getTimeZoneDisplayName(TimeZoneEx timeZone) {
        int offset = timeZone.getTimeZone().getRawOffset();
        return String.format("(UTC+%02d:%02d) %s", offset / 3600000, offset % 3600000 / 60000, timeZone.toString());
    }
}

