/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.tasks;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.ibecorp.model.IBusSbisContextKeys;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisIntegrationSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.standard.helpers.SysLogHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.stage.DirectoryChooser;
import org.apache.commons.io.FileUtils;

public class ExportShipmentGroupToSbisTask
extends ClientTask {
    private final List<ShipmentIndex> list;
    private final IndexListPane<?, ?> context;
    private final boolean alt;

    public ExportShipmentGroupToSbisTask(List<ShipmentIndex> list, IndexListPane<?, ?> context, boolean alt) {
        this.list = list;
        this.context = context;
        this.alt = alt;
    }

    protected void execute() throws Exception {
        Map<EntityReference<Shipment>, List<Document>> result = this.createListDocumentsAndSendExportToSbis(this.list, this.alt);
        AtomicInteger item = new AtomicInteger(1);
        if (this.alt) {
            FxUtil.submitToFxThread(() -> {
                File selectedDirectory;
                DirectoryChooser dc = new DirectoryChooser();
                dc.setTitle(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Choose_Directory);
                if (dc.getInitialDirectory() == null) {
                    File file = ClientSettings.get().getFileChooserDirectory();
                    if (UiUtil.isFileValid((File)file) && file.isDirectory()) {
                        dc.setInitialDirectory(file);
                    } else {
                        dc.setInitialDirectory(Environment.getDataFolder());
                    }
                }
                if ((selectedDirectory = dc.showDialog(this.context.getScene().getWindow())) != null) {
                    Notifications.get().submitTask(() -> {
                        ClientSettings.get().setFileChooserDirectory(selectedDirectory);
                        ClientSettings.get().save();
                        result.forEach((key, value) -> value.forEach(doc -> {
                            try {
                                String name = TextUtil.normalizeFileName((String)doc.getName());
                                File file = new File(selectedDirectory, name);
                                FileUtils.writeByteArrayToFile((File)file, (byte[])doc.getContent());
                                if (result.size() != 0) {
                                    this.setProgress((byte)(100 * item.get() / result.size()), Messages.Sending);
                                    item.getAndIncrement();
                                }
                                this.audit(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u0444\u0430\u0439\u043b {0}", (Object[])new Object[]{file.getAbsolutePath()}), (EntityReference<Shipment>)key);
                            }
                            catch (IOException e) {
                                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.File_can_not_save, (Throwable)e, (Object[])new Object[0])});
                            }
                        }));
                    }, "\u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b \u0432 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e");
                }
            });
        }
    }

    private Map<EntityReference<Shipment>, List<Document>> createListDocumentsAndSendExportToSbis(List<ShipmentIndex> selectedItems, boolean alt) throws Exception {
        HashMap<EntityReference<Shipment>, List<Document>> documentsMap = new HashMap<EntityReference<Shipment>, List<Document>>();
        ArrayList<ShipmentIndex> items = new ArrayList<ShipmentIndex>(selectedItems);
        AtomicInteger item = new AtomicInteger(1);
        for (ShipmentIndex selectedItem : items) {
            File dir;
            HashMap<String, EntityReference> data = new HashMap<String, EntityReference>();
            EntityReference shipmentRef = selectedItem.getSource();
            data.put(IBusSbisContextKeys.SHIPMENT_REFERENCE.name(), shipmentRef);
            HashSet<String> keys = new HashSet<String>();
            keys.add(IBusSbisContextKeys.SHIPMENT_CONTAINER.name());
            keys.add(IBusSbisContextKeys.FILES_TO_EXPORT.name());
            keys.add(IBusSbisContextKeys.INTEGRATION_SETTINGS.name());
            Map result = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "ibecorp:sbis:export-shipment", data, keys);
            List documents = (List)result.get(IBusSbisContextKeys.FILES_TO_EXPORT.name());
            documentsMap.put((EntityReference<Shipment>)shipmentRef, documents);
            SbisIntegrationSettings settings = (SbisIntegrationSettings)result.get(IBusSbisContextKeys.INTEGRATION_SETTINGS.name());
            if (alt) continue;
            String pathDir = settings.getGeneralSettings().getExportDirectory();
            EntityReference agent = Prefetched.getData().getCurrentAgentData().getAgent();
            EntityContainer currentUserCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), agent);
            if (currentUserCtr != null && !TextUtil.isBlank((String)((Person)currentUserCtr.getEntity()).getExportDirectorySbis())) {
                pathDir = ((Person)currentUserCtr.getEntity()).getExportDirectorySbis();
            }
            if (!(dir = new File(pathDir)).exists()) {
                dir.mkdirs();
            }
            documents.forEach(doc -> {
                try {
                    String name = TextUtil.normalizeFileName((String)doc.getName());
                    File file = new File(dir, name);
                    FileUtils.writeByteArrayToFile((File)file, (byte[])doc.getContent());
                    if (documents.size() != 0) {
                        this.setProgress((byte)(100 * item.get() / documents.size()), Messages.Sending);
                        item.getAndIncrement();
                    }
                    this.audit(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u0444\u0430\u0439\u043b {0}", (Object[])new Object[]{file.getAbsolutePath()}), (EntityReference<Shipment>)shipmentRef);
                }
                catch (IOException e) {
                    Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.File_can_not_save, (Throwable)e, (Object[])new Object[0])});
                }
            });
            EntityContainer shipmentEntityContainer = (EntityContainer)result.get(IBusSbisContextKeys.SHIPMENT_CONTAINER.name());
            boolean saveWithCheckPoint = !MiscUtil.equals((Object)"Export SBIS (group)", (Object)shipmentEntityContainer.getVersionInfo().getVersionNotes());
            shipmentEntityContainer.getVersionInfo().setDataSource("fx-client");
            shipmentEntityContainer.getVersionInfo().setVersionNotes("Export SBIS (group)");
            ((Shipment)shipmentEntityContainer.getEntity()).setExportedToSbis(true);
            ((Shipment)shipmentEntityContainer.getEntity()).setLastExportToSbisDate(new Date());
            ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), shipmentEntityContainer, null, saveWithCheckPoint);
            EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(shipmentRef, EntityModification.ModificationType.CHANGE)));
        }
        return documentsMap;
    }

    private void audit(Message message, EntityReference<Shipment> shipmentRef) {
        try {
            SysLogItem sysLogItem = SysLogHelper.newAuditItem(shipmentRef, (String)"\u044d\u043a\u0441\u043f\u043e\u0440\u0442 \u0432 \u0421\u0411\u0418\u0421 (\u0433\u0440\u0443\u043f\u043f\u0430)", (Message)message);
            ((AssetService)RpcServiceManager.get().getService(AssetService.class)).save(ServiceInvocationContext.get(), (BaseAsset)sysLogItem);
        }
        catch (Exception e) {
            Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u043b\u043e\u0433", (Throwable)e, (Object[])new Object[0])});
        }
    }

    protected String getTitle() {
        return Messages.Sending_in_Sbis;
    }
}

