/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.ibecorp.model.ResendDataToXreportsTaskConfiguration;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.DateUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import javafx.scene.Node;

public class ResendDataToXreportsTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "ResendDataToXreportsTask";
    }

    public String getName() {
        return "\u041f\u0435\u0440\u0435\u043a\u0430\u0447\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u041e\u0442\u0447\u0435\u0442\u043d\u043e\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435";
    }

    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.ibecorp.tasks.ResendDataToXreportsTask";
    }

    public Configurator createConfigurator() {
        Configurator configurator = new Configurator();
        return configurator;
    }

    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        private final DateValueWidget fromDateWidget = new DateValueWidget(false);
        private final DateValueWidget toDateWidget = new DateValueWidget(false);
        private final TextFieldWidget bookingNumberWidget = new TextFieldWidget(false);
        private final TextFieldWidget productNumberWidget = new TextFieldWidget(false);
        private final MultiEntityWidget<Holding> holdingWidget = new MultiEntityWidget(Holding.class, false);
        private final MultiEntityWidget<Organization> clientWidget = new MultiEntityWidget(Organization.class, false);
        private final MultiEntityWidget<Organization> subagencyWidget = new MultiEntityWidget(Organization.class, false);
        private final MultiComboBoxWidget<GdsName> gdsWidget = new MultiComboBoxWidget(false);
        private final MultiComboBoxWidget<ProductType> productTypeWidget = new MultiComboBoxWidget(false);
        private final MultiComboBoxWidget<TravelSubject> travelSubjectWidget = new MultiComboBoxWidget(false);
        private final BooleanValueWidget secondPhaseWidget = new BooleanValueWidget(false, false);

        Configurator() {
            super(4);
            this.fromDateWidget.setValue(LocalDate.now().minusDays(1L));
            this.getCells().add((Object)new GridCell("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430", (Node)this.fromDateWidget));
            this.getCells().add((Object)new GridCell("\u041a\u043e\u043d\u0435\u0446 \u043f\u0435\u0440\u0438\u043e\u0434\u0430", (Node)this.toDateWidget));
            this.getCells().add((Object)new GridCell("\u041d\u043e\u043c\u0435\u0440 \u0437\u0430\u043a\u0430\u0437\u0430", (Node)this.bookingNumberWidget));
            this.getCells().add((Object)new GridCell("\u041d\u043e\u043c\u0435\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", (Node)this.productNumberWidget));
            this.getCells().add((Object)new GridCell("\u0425\u043e\u043b\u0434\u0438\u043d\u0433", this.holdingWidget));
            this.getCells().add((Object)new GridCell("\u041a\u043b\u0438\u0435\u043d\u0442", this.clientWidget));
            this.getCells().add((Object)new GridCell("\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e", this.subagencyWidget));
            this.getCells().add((Object)new GridCell("\u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", this.gdsWidget));
            this.getCells().add((Object)new GridCell("\u0422\u0438\u043f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", this.productTypeWidget));
            this.getCells().add((Object)new GridCell("\u0422\u0438\u043f \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0438\u044f", this.travelSubjectWidget));
            this.getCells().add((Object)new GridCell("\u0412\u0442\u043e\u0440\u0430\u044f \u0444\u0430\u0437\u0430", (Node)this.secondPhaseWidget));
            this.holdingWidget.setListParametersSupplier(ControllerInterceptorsHelper::getHoldings);
            this.clientWidget.setListParametersSupplier(ControllerInterceptorsHelper::getClients);
            this.subagencyWidget.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
            this.gdsWidget.setItemsSupplier(() -> Arrays.asList(GdsName.values()), false);
            this.productTypeWidget.setItemsSupplier(() -> Arrays.asList(ProductType.values()), false);
            this.travelSubjectWidget.setItemsSupplier(() -> Arrays.asList(TravelSubject.values()), false);
        }

        ResendDataToXreportsTaskConfiguration createConfiguration() {
            ResendDataToXreportsTaskConfiguration configuration = new ResendDataToXreportsTaskConfiguration();
            configuration.setFromDate(DateUtils.toJavaDate((LocalDate)this.fromDateWidget.getValue()));
            configuration.setToDate(DateUtils.toJavaDate((LocalDate)this.toDateWidget.getValue()));
            configuration.setBookingNumber(this.bookingNumberWidget.getValue());
            configuration.setProductNumber(this.productNumberWidget.getValue());
            configuration.getHoldings().addAll(this.holdingWidget.getValues());
            configuration.getClients().addAll(this.clientWidget.getValues());
            configuration.getSubagencies().addAll(this.subagencyWidget.getValues());
            configuration.getGdsNames().addAll(this.gdsWidget.getValues());
            configuration.getProductTypes().addAll(this.productTypeWidget.getValues());
            configuration.getTravelSubjects().addAll(this.travelSubjectWidget.getValues());
            configuration.setSecondPhase(this.secondPhaseWidget.getValue());
            return configuration;
        }
    }
}

