/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.rules;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomCheckBoxTreeView;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpModelService;
import com.gridnine.xtrip.common.model.ibecorp.AvailableRegistryFieldsSettings;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;

public class IbecorpAvailableRegistryFieldsRenderer
implements NodeRenderer {
    public static final IbecorpAvailableRegistryFieldsRenderer instance = new IbecorpAvailableRegistryFieldsRenderer();
    public static final String ROOT_ELM_ID = "_ROOT";

    public Node createNode(boolean readonly) {
        PopupWidget popup = new PopupWidget();
        popup.setInfoText(UiUtil.NULL_TEXT);
        ApplicableRegistryFieldsNode viewNode = new ApplicableRegistryFieldsNode();
        popup.setView((Node)viewNode);
        popup.setDialogConfigurator(d -> Notifications.get().submitTask(() -> {
            Map fields = ((IbecorpModelService)((RpcServiceManager)Environment.getPublished(RpcServiceManager.class)).getService(IbecorpModelService.class)).getAllXreportsRegistryFields((ServiceInvocationContext)Environment.getPublished(ServiceInvocationContext.class));
            viewNode.setAllFields(fields);
        }, (String)null));
        popup.setDialogCloseHandler(() -> popup.setInfoText(this.getInfoText(viewNode.getValue())));
        return popup;
    }

    private String getInfoText(AvailableRegistryFieldsSettings value) {
        if (value == null || value.getSelectedFields().isEmpty()) {
            return Messages.Not_set;
        }
        if (value.getSelectedFields().contains(ROOT_ELM_ID)) {
            return Messages.All;
        }
        return Messages.Several_fields;
    }

    public Object getValue(Node node) {
        return ((ApplicableRegistryFieldsNode)((PopupWidget)node).getView()).getValue();
    }

    public void setValue(Node node, Object value) {
        PopupWidget popup = (PopupWidget)node;
        ((ApplicableRegistryFieldsNode)popup.getView()).setValue((AvailableRegistryFieldsSettings)value);
        popup.setInfoText(this.getInfoText((AvailableRegistryFieldsSettings)value));
    }

    public void setReadonly(boolean readonly, Node node) {
        ((ApplicableRegistryFieldsNode)((PopupWidget)node).getView()).setReadonly(readonly);
    }

    static class RegistryTreeNode {
        private String id;
        private String title;
        private final List<RegistryTreeNode> children = new ArrayList<RegistryTreeNode>();

        RegistryTreeNode() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public List<RegistryTreeNode> getChildren() {
            return this.children;
        }
    }

    static class ApplicableRegistryFieldsTree
    extends CustomCheckBoxTreeView<RegistryTreeNode> {
        public ApplicableRegistryFieldsTree(RegistryTreeNode root) {
            super((Object)root, true, Collections.emptyList());
            UiUtil.expand((TreeItem)this.getTreeView().getRoot());
        }

        protected List<RegistryTreeNode> getNodeChildren(RegistryTreeNode reportTreeNode) {
            return reportTreeNode.children;
        }

        protected String getNodeTitle(RegistryTreeNode reportTreeNode) {
            return reportTreeNode.title;
        }

        protected String getNodeId(RegistryTreeNode reportTreeNode) {
            return reportTreeNode.id;
        }

        protected Comparator<TreeItem<RegistryTreeNode>> getComparator() {
            return (c1, c2) -> ((RegistryTreeNode)c1.getValue()).getChildren().isEmpty() ? (((RegistryTreeNode)c2.getValue()).getChildren().isEmpty() ? ((RegistryTreeNode)c1.getValue()).getTitle().compareTo(((RegistryTreeNode)c2.getValue()).getTitle()) : 1) : (((RegistryTreeNode)c2.getValue()).getChildren().isEmpty() ? -1 : ((RegistryTreeNode)c1.getValue()).getTitle().compareTo(((RegistryTreeNode)c2.getValue()).getTitle()));
        }
    }

    static class ApplicableRegistryFieldsNode
    extends BorderPane {
        private AvailableRegistryFieldsSettings value = null;
        private Map<String, String> allFields = null;
        private Boolean readonly;
        private ApplicableRegistryFieldsTree panel;
        private boolean initialized = false;

        ApplicableRegistryFieldsNode() {
        }

        void setValue(AvailableRegistryFieldsSettings value) {
            this.value = value == null ? new AvailableRegistryFieldsSettings() : value;
            this.updateTree();
        }

        public void setReadonly(boolean readonly) {
            this.readonly = readonly;
            this.updateTree();
        }

        private void updateTree() {
            if (!this.initialized && this.value != null && this.allFields != null && this.readonly != null) {
                ArrayList<String> selectedUids = new ArrayList<String>();
                RegistryTreeNode root = new RegistryTreeNode();
                root.setId(IbecorpAvailableRegistryFieldsRenderer.ROOT_ELM_ID);
                root.setTitle(Messages.All_fields);
                if (this.value.getSelectedFields().contains(IbecorpAvailableRegistryFieldsRenderer.ROOT_ELM_ID)) {
                    selectedUids.add(IbecorpAvailableRegistryFieldsRenderer.ROOT_ELM_ID);
                }
                this.allFields.forEach((id, title) -> {
                    if (this.getNode(root, (String)id) == null) {
                        String[] innerIds = id.split("\\.");
                        RegistryTreeNode parentNode = root;
                        boolean wasParentPresent = true;
                        for (int i = 0; i < innerIds.length; ++i) {
                            RegistryTreeNode currentNode;
                            String currentId = this.concatId(i, innerIds);
                            if (wasParentPresent) {
                                currentNode = this.getNode(parentNode, currentId);
                                if (currentNode != null) {
                                    parentNode = currentNode;
                                    continue;
                                }
                                wasParentPresent = false;
                            }
                            currentNode = new RegistryTreeNode();
                            currentNode.setId(currentId);
                            currentNode.setTitle(this.allFields.get(currentId));
                            parentNode.getChildren().add(currentNode);
                            parentNode = currentNode;
                        }
                        if (this.value.getSelectedFields().contains(id)) {
                            selectedUids.add((String)id);
                        }
                    }
                });
                FxUtil.submitToFxThread(() -> {
                    this.panel = new ApplicableRegistryFieldsTree(root);
                    this.panel.setReadonly(this.readonly);
                    this.panel.setNodesSelection(selectedUids);
                    if (selectedUids.contains(IbecorpAvailableRegistryFieldsRenderer.ROOT_ELM_ID)) {
                        this.panel.setRootSelected(true);
                    }
                    this.setCenter((Node)this.panel.getTreePane());
                });
                this.initialized = true;
            }
        }

        private String concatId(int n, String[] innerIds) {
            StringBuilder id = new StringBuilder(innerIds[0]);
            for (int i = 1; i < n + 1; ++i) {
                id.append('.').append(innerIds[i]);
            }
            return id.toString();
        }

        private RegistryTreeNode getNode(RegistryTreeNode root, String id) {
            return root.getChildren().stream().map(n -> {
                if (MiscUtil.equals((Object)n.getId(), (Object)id)) {
                    return n;
                }
                if (n.getChildren().isEmpty()) {
                    return null;
                }
                return this.getNode((RegistryTreeNode)n, id);
            }).filter(Objects::nonNull).findFirst().orElse(null);
        }

        void setAllFields(Map<String, String> allFields) {
            this.allFields = allFields;
            this.updateTree();
        }

        AvailableRegistryFieldsSettings getValue() {
            AvailableRegistryFieldsSettings result = new AvailableRegistryFieldsSettings();
            if (this.panel == null) {
                return this.value;
            }
            if (this.panel.getSelectedItemsIds().isEmpty()) {
                return result;
            }
            result.getSelectedFields().addAll(this.panel.getSelectedItemsIds());
            if (MiscUtil.equals((Object)result.getSelectedFields().size(), (Object)this.allFields.size())) {
                result.getSelectedFields().add(IbecorpAvailableRegistryFieldsRenderer.ROOT_ELM_ID);
            }
            return result;
        }
    }
}

