/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.widgets;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.ibecorp.widgets.LocalSiteLang;
import com.gridnine.xtrip.common.model.ibecorp.sm.MultiLingualText;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;

public abstract class BaseMultiLingualWidget<W extends Node>
extends CustomWidget<MultiLingualText>
implements DevTool {
    private final ViewState viewState = new ViewState();
    private final W ruWidget;
    private final W enWidget;
    private final Function<MultiLingualText, String> localGetter;
    private final BiConsumer<MultiLingualText, String> localSetter;
    private W localWidget;

    protected BaseMultiLingualWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().add((Object)"multilingual-widget");
        TabPane tabPane = new TabPane();
        tabPane.getStyleClass().add((Object)"floating");
        tabPane.setSide(Side.LEFT);
        LocalSiteLang localSiteLang = LocalSiteLang.detect();
        if (localSiteLang != null) {
            switch (localSiteLang) {
                case BG: {
                    this.localGetter = MultiLingualText::getBg;
                    this.localSetter = MultiLingualText::setBg;
                    break;
                }
                case UK: {
                    this.localGetter = MultiLingualText::getUk;
                    this.localSetter = MultiLingualText::setUk;
                    break;
                }
                case HY: {
                    this.localGetter = MultiLingualText::getHy;
                    this.localSetter = MultiLingualText::setHy;
                    break;
                }
                case AZ: {
                    this.localGetter = MultiLingualText::getAz;
                    this.localSetter = MultiLingualText::setAz;
                    break;
                }
                case KA: {
                    this.localGetter = MultiLingualText::getKa;
                    this.localSetter = MultiLingualText::setKa;
                    break;
                }
                case KZ: {
                    this.localGetter = MultiLingualText::getKz;
                    this.localSetter = MultiLingualText::setKz;
                    break;
                }
                default: {
                    this.localGetter = null;
                    this.localSetter = null;
                }
            }
            if (this.localGetter != null) {
                this.localWidget = this.createWidget(ro);
                Tab tab = new Tab(localSiteLang.getVariantTitle(), this.localWidget);
                tab.setTooltip(new Tooltip(localSiteLang.getVariantTooltip()));
                tab.setClosable(false);
                tabPane.getTabs().add((Object)tab);
            }
        } else {
            this.localGetter = null;
            this.localSetter = null;
        }
        this.ruWidget = this.createWidget(ro);
        Tab tab = new Tab(Messages.russianTitle, this.ruWidget);
        tab.setTooltip(new Tooltip(Messages.russianTooltip));
        tab.setClosable(false);
        tabPane.getTabs().add((Object)tab);
        this.enWidget = this.createWidget(ro);
        tab = new Tab(Messages.englishTitle, this.enWidget);
        tab.setTooltip(new Tooltip(Messages.englishTooltip));
        tab.setClosable(false);
        tabPane.getTabs().add((Object)tab);
        this.getChildren().add((Object)tabPane);
        this.viewState.stateProperty().addListener(obj -> this.updateState());
        this.updateState();
    }

    public W getRuWidget() {
        return this.ruWidget;
    }

    public W getEnWidget() {
        return this.enWidget;
    }

    public W getLocalWidget() {
        return this.localWidget;
    }

    protected abstract W createWidget(boolean var1);

    protected abstract void setReadonly(W var1, boolean var2);

    protected abstract boolean isDataChanged(W var1);

    protected abstract String getData(W var1);

    protected abstract void setData(W var1, String var2);

    public ViewState getViewState() {
        return this.viewState;
    }

    public void setFieldName(String value) {
    }

    public void readData(MultiLingualText model) {
        this.setData(this.ruWidget, model.getRu());
        this.setData(this.enWidget, model.getEn());
        if (this.localWidget != null) {
            this.setData(this.localWidget, this.localGetter.apply(model));
        }
    }

    public void writeData(MultiLingualText model) {
        model.setRu(this.getData(this.ruWidget));
        model.setEn(this.getData(this.enWidget));
        if (this.localWidget != null) {
            this.localSetter.accept(model, this.getData(this.localWidget));
        }
    }

    public boolean isDataChanged() {
        return this.isDataChanged(this.ruWidget) || this.isDataChanged(this.enWidget) || this.localWidget != null && this.isDataChanged(this.localWidget);
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                if (BaseMultiLingualWidget.this.localWidget != null) {
                    return Arrays.asList(BaseMultiLingualWidget.this.ruWidget, BaseMultiLingualWidget.this.enWidget, BaseMultiLingualWidget.this.localWidget);
                }
                return Arrays.asList(BaseMultiLingualWidget.this.ruWidget, BaseMultiLingualWidget.this.enWidget);
            }

            public String getInfo() {
                return ((Object)((Object)BaseMultiLingualWidget.this)).getClass().getSimpleName() + DevTools.getViewStateInfo((ViewState)BaseMultiLingualWidget.this.viewState);
            }
        };
    }

    private void updateState() {
        this.setReadonly(this.ruWidget, this.viewState.isImmutable());
        this.setReadonly(this.enWidget, this.viewState.isImmutable());
        if (this.localWidget != null) {
            this.setReadonly(this.localWidget, this.viewState.isImmutable());
        }
    }
}

