/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.widgets;

import com.gridnine.xtrip.client.fx.core.service.GlobalSettingsService;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import java.util.Locale;

public enum LocalSiteLang {
    BG{

        @Override
        public String getVariantTitle() {
            return Messages.bulgarianTitle;
        }

        @Override
        String getVariantTooltip() {
            return Messages.bulgarianTooltip;
        }
    }
    ,
    UK{

        @Override
        public String getVariantTitle() {
            return Messages.ukrainianTitle;
        }

        @Override
        String getVariantTooltip() {
            return Messages.ukrainianTooltip;
        }
    }
    ,
    HY{

        @Override
        public String getVariantTitle() {
            return Messages.armenianTitle;
        }

        @Override
        String getVariantTooltip() {
            return Messages.armenianTooltip;
        }
    }
    ,
    AZ{

        @Override
        public String getVariantTitle() {
            return Messages.azerbaijaniTitle;
        }

        @Override
        String getVariantTooltip() {
            return Messages.azerbaijaniTooltip;
        }
    }
    ,
    KA{

        @Override
        public String getVariantTitle() {
            return Messages.georgianTitle;
        }

        @Override
        String getVariantTooltip() {
            return Messages.georgianTooltip;
        }
    }
    ,
    KZ{

        @Override
        public String getVariantTitle() {
            return Messages.kazakhTitle;
        }

        @Override
        String getVariantTooltip() {
            return Messages.kazakhTooltip;
        }
    };


    public static LocalSiteLang detect() {
        String defaultCurrency = GlobalSettingsService.get().getDefaultCurrency();
        if (defaultCurrency == null) {
            return null;
        }
        switch (defaultCurrency.toUpperCase(Locale.ROOT)) {
            case "BGN": {
                return BG;
            }
            case "UAH": {
                return UK;
            }
            case "AMD": {
                return HY;
            }
            case "AZN": {
                return AZ;
            }
            case "GEL": {
                return KA;
            }
            case "KZT": {
                return KZ;
            }
        }
        return null;
    }

    public abstract String getVariantTitle();

    abstract String getVariantTooltip();
}

