/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.widgets;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiTextWidget;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.ibecorp.widgets.LocalSiteLang;
import com.gridnine.xtrip.client.fx.ibecorp.widgets.TemplatePane;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;

public class MultiLingualEmailWidget<MT extends MailTemplate>
extends CustomWidget<MT>
implements DevTool {
    private final ViewState viewState = new ViewState();
    private final MultiTextWidget addressesWidget;
    private final TemplatePane ruPane;
    private final TemplatePane enPane;
    private final Function<MT, String> localSubjectGetter;
    private final BiConsumer<MT, String> localSubjectSetter;
    private final Function<MT, String> localBodyGetter;
    private final BiConsumer<MT, String> localBodySetter;
    protected TemplatePane localPane;
    protected MT data;
    protected GridContainer outerPane = new GridContainer(1);

    public MultiLingualEmailWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().add((Object)"multilingual-widget");
        TabPane tabPane = new TabPane();
        tabPane.getStyleClass().add((Object)"floating");
        tabPane.setSide(Side.LEFT);
        LocalSiteLang localSiteLang = LocalSiteLang.detect();
        if (localSiteLang != null) {
            switch (localSiteLang) {
                case BG: {
                    this.localSubjectGetter = MailTemplate::getSubjectBg;
                    this.localSubjectSetter = MailTemplate::setSubjectBg;
                    this.localBodyGetter = MailTemplate::getDataBg;
                    this.localBodySetter = MailTemplate::setDataBg;
                    break;
                }
                case UK: {
                    this.localSubjectGetter = MailTemplate::getSubjectUk;
                    this.localSubjectSetter = MailTemplate::setSubjectUk;
                    this.localBodyGetter = MailTemplate::getDataUk;
                    this.localBodySetter = MailTemplate::setDataUk;
                    break;
                }
                case HY: {
                    this.localSubjectGetter = MailTemplate::getSubjectHy;
                    this.localSubjectSetter = MailTemplate::setSubjectHy;
                    this.localBodyGetter = MailTemplate::getDataHy;
                    this.localBodySetter = MailTemplate::setDataHy;
                    break;
                }
                case AZ: {
                    this.localSubjectGetter = MailTemplate::getSubjectAz;
                    this.localSubjectSetter = MailTemplate::setSubjectAz;
                    this.localBodyGetter = MailTemplate::getDataAz;
                    this.localBodySetter = MailTemplate::setDataAz;
                    break;
                }
                case KA: {
                    this.localSubjectGetter = MailTemplate::getSubjectKa;
                    this.localSubjectSetter = MailTemplate::setSubjectKa;
                    this.localBodyGetter = MailTemplate::getDataKa;
                    this.localBodySetter = MailTemplate::setDataKa;
                    break;
                }
                case KZ: {
                    this.localSubjectGetter = MailTemplate::getSubjectKz;
                    this.localSubjectSetter = MailTemplate::setSubjectKz;
                    this.localBodyGetter = MailTemplate::getDataKz;
                    this.localBodySetter = MailTemplate::setDataKz;
                    break;
                }
                default: {
                    this.localSubjectGetter = null;
                    this.localSubjectSetter = null;
                    this.localBodyGetter = null;
                    this.localBodySetter = null;
                }
            }
            if (this.localSubjectGetter != null) {
                this.localPane = new TemplatePane(ro);
                Tab tab = new Tab(localSiteLang.getVariantTitle(), (Node)this.localPane);
                tab.setTooltip(new Tooltip(localSiteLang.getVariantTooltip()));
                tab.setClosable(false);
                tabPane.getTabs().add((Object)tab);
            }
        } else {
            this.localSubjectGetter = null;
            this.localSubjectSetter = null;
            this.localBodyGetter = null;
            this.localBodySetter = null;
        }
        this.ruPane = new TemplatePane(ro);
        this.ruPane.setStyle("-fx-min-height:20em");
        Tab tab = new Tab(Messages.russianTitle, (Node)this.ruPane);
        tab.setTooltip(new Tooltip(Messages.russianTooltip));
        tab.setClosable(false);
        tabPane.getTabs().add((Object)tab);
        this.enPane = new TemplatePane(ro);
        tab = new Tab(Messages.englishTitle, (Node)this.enPane);
        tab.setTooltip(new Tooltip(Messages.englishTooltip));
        tab.setClosable(false);
        tabPane.getTabs().add((Object)tab);
        this.outerPane.getCells().add((Object)new GridCell((Node)tabPane));
        this.addressesWidget = new MultiTextWidget(ro);
        GridCell cell = new GridCell(Messages.AdditionalAddresses, (Node)this.addressesWidget);
        cell.setHelp(() -> new QuickHelp(Messages.AdditionalAddressesHelp));
        this.outerPane.getCells().add((Object)cell);
        this.getChildren().add((Object)this.outerPane);
        this.viewState.stateProperty().addListener(obj -> this.updateState());
    }

    public TemplatePane getRuPane() {
        return this.ruPane;
    }

    public TemplatePane getEnPane() {
        return this.enPane;
    }

    public TemplatePane getLocalPane() {
        return this.localPane;
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public void setFieldName(String value) {
    }

    public void readData(MT model) {
        this.data = model;
        this.ruPane.subjectWidget.setValue(model == null ? null : model.getSubjectRu());
        this.ruPane.bodyWidget.setData(model == null || model.getDataRu() == null ? null : model.getDataRu().getBytes(StandardCharsets.UTF_8));
        this.enPane.subjectWidget.setValue(model == null ? null : model.getSubjectEn());
        this.enPane.bodyWidget.setData(model == null || model.getDataEn() == null ? null : model.getDataEn().getBytes(StandardCharsets.UTF_8));
        if (this.localPane != null) {
            this.localPane.subjectWidget.setValue(model == null ? null : this.localSubjectGetter.apply(model));
            String body = model == null ? null : this.localBodyGetter.apply(model);
            this.localPane.bodyWidget.setData(body == null ? null : body.getBytes(StandardCharsets.UTF_8));
        }
        this.addressesWidget.getValues().setAll((Collection)(model == null ? Collections.emptySet() : model.getAdditionalAddresses()));
    }

    public void writeData(MT model) {
        model.setSubjectRu(this.ruPane.subjectWidget.getValue());
        byte[] body = this.ruPane.bodyWidget.getData();
        model.setDataRu(body == null ? null : new String(body, StandardCharsets.UTF_8));
        model.setSubjectEn(this.enPane.subjectWidget.getValue());
        body = this.enPane.bodyWidget.getData();
        model.setDataEn(body == null ? null : new String(body, StandardCharsets.UTF_8));
        if (this.localPane != null) {
            this.localSubjectSetter.accept(model, this.localPane.subjectWidget.getValue());
            body = this.localPane.bodyWidget.getData();
            this.localBodySetter.accept(model, body == null ? null : new String(body, StandardCharsets.UTF_8));
        }
        model.getAdditionalAddresses().clear();
        model.getAdditionalAddresses().addAll(this.addressesWidget.getValues());
    }

    public boolean isDataChanged() {
        String body;
        if (!TextUtil.isSame((String)(this.data == null ? null : this.data.getSubjectRu()), (String)this.ruPane.subjectWidget.getValue())) {
            return true;
        }
        if (!TextUtil.isSame((String)(this.data == null ? null : this.data.getSubjectEn()), (String)this.enPane.subjectWidget.getValue())) {
            return true;
        }
        if (this.localPane != null && !TextUtil.isSame((String)(this.data == null ? null : this.localSubjectGetter.apply(this.data)), (String)this.localPane.subjectWidget.getValue())) {
            return true;
        }
        if (!MiscUtil.equals(this.data == null || this.data.getDataRu() == null ? null : this.data.getDataRu().getBytes(StandardCharsets.UTF_8), (Object)this.ruPane.bodyWidget.getData())) {
            return true;
        }
        if (!MiscUtil.equals(this.data == null || this.data.getDataEn() == null ? null : this.data.getDataEn().getBytes(StandardCharsets.UTF_8), (Object)this.enPane.bodyWidget.getData())) {
            return true;
        }
        if (this.localPane != null && !MiscUtil.equals((Object)((body = this.localBodyGetter.apply(this.data)) == null ? null : body.getBytes(StandardCharsets.UTF_8)), (Object)this.localPane.bodyWidget.getData())) {
            return true;
        }
        return !CollectionUtil.equals((Collection)(this.data == null ? Collections.emptySet() : this.data.getAdditionalAddresses()), (Collection)this.addressesWidget.getValues(), (boolean)true);
    }

    private void updateState() {
        boolean ro = this.viewState.isImmutable();
        this.ruPane.subjectWidget.getViewState().setReadonly(ro);
        this.ruPane.bodyWidget.setReadonly(ro);
        this.enPane.subjectWidget.getViewState().setReadonly(ro);
        this.enPane.bodyWidget.setReadonly(ro);
        if (this.localPane != null) {
            this.localPane.subjectWidget.getViewState().setReadonly(ro);
            this.localPane.bodyWidget.setReadonly(ro);
        }
        this.addressesWidget.getViewState().setReadonly(ro);
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                if (MultiLingualEmailWidget.this.localPane != null) {
                    return Arrays.asList(new Pane[]{MultiLingualEmailWidget.this.ruPane, MultiLingualEmailWidget.this.enPane, MultiLingualEmailWidget.this.localPane, MultiLingualEmailWidget.this.addressesWidget});
                }
                return Arrays.asList(new Pane[]{MultiLingualEmailWidget.this.ruPane, MultiLingualEmailWidget.this.enPane, MultiLingualEmailWidget.this.addressesWidget});
            }

            public String getInfo() {
                return ((Object)((Object)MultiLingualEmailWidget.this)).getClass().getSimpleName() + DevTools.getViewStateInfo((ViewState)MultiLingualEmailWidget.this.viewState);
            }
        };
    }
}

