/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.widgets;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.ImageWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.ibecorp.model.MultiLingualImageData;
import com.gridnine.xtrip.client.fx.ibecorp.widgets.LocalSiteLang;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;

public class MultiLingualImageWidget
extends CustomWidget<MultiLingualImageData>
implements DevTool {
    private final ViewState viewState = new ViewState();
    private final ImageWidget ruWidget;
    private final ImageWidget enWidget;
    private final Function<MultiLingualImageData, BinaryData> localGetter;
    private final BiConsumer<MultiLingualImageData, BinaryData> localSetter;
    private ImageWidget localWidget;

    private static void setValue(ImageWidget widget, BinaryData value) {
        widget.setData(value);
        widget.getProperties().put((Object)"__value", (Object)value);
    }

    private static boolean isDataChanged(ImageWidget widget) {
        return !MiscUtil.equals((Object)widget.getProperties().get((Object)"__value"), (Object)widget.getData());
    }

    public MultiLingualImageWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().add((Object)"multilingual-widget");
        TabPane tabPane = new TabPane();
        tabPane.getStyleClass().add((Object)"floating");
        tabPane.setSide(Side.LEFT);
        LocalSiteLang localSiteLang = LocalSiteLang.detect();
        if (localSiteLang != null) {
            switch (localSiteLang) {
                case BG: {
                    this.localGetter = MultiLingualImageData::getBg;
                    this.localSetter = MultiLingualImageData::setBg;
                    break;
                }
                case UK: {
                    this.localGetter = MultiLingualImageData::getUk;
                    this.localSetter = MultiLingualImageData::setUk;
                    break;
                }
                case HY: {
                    this.localGetter = MultiLingualImageData::getHy;
                    this.localSetter = MultiLingualImageData::setHy;
                    break;
                }
                case AZ: {
                    this.localGetter = MultiLingualImageData::getAz;
                    this.localSetter = MultiLingualImageData::setAz;
                    break;
                }
                case KA: {
                    this.localGetter = MultiLingualImageData::getKa;
                    this.localSetter = MultiLingualImageData::setKa;
                    break;
                }
                case KZ: {
                    this.localGetter = MultiLingualImageData::getKz;
                    this.localSetter = MultiLingualImageData::setKz;
                    break;
                }
                default: {
                    this.localGetter = null;
                    this.localSetter = null;
                }
            }
            if (this.localGetter != null) {
                this.localWidget = new ImageWidget(ro);
                this.initSetting(this.localWidget);
                Tab tab = new Tab(localSiteLang.getVariantTitle(), (Node)this.localWidget);
                tab.setTooltip(new Tooltip(localSiteLang.getVariantTooltip()));
                tab.setClosable(false);
                tabPane.getTabs().add((Object)tab);
            }
        } else {
            this.localGetter = null;
            this.localSetter = null;
        }
        this.ruWidget = new ImageWidget(ro);
        this.initSetting(this.ruWidget);
        Tab tab = new Tab(Messages.russianTitle, (Node)this.ruWidget);
        tab.setTooltip(new Tooltip(Messages.russianTooltip));
        tab.setClosable(false);
        tabPane.getTabs().add((Object)tab);
        this.enWidget = new ImageWidget(ro);
        this.initSetting(this.enWidget);
        tab = new Tab(Messages.englishTitle, (Node)this.enWidget);
        tab.setTooltip(new Tooltip(Messages.englishTooltip));
        tab.setClosable(false);
        tabPane.getTabs().add((Object)tab);
        this.getChildren().add((Object)tabPane);
        this.viewState.stateProperty().addListener(obj -> this.updateState());
    }

    private void initSetting(ImageWidget enWidget) {
        long fileSizeLimitInMb = 20L;
        Predicate<File> value = file -> {
            if (file.length() > fileSizeLimitInMb * 1024L * 1024L) {
                Message message = MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.getFile_size_limit(fileSizeLimitInMb), (Object[])new Object[0]);
                Notifications.get().showMessages(new Message[]{message});
                return false;
            }
            return true;
        };
        enWidget.setFileFilter(value);
        enWidget.setSupportedExtensions(new String[]{".jpg", ".jpeg", ".png", ".ico", ".svg"});
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public void setFieldName(String value) {
    }

    public void readData(MultiLingualImageData model) {
        MultiLingualImageWidget.setValue(this.ruWidget, model.getRu());
        MultiLingualImageWidget.setValue(this.enWidget, model.getEn());
        if (this.localWidget != null) {
            MultiLingualImageWidget.setValue(this.localWidget, this.localGetter.apply(model));
        }
    }

    public void writeData(MultiLingualImageData model) {
        model.setRu(this.ruWidget.getData());
        model.setEn(this.enWidget.getData());
        if (this.localWidget != null) {
            this.localSetter.accept(model, this.localWidget.getData());
        }
    }

    public boolean isDataChanged() {
        return MultiLingualImageWidget.isDataChanged(this.ruWidget) || MultiLingualImageWidget.isDataChanged(this.enWidget) || this.localWidget != null && MultiLingualImageWidget.isDataChanged(this.localWidget);
    }

    private void updateState() {
        this.ruWidget.getViewState().setReadonly(this.viewState.isImmutable());
        this.enWidget.getViewState().setReadonly(this.viewState.isImmutable());
        if (this.localWidget != null) {
            this.localWidget.getViewState().setReadonly(this.viewState.isImmutable());
        }
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                if (MultiLingualImageWidget.this.localWidget != null) {
                    return Arrays.asList(MultiLingualImageWidget.this.ruWidget, MultiLingualImageWidget.this.enWidget, MultiLingualImageWidget.this.localWidget);
                }
                return Arrays.asList(MultiLingualImageWidget.this.ruWidget, MultiLingualImageWidget.this.enWidget);
            }

            public String getInfo() {
                return ((Object)((Object)MultiLingualImageWidget.this)).getClass().getSimpleName() + DevTools.getViewStateInfo((ViewState)MultiLingualImageWidget.this.viewState);
            }
        };
    }
}

