/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.midoffice.entity.handlers;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DateTimeValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.IntValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.TextWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.AddCertificateOfCompletedFlightTask;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.AddCertificateOfCompletedFlightSegmentDialogVM;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.uidata.AirProductUIData;
import com.gridnine.xtrip.common.model.booking.air.uidata.SegmentUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;

public class AddCertificateOfCompletedFlightAction
extends BaseProductAction<Product> {
    public double getWeight() {
        return 250.0;
    }

    protected String getName() {
        return Messages.addCertificateOfCompletedFlight;
    }

    protected String getDescription() {
        return Messages.addCertificateOfCompletedFlight;
    }

    protected boolean isEnabled(Product product) {
        Date firstDepartureDate = AirProductHelper.getFirstDepartureDate((Product)product);
        return product != null && product.getStatus() == ProductStatus.SELL && !product.getSegmentTariffs().isEmpty() && product.getNextProduct() == null && firstDepartureDate != null && firstDepartureDate.before(new Date());
    }

    protected boolean isSaveRequired() {
        return true;
    }

    protected void execute(ProductActionContext<Product> ctx) {
        EntityReference reference = ctx.getRootPane().getData().getContainer().toReference();
        String productUid = ((Product)ctx.getSelectedProduct()).getUid();
        Notifications.get().submitTask(() -> {
            this.checkSegments(ctx);
            DataTransferPackage container = ((EntityService)((RpcServiceManager)Environment.getPublished(RpcServiceManager.class)).getService(EntityService.class)).load(ServiceInvocationContext.get(), reference, BookingFileUIData.class);
            BookingFileUIData bookingFileUIData = (BookingFileUIData)container.getSupplement();
            Product product = (Product)BookingHelper.findProduct((BookingFile)((BookingFile)container.getContainer().getEntity()), (String)productUid, Product.class);
            AirProductUIData productUIData = (AirProductUIData)bookingFileUIData.getProducts().stream().filter(prod -> prod.getRelatedProductUID().equals(productUid)).findFirst().get();
            Map<String, SegmentUIData> uiDataMap = productUIData.getSegmentsUIDataList().stream().collect(Collectors.toMap(SegmentUIData::getRelatedSegmentUID, segmentUIData -> segmentUIData));
            FxUtil.waitForFxThread(() -> {
                GridContainer segmentsContainer = new GridContainer();
                final TableWidget<AddCertificateOfCompletedFlightSegmentDialogVM> segmentsWidget = this.createSegmentsWidget();
                GridCell cell = new GridCell(segmentsWidget);
                segmentsContainer.getCells().add((Object)cell);
                TableWidgetController<TableWidget<AddCertificateOfCompletedFlightSegmentDialogVM>, AddCertificateOfCompletedFlightSegmentDialogVM> segmentsController = new TableWidgetController<TableWidget<AddCertificateOfCompletedFlightSegmentDialogVM>, AddCertificateOfCompletedFlightSegmentDialogVM>(){

                    public TableWidget<AddCertificateOfCompletedFlightSegmentDialogVM> getView() {
                        return segmentsWidget;
                    }
                };
                segmentsController.readData((Collection)product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).map(segment -> new AddCertificateOfCompletedFlightSegmentDialogVM(segment, (SegmentUIData)uiDataMap.get(segment.getUid()))).collect(Collectors.toList()));
                CardsContainer cardsContainer = new CardsContainer();
                cardsContainer.getCards().add((Object)new Card("segments", UiCardsContainer.Style.STATIC, Messages.Segments, (Node)segmentsContainer));
                new Dialog().setTitle(Messages.addCertificateOfCompletedFlight).setExpandToParent(true).setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_add, () -> {
                    List usedSegments = segmentsWidget.getRowsData().stream().filter(AddCertificateOfCompletedFlightSegmentDialogVM::isUsed).map(AddCertificateOfCompletedFlightSegmentDialogVM::getUid).collect(Collectors.toList());
                    AddCertificateOfCompletedFlightTask task = new AddCertificateOfCompletedFlightTask(productUid, ctx.getRootPane(), usedSegments);
                    Notifications.get().enqueueAsyncTask((ClientTask)task);
                }, (BooleanExpression)new BooleanBinding(){
                    {
                        BooleanValueWidgetColumn column = (BooleanValueWidgetColumn)segmentsWidget.getColumn("isUsed");
                        this.bind((Observable[])IntStream.range(0, segmentsWidget.getRowsCount()).mapToObj(arg_0 -> ((BooleanValueWidgetColumn)column).getWidget(arg_0)).map(BooleanValueWidget::valueProperty).toArray(ObjectProperty[]::new));
                    }

                    protected boolean computeValue() {
                        return segmentsWidget.getRowsData().stream().anyMatch(AddCertificateOfCompletedFlightSegmentDialogVM::isUsed);
                    }
                }).show((Node)ctx.getRootPane());
            });
        }, Messages.Loading_data);
    }

    private void checkSegments(ProductActionContext<Product> ctx) {
        Product product = (Product)ctx.getSelectedProduct();
        Segment lastSegment = AirProductHelper.getLastSegment((Product)product);
        Date lastDate = null;
        if (lastSegment != null) {
            lastDate = lastSegment.getEndDate();
        }
        if (lastDate != null) {
            HashMap<String, List<ProductIndex>> data = new HashMap<String, List<ProductIndex>>();
            ProductIndex idx = new ProductIndex(UUIDUtil.toString((UUID)UUID.randomUUID()));
            idx.setSource(ctx.getRootPane().getData().getContainer().toReference());
            idx.setReservationUid(((Product)ctx.getSelectedProduct()).getReservation().getUid());
            idx.setNavigationKey(product.getUid());
            data.put("PRODUCT_INDEXES", Collections.singletonList(idx));
            try {
                ((IntegrationBusRpcService)((RpcServiceManager)Environment.getPublished(RpcServiceManager.class)).getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "gds:update-coupon-status-task:update-coupon-status", data);
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)Xeption.forEndUser((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Throwable)e, (Object[])new Object[0]));
            }
        }
    }

    private TableWidget<AddCertificateOfCompletedFlightSegmentDialogVM> createSegmentsWidget() {
        TableWidget widget = new TableWidget(false);
        widget.setControlButtonsAvailability(ControlsPane.NONE);
        ArrayList<IntValueWidgetColumn> columns = new ArrayList<IntValueWidgetColumn>();
        IntValueWidgetColumn column = new IntValueWidgetColumn(AddCertificateOfCompletedFlightSegmentDialogVM::getNumber, AddCertificateOfCompletedFlightSegmentDialogVM::setNumber);
        column.setPrefWidthEm(Double.valueOf(5.0));
        column.setId("recordNumber");
        column.setCaption(Messages.Number);
        column.setNotEditable(Boolean.valueOf(true));
        columns.add(column);
        column = new TextWidgetColumn(AddCertificateOfCompletedFlightSegmentDialogVM::getDeparturePoint, AddCertificateOfCompletedFlightSegmentDialogVM::setDeparturePoint);
        column.setPrefWidthEm(Double.valueOf(20.0));
        column.setId("departurePoint");
        column.setCaption(Messages.From);
        column.setNotEditable(Boolean.valueOf(true));
        columns.add(column);
        column = new TextWidgetColumn(AddCertificateOfCompletedFlightSegmentDialogVM::getArrivalPoint, AddCertificateOfCompletedFlightSegmentDialogVM::setArrivalPoint);
        column.setPrefWidthEm(Double.valueOf(20.0));
        column.setId("arrivalPoint");
        column.setCaption(Messages.To);
        column.setNotEditable(Boolean.valueOf(true));
        columns.add(column);
        column = new TextWidgetColumn(AddCertificateOfCompletedFlightSegmentDialogVM::getCarrier, AddCertificateOfCompletedFlightSegmentDialogVM::setCarrier);
        column.setPrefWidthEm(Double.valueOf(10.0));
        column.setId("carrier");
        column.setCaption(Messages.Carrier);
        column.setNotEditable(Boolean.valueOf(true));
        columns.add(column);
        column = new DateTimeValueWidgetColumn(AddCertificateOfCompletedFlightSegmentDialogVM::getDepartureDate, AddCertificateOfCompletedFlightSegmentDialogVM::setDepartureDate);
        column.setPrefWidthEm(Double.valueOf(15.0));
        column.setId("departureDate");
        column.setCaption(Messages.Departure);
        column.setNotEditable(Boolean.valueOf(true));
        columns.add(column);
        column = new BooleanValueWidgetColumn(AddCertificateOfCompletedFlightSegmentDialogVM::isUsed, AddCertificateOfCompletedFlightSegmentDialogVM::setUsed);
        column.setPrefWidthEm(Double.valueOf(10.0));
        column.setId("isUsed");
        column.setCaption(Messages.Is_Used);
        columns.add(column);
        column = new BooleanValueWidgetColumn(AddCertificateOfCompletedFlightSegmentDialogVM::isFromGds, AddCertificateOfCompletedFlightSegmentDialogVM::setFromGds);
        column.setId("fromGds");
        column.setNotEditable(Boolean.valueOf(true));
        column.setCaption(Messages.Data_From_Gds);
        columns.add(column);
        widget.setColumns(columns);
        return widget;
    }
}

