/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.parsers.amadeus.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.parsers.AmadeusExchangeDocumentSpace;
import com.gridnine.xtrip.client.fx.model.parsers.AmadeusExchangeDocumentSpaceController;
import com.gridnine.xtrip.client.fx.model.parsers.AmadeusExchangeDocumentSpaceVM;
import com.gridnine.xtrip.client.fx.model.parsers.AmadeusExchangeDocumentTicketNumberVM;
import com.gridnine.xtrip.client.fx.model.parsers.AmadeusExchangeDocumentTravellerVM;
import com.gridnine.xtrip.client.fx.model.parsers.AmadeusExchangeDocumentUniqFullGeneralVM;
import com.gridnine.xtrip.client.fx.model.parsers.ContentFullVM;
import com.gridnine.xtrip.client.fx.model.parsers.ExchangeDocumentOverviewPanelVM;
import com.gridnine.xtrip.client.fx.model.parsers.GeneralParametersFullVM;
import com.gridnine.xtrip.client.fx.model.parsers.MessagesPaneVM;
import com.gridnine.xtrip.client.fx.parsers.amadeus.entity.handlers.AmadeusExchangeDocumentControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.ParsersHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.amadeus.AmadeusExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.amadeus.AmadeusExchangeDocumentIndex;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class AmadeusExchangeDocumentHandler
extends BaseRootEntityHandler<AmadeusExchangeDocument, Void, AmadeusExchangeDocumentSpaceVM, AmadeusExchangeDocumentSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return AmadeusExchangeDocumentIndex.class;
    }

    protected void configureController(List<BiConsumer<DataTransferPackage<AmadeusExchangeDocument, Void>, AmadeusExchangeDocumentSpaceVM>> toVM, List<BiConsumer<AmadeusExchangeDocumentSpaceVM, DataTransferPackage<AmadeusExchangeDocument, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new AmadeusExchangeDocumentControllerInterceptor());
        toVM.add((dtp, vm) -> {
            AmadeusExchangeDocument model = (AmadeusExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.overviewToVM((BaseExchangeDocument)model, (ExchangeDocumentOverviewPanelVM)vm.getOverview());
            ParsersHelper.generalParametersToVM((BaseExchangeDocument)model, (GeneralParametersFullVM)vm.getGeneralParametersFull());
            ParsersHelper.messagesToVM((BaseExchangeDocument)model, (MessagesPaneVM)vm.getMessagesFull());
            ParsersHelper.contentToVM((BaseExchangeDocument)model, (ContentFullVM)vm.getContentFull());
            AmadeusExchangeDocumentUniqFullGeneralVM uniqFullGeneralVM = vm.getAmadeusFull().getGeneralCard();
            uniqFullGeneralVM.setPnr(model.getPNR());
            uniqFullGeneralVM.setIssued(DateUtils.asLocalDate((Date)model.getOperationDate()));
            uniqFullGeneralVM.setTransactionType(model.getTransactionType());
            uniqFullGeneralVM.setOwner(model.getOwner());
            uniqFullGeneralVM.setUnsupportedOperation(model.isUnsupportedOperation() ? "\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439" : "\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439");
            model.getTicketNumbers().forEach(modelTicketNumber -> {
                AmadeusExchangeDocumentTicketNumberVM ticketNumberVM = new AmadeusExchangeDocumentTicketNumberVM();
                ticketNumberVM.setTicketNumber(modelTicketNumber);
                vm.getAmadeusFull().getTicketsCard().add(ticketNumberVM);
            });
            model.getTravellerNames().forEach(modelTraveller -> {
                AmadeusExchangeDocumentTravellerVM travellerVM = new AmadeusExchangeDocumentTravellerVM();
                travellerVM.setTraveller(modelTraveller);
                vm.getAmadeusFull().getTravellersCard().add(travellerVM);
            });
        });
        fromVM.add((vm, dtp) -> {
            AmadeusExchangeDocument model = (AmadeusExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.generalParametersFromVM((GeneralParametersFullVM)vm.getGeneralParametersFull(), (BaseExchangeDocument)model);
            ParsersHelper.contentFromVM((ContentFullVM)vm.getContentFull(), (BaseExchangeDocument)model);
            AmadeusExchangeDocumentUniqFullGeneralVM uniqFullGeneralVM = vm.getAmadeusFull().getGeneralCard();
            model.setPNR(uniqFullGeneralVM.getPnr());
            model.setOperationDate(DateUtils.asDate((LocalDate)uniqFullGeneralVM.getIssued()));
            model.setTransactionType(uniqFullGeneralVM.getTransactionType());
            model.setOwner(uniqFullGeneralVM.getOwner());
            model.setUnsupportedOperation(TextUtil.isSame((String)uniqFullGeneralVM.getUnsupportedOperation(), (String)"\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439"));
            model.getTicketNumbers().clear();
            vm.getAmadeusFull().getTicketsCard().forEach(ticketNumberVM -> model.getTicketNumbers().add(ticketNumberVM.getTicketNumber()));
            model.getTravellerNames().clear();
            vm.getAmadeusFull().getTravellersCard().forEach(travellerVM -> model.getTravellerNames().add(travellerVM.getTraveller()));
        });
    }

    public Class<AmadeusExchangeDocument> getEntityClass() {
        return AmadeusExchangeDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    protected ViewController<AmadeusExchangeDocumentSpace, AmadeusExchangeDocumentSpaceVM> createSpaceController(boolean readonly) {
        return new AmadeusExchangeDocumentSpaceController(readonly);
    }

    protected AmadeusExchangeDocumentSpaceVM createVM() {
        return new AmadeusExchangeDocumentSpaceVM();
    }
}

