/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.pg.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.pg.handlers.PGLogDocumentContainerControllerInterceptor;
import com.gridnine.xtrip.client.fx.pg.model.PGLogDocumentContainer;
import com.gridnine.xtrip.client.fx.pg.model.PGLogDocumentContainerController;
import com.gridnine.xtrip.client.fx.pg.model.PGLogDocumentContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.pg.model.PGLogDocument;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class PGLogDocumentHandler
extends BaseRootEntityHandler<PGLogDocument, Void, PGLogDocumentContainerVM, PGLogDocumentContainer> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicDocumentIndex.class;
    }

    protected void configureController(List<BiConsumer<DataTransferPackage<PGLogDocument, Void>, PGLogDocumentContainerVM>> toVM, List<BiConsumer<PGLogDocumentContainerVM, DataTransferPackage<PGLogDocument, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new PGLogDocumentContainerControllerInterceptor());
        toVM.add((dtp, vm) -> {
            PGLogDocument model = (PGLogDocument)dtp.getContainer().getEntity();
            vm.getMainSpecifications().setName(model.getName());
            vm.setDescription(model.getDescription());
            vm.getMainSpecifications().setOwner(model.getOwner());
            vm.getMainSpecifications().setTitle(model.getTitle());
            vm.getMainSpecifications().setPg(model.getPg());
            vm.getMainSpecifications().setPaymentID(model.getPaymentId());
            RichData data = new RichData();
            data.setContent(model.getContent());
            data.setContentType(model.getContentType());
            if (data.getContentType() == null) {
                data.setContentType(RichContentHandler.guessContentType((String)model.getName()));
            }
            vm.setContents(data);
            vm.getMainSpecifications().setCreated(DateUtils.asLocalDate((Date)model.getCreated()));
        });
        fromVM.add((vm, dtp) -> {
            PGLogDocument model = (PGLogDocument)dtp.getContainer().getEntity();
            model.setName(vm.getMainSpecifications().getName());
            model.setTitle(vm.getMainSpecifications().getTitle());
            model.setOwner(vm.getMainSpecifications().getOwner());
            model.setDescription(vm.getDescription());
            model.setPg(vm.getMainSpecifications().getPg());
            model.setPaymentId(vm.getMainSpecifications().getPaymentID());
            model.setContentType(vm.getContents() == null ? null : vm.getContents().getContentType());
            model.setContent(vm.getContents() == null ? null : vm.getContents().getContent());
            model.setCreated(DateUtils.asDate((LocalDate)vm.getMainSpecifications().getCreated()));
        });
    }

    protected ViewController<PGLogDocumentContainer, PGLogDocumentContainerVM> createSpaceController(boolean readonly) {
        return new PGLogDocumentContainerController(readonly);
    }

    protected PGLogDocumentContainerVM createVM() {
        return new PGLogDocumentContainerVM();
    }

    public Class<PGLogDocument> getEntityClass() {
        return PGLogDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }
}

