/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.pg.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.pg.handlers.PgMultiLogDocumentContainerControllerInterceptor;
import com.gridnine.xtrip.client.fx.pg.model.PgMultiLogDocumentContainer;
import com.gridnine.xtrip.client.fx.pg.model.PgMultiLogDocumentContainerController;
import com.gridnine.xtrip.client.fx.pg.model.PgMultiLogDocumentContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.pg.PgMultiLogDocument;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class PgMultiLogDocumentHandler
extends BaseRootEntityHandler<PgMultiLogDocument, Void, PgMultiLogDocumentContainerVM, PgMultiLogDocumentContainer> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicDocumentIndex.class;
    }

    protected void configureController(List<BiConsumer<DataTransferPackage<PgMultiLogDocument, Void>, PgMultiLogDocumentContainerVM>> toVM, List<BiConsumer<PgMultiLogDocumentContainerVM, DataTransferPackage<PgMultiLogDocument, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new PgMultiLogDocumentContainerControllerInterceptor());
        toVM.add((dtp, vm) -> {
            PgMultiLogDocument model = (PgMultiLogDocument)dtp.getContainer().getEntity();
            vm.getMainSpecifications().setName(model.getName());
            vm.setDescription(model.getDescription());
            vm.getMainSpecifications().setOwner(model.getOwner());
            vm.getMainSpecifications().setTitle(model.getTitle());
            vm.getMainSpecifications().setSessionId(model.getSessionId());
            RichData data = new RichData();
            data.setContent(model.getContent());
            data.setContentType(model.getContentType());
            if (data.getContentType() == null) {
                data.setContentType(RichContentHandler.guessContentType((String)model.getName()));
            }
            vm.setContents(data);
            vm.getMainSpecifications().setCreated(DateUtils.asLocalDate((Date)model.getCreated()));
        });
        fromVM.add((vm, dtp) -> {
            PgMultiLogDocument model = (PgMultiLogDocument)dtp.getContainer().getEntity();
            model.setName(vm.getMainSpecifications().getName());
            model.setTitle(vm.getMainSpecifications().getTitle());
            model.setOwner(vm.getMainSpecifications().getOwner());
            model.setDescription(vm.getDescription());
            model.setSessionId(vm.getMainSpecifications().getSessionId());
            model.setContentType(vm.getContents() == null ? null : vm.getContents().getContentType());
            model.setContent(vm.getContents() == null ? null : vm.getContents().getContent());
            model.setCreated(DateUtils.asDate((LocalDate)vm.getMainSpecifications().getCreated()));
        });
    }

    protected ViewController<PgMultiLogDocumentContainer, PgMultiLogDocumentContainerVM> createSpaceController(boolean readonly) {
        return new PgMultiLogDocumentContainerController(readonly);
    }

    protected PgMultiLogDocumentContainerVM createVM() {
        return new PgMultiLogDocumentContainerVM();
    }

    public Class<PgMultiLogDocument> getEntityClass() {
        return PgMultiLogDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }
}

