/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway;

import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.railway.entity.handlers.product.helper.RailwayCrimeaMcoFXHelper;
import com.gridnine.xtrip.client.fx.railway.entity.handlers.product.helper.RailwayMcoProductFXHelper;
import com.gridnine.xtrip.client.fx.railway.entity.handlers.product.helper.RailwayProductFXHelper;
import com.gridnine.xtrip.client.fx.railway.entity.handlers.product.helper.RailwayReferenceMcoFXHelper;
import com.gridnine.xtrip.client.fx.railway.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.factory.StandardCategories;
import com.gridnine.xtrip.client.fx.standard.helpers.CreateBookingHelper;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayCrimeaMCOUIData;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayMcoProductUIData;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayProductUIData;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayReferenceMCOUIData;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.util.MiscUtil;

enum RailwayFactoryTools implements FactoryTool
{
    RAILWAY_PRODUCT{

        public String getName() {
            return Messages.Railroad_ticket;
        }

        public double getWeight() {
            return 60.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<RailwayProduct, RailwayProductUIData> prototypeData = RailwayProductFXHelper.getPrototypeData();
                RailwayProduct product = (RailwayProduct)prototypeData.getFirst();
                RailwayProductUIData productSupplementData = (RailwayProductUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, (boolean)false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    RAILWAY_CRIMEA_MCO{

        public String getName() {
            return Messages.Railroad_KRS_Crim;
        }

        public double getWeight() {
            return 70.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<RailwayCrimeaMco, RailwayCrimeaMCOUIData> prototypeData = RailwayCrimeaMcoFXHelper.getPrototypeData();
                RailwayCrimeaMco product = (RailwayCrimeaMco)prototypeData.getFirst();
                RailwayCrimeaMCOUIData productSupplementData = (RailwayCrimeaMCOUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, (boolean)false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    RAILWAY_REFERENCE_MCO{

        public String getName() {
            return Messages.Railroad_reference;
        }

        public double getWeight() {
            return 80.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<RailwayReferenceMCO, RailwayReferenceMCOUIData> prototypeData = RailwayReferenceMcoFXHelper.getPrototypeData();
                RailwayReferenceMCO product = (RailwayReferenceMCO)prototypeData.getFirst();
                RailwayReferenceMCOUIData productSupplementData = (RailwayReferenceMCOUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, (boolean)false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    }
    ,
    RAILWAY_MCO_PRODUCT{

        public String getName() {
            return Messages.Railway_MCO_product;
        }

        public double getWeight() {
            return 90.0;
        }

        public void execute() {
            CreateBookingHelper.createBookingFile((bookingFile, bookingFileSupplementData, parameters) -> {
                MiscUtil.Pair<RailwayMcoProduct, RailwayMcoProductUIData> prototypeData = RailwayMcoProductFXHelper.getPrototypeData();
                RailwayMcoProduct product = (RailwayMcoProduct)prototypeData.getFirst();
                RailwayMcoProductUIData productSupplementData = (RailwayMcoProductUIData)prototypeData.getSecond();
                Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
                reservation.getProducts().add(product);
                product.setReservation(reservation);
                bookingFileSupplementData.getProducts().add(productSupplementData);
            }, (boolean)false);
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }
    };


    public String getUid() {
        return "railway-tools:" + this.name();
    }

    public FactoryToolCategory getCategory() {
        return StandardCategories.BOOKINGS;
    }

    public boolean isAuxiliary() {
        return false;
    }
}

