/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.railway.rpc.RailwayService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;

public class RailwayProductVatRecalculateAction
extends BaseProductAction<RailwayProduct> {
    public double getWeight() {
        return 60.0;
    }

    protected String getName() {
        return Messages.recalculateVat;
    }

    protected String getDescription() {
        return Messages.recalculateVat;
    }

    protected boolean isEnabled(RailwayProduct product) {
        return product != null && !product.isDontRecalculateVAT();
    }

    protected boolean isSaveRequired() {
        return true;
    }

    protected void execute(ProductActionContext<RailwayProduct> ctx) {
        String productUid = ((RailwayProduct)ctx.getSelectedProduct()).getUid();
        EntityReference bfRef = ctx.getRootPane().getData().getContainer().toReference();
        Dialog.confirm((Node)ctx.getRootPane(), (String)Messages.recalculateVat, () -> Notifications.get().submitTask(() -> this.recalculateVat((EntityReference<BookingFile>)bfRef, productUid), ctx.getRootPane().getMutex()));
    }

    private void recalculateVat(EntityReference<BookingFile> bfRef, String productUid) throws Exception {
        List messages = ((RailwayService)RpcServiceManager.get().getService(RailwayService.class)).recalculateVAT(ServiceInvocationContext.get(), bfRef, productUid);
        Notifications.get().showMessages((Collection)messages);
        if (!ValidationUtil.hasErrors((Iterable)messages)) {
            EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(bfRef, EntityModification.ModificationType.CHANGE)));
        }
    }
}

