/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.handlers.parsers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.parsers.ContentFullVM;
import com.gridnine.xtrip.client.fx.model.parsers.ExchangeDocumentOverviewPanelVM;
import com.gridnine.xtrip.client.fx.model.parsers.GeneralParametersFullVM;
import com.gridnine.xtrip.client.fx.model.parsers.MessagesPaneVM;
import com.gridnine.xtrip.client.fx.railway.model.parsers.UFSExchangeDocumentSpace;
import com.gridnine.xtrip.client.fx.railway.model.parsers.UFSExchangeDocumentSpaceController;
import com.gridnine.xtrip.client.fx.railway.model.parsers.UFSExchangeDocumentSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.ParsersHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocument;
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocumentIndex;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class UFSExchangeDocumentHandler
extends BaseRootEntityHandler<UFSExchangeDocument, Void, UFSExchangeDocumentSpaceVM, UFSExchangeDocumentSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return UFSExchangeDocumentIndex.class;
    }

    protected void configureController(List<BiConsumer<DataTransferPackage<UFSExchangeDocument, Void>, UFSExchangeDocumentSpaceVM>> toVM, List<BiConsumer<UFSExchangeDocumentSpaceVM, DataTransferPackage<UFSExchangeDocument, Void>>> fromVM) {
        toVM.add((dtp, vm) -> {
            UFSExchangeDocument model = (UFSExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.overviewToVM((BaseExchangeDocument)model, (ExchangeDocumentOverviewPanelVM)vm.getOverview());
            ParsersHelper.generalParametersToVM((BaseExchangeDocument)model, (GeneralParametersFullVM)vm.getGeneralParametersFull());
            ParsersHelper.messagesToVM((BaseExchangeDocument)model, (MessagesPaneVM)vm.getMessagesFull());
            ParsersHelper.contentToVM((BaseExchangeDocument)model, (ContentFullVM)vm.getContentFull());
            vm.getFileUFSFull().setBookingFile(model.getRelatedBookingFile());
            vm.getFileUFSFull().setIssued(DateUtils.asLocalDate((Date)model.getIssued()));
            vm.getFileUFSFull().setTicketNumber(model.getSystemNumber());
            vm.getFileUFSFull().setTransactionType(model.getTransactionType());
            vm.getFileUFSFull().setTravelerName(String.join((CharSequence)",", model.getTravellers()));
        });
        fromVM.add((vm, dtp) -> {
            UFSExchangeDocument model = (UFSExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.generalParametersFromVM((GeneralParametersFullVM)vm.getGeneralParametersFull(), (BaseExchangeDocument)model);
            ParsersHelper.contentFromVM((ContentFullVM)vm.getContentFull(), (BaseExchangeDocument)model);
            model.setRelatedBookingFile(vm.getFileUFSFull().getBookingFile());
            model.setIssued(DateUtils.asDate((LocalDate)vm.getFileUFSFull().getIssued()));
            model.setSystemNumber(vm.getFileUFSFull().getTicketNumber());
            model.setTransactionType(vm.getFileUFSFull().getTransactionType());
            model.getTravellers().clear();
            if (vm.getFileUFSFull().getTravelerName() != null) {
                model.getTravellers().addAll(Arrays.asList(vm.getFileUFSFull().getTravelerName().split(",")));
            }
        });
    }

    protected ViewController<UFSExchangeDocumentSpace, UFSExchangeDocumentSpaceVM> createSpaceController(boolean readonly) {
        return new UFSExchangeDocumentSpaceController(readonly);
    }

    protected UFSExchangeDocumentSpaceVM createVM() {
        return new UFSExchangeDocumentSpaceVM();
    }

    public Class<UFSExchangeDocument> getEntityClass() {
        return UFSExchangeDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }
}

