/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.handlers.product;

import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.railway.l10n.Messages;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileRailwayMcoProductPanel;
import com.gridnine.xtrip.client.fx.railway.tasks.dialog.RailwayMCOProductRefundDialog;
import com.gridnine.xtrip.client.fx.standard.entity.actions.productcopy.CopyTask;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.CopyProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MoveNextProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MovePrevProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.PayProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RecalculateFOPProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RefundProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RefusePaymentProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnpayProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnrefusePaymentProductAction;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;

public class RailwayMcoActionsProvider
implements ProductActionsProvider {
    private List<TileAction<Node, BookingFileProductsFullPanel>> actions;

    public String getId() {
        return "standard-railway-mco-product-actions-provider";
    }

    public boolean isApplicableTo(Node productView) {
        return productView instanceof BookingFileRailwayMcoProductPanel;
    }

    public List<TileAction<Node, BookingFileProductsFullPanel>> getAvailableActions() {
        if (this.actions != null) {
            return this.actions;
        }
        this.actions = Arrays.asList(new MovePrevProductAction<RailwayMcoProduct>(){

            protected BaseProduct getPreviousProduct(RailwayMcoProduct product) {
                return product.getPreviousProduct();
            }
        }, new MoveNextProductAction<RailwayMcoProduct>(){

            protected BaseProduct getNextProduct(RailwayMcoProduct product) {
                return product.getNextProduct();
            }
        }, new RecalculateFOPProductAction(), new CopyProductAction<RailwayMcoProduct>(){

            protected boolean isEnabled(RailwayMcoProduct product) {
                return product != null && (product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.BOOKING || product.getStatus() == ProductStatus.VOID_BOOKING || product.getStatus() == ProductStatus.VOID);
            }

            protected void execute(ProductActionContext<RailwayMcoProduct> ctx) {
                CopyTask.showCopyDialog((EntityReference)ctx.getRootPane().getData().getContainer().toReference(), (String)((RailwayMcoProduct)ctx.getSelectedProduct()).getUid(), (Node)ctx.getRootPane(), (ObservableMutex)ctx.getRootPane().getMutex());
            }
        }, new PayProductAction<RailwayMcoProduct>(){

            protected ProductStatus getStatus(RailwayMcoProduct product) {
                return product.getStatus();
            }
        }, new UnpayProductAction<RailwayMcoProduct>(){

            protected ProductStatus getStatus(RailwayMcoProduct product) {
                return product.getStatus();
            }
        }, new RefusePaymentProductAction<RailwayMcoProduct>(){

            protected ProductStatus getStatus(RailwayMcoProduct product) {
                return product.getStatus();
            }
        }, new UnrefusePaymentProductAction<RailwayMcoProduct>(){

            protected ProductStatus getStatus(RailwayMcoProduct product) {
                return product.getStatus();
            }
        }, new RefundProductAction<RailwayMcoProduct>(){

            protected boolean isEnabled(RailwayMcoProduct product) {
                return product != null && product.getStatus() == ProductStatus.SELL && product.getNextProduct() == null && product.getReservation().getBookingFile().getNumber() != null;
            }

            protected void execute(ProductActionContext<RailwayMcoProduct> ctx) {
                Notifications.get().submitTask(() -> {
                    RailwayMCOProductRefundDialog dialog = new RailwayMCOProductRefundDialog(ctx.getRootPane(), (RailwayMcoProduct)ctx.getSelectedProduct());
                    FxUtil.submitToFxThread(dialog::showDialog);
                }, Messages.Railroad_ticket_payback);
            }
        });
        return this.actions;
    }
}

