/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.handlers.product.controllerInterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;

public class AddRailwayProductsDialog {
    private final Node parent;
    private final TableWidget<RelatedProductsTableVM> productsWidget;
    private TableWidgetController<TableWidget<RelatedProductsTableVM>, RelatedProductsTableVM> productsController;

    public AddRailwayProductsDialog(Node parent, List<RailwayProduct> products) {
        this.parent = parent;
        this.productsWidget = new TableWidget(false);
        this.productsWidget.setItemsProvider(RelatedProductsTableVM::new);
        this.productsWidget.setControlButtonsAvailability(ControlsPane.NONE);
        ArrayList<InfoWidgetColumn> columns = new ArrayList<InfoWidgetColumn>();
        InfoWidgetColumn column = new InfoWidgetColumn(RelatedProductsTableVM::getProduct, RelatedProductsTableVM::setProduct);
        column.setId("product");
        column.setCaption(Messages.Name);
        columns.add(column);
        column = new BooleanValueWidgetColumn(RelatedProductsTableVM::isChecked, RelatedProductsTableVM::setChecked);
        column.setId("checked");
        column.setCaption(Messages.Add_to_related);
        columns.add(column);
        this.productsWidget.setColumns(columns);
        this.productsController = new TableWidgetController<TableWidget<RelatedProductsTableVM>, RelatedProductsTableVM>(){

            public TableWidget<RelatedProductsTableVM> getView() {
                return AddRailwayProductsDialog.this.productsWidget;
            }
        };
        List productsVM = products.stream().map(prod -> {
            RelatedProductsTableVM productVM = new RelatedProductsTableVM();
            productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)prod));
            productVM.setProductReference((RailwayProduct)prod);
            productVM.setProductUID(prod.getUid());
            productVM.setChecked(false);
            return productVM;
        }).collect(Collectors.toList());
        this.productsController.readData(productsVM);
    }

    public List<RailwayProduct> getSelectedProducts() {
        ArrayList productsVM = new ArrayList();
        this.productsController.writeData(productsVM);
        return productsVM.stream().filter(vm -> vm.isChecked()).map(vm -> vm.getProductReference()).collect(Collectors.toList());
    }

    public void showDialog(Runnable clb) {
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("products", UiCardsContainer.Style.STATIC, Messages.Services, (Node)GridContainer.wrap(this.productsWidget)));
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Add_related_services).setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_add, () -> {
            dialog.close();
            clb.run();
        }, (BooleanExpression)new BooleanBinding(){
            {
                this.bind((Observable[])this.getAllCheckWidgets().map(BooleanValueWidget::valueProperty).toArray(ObjectProperty[]::new));
            }

            protected boolean computeValue() {
                return this.getAllCheckWidgets().anyMatch(BooleanValueWidget::getValue);
            }

            private Stream<BooleanValueWidget> getAllCheckWidgets() {
                BooleanValueWidgetColumn column = (BooleanValueWidgetColumn)AddRailwayProductsDialog.this.productsWidget.getColumn("checked");
                return IntStream.range(0, AddRailwayProductsDialog.this.productsWidget.getRowsCount()).mapToObj(arg_0 -> ((BooleanValueWidgetColumn)column).getWidget(arg_0));
            }
        }).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).setExpandToParent(true).show(this.parent);
    }

    public static class RelatedProductsTableVM {
        private String product;
        private RailwayProduct productReference;
        private String productUID;
        private boolean checked;

        public String getProduct() {
            return this.product;
        }

        public void setProduct(String value) {
            this.product = value;
        }

        public RailwayProduct getProductReference() {
            return this.productReference;
        }

        public void setProductReference(RailwayProduct value) {
            this.productReference = value;
        }

        public String getProductUID() {
            return this.productUID;
        }

        public void setProductUID(String value) {
            this.productUID = value;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean value) {
            this.checked = value;
        }
    }
}

