/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.handlers.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductRailwayPassengerParametersPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductRailwayPassengerVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileRailwayMcoRelatedProductsTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileRailwayMcoRelatedProductsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayStatusesPaneVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileRailwayMcoGeneralPanelVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileRailwayMcoProductCostSumVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileRailwayMcoProductCostVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileRailwayMcoProductPanel;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileRailwayMcoProductPanelVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileRailwayMcoProductSegmentsTableVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayMcoProductUIData;
import com.gridnine.xtrip.common.fx.railway.rpc.RailwayProductPrototypeService;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayMcoProductHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RailwayMcoProductFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    public static void toVMAllPanels(RailwayMcoProduct product, RailwayMcoProductUIData productData, BookingFileRailwayMcoProductPanelVM productVM) {
        productVM.setUid(product.getUid());
        productVM.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        RailwayMcoProductFXHelper.toVMGeneral(productVM.getGeneral(), product, productData);
        RailwayMcoProductFXHelper.toVMControlStatuses(productVM.getStatuses(), product, productData);
        RailwayMcoProductFXHelper.toVMRailwaySegments(product, productVM);
        RailwayMcoProductFXHelper.toVMRailwayCostLeftTable(product, productVM.getCostAndRelated().getCost());
        RailwayMcoProductFXHelper.toVMRailwayMcoRelatedProducts(productVM.getCostAndRelated().getRelated(), product);
        productVM.getOtherParameters().getPopups().getComments().setComments(product.getComments());
    }

    private static void toVMRailwayCostLeftTable(RailwayMcoProduct product, BookingFileRailwayMcoProductCostVM vm) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        String gdsCurrency = (String)MiscUtil.guarded((Object)product.getGdsCurrency(), (Object)Prefetched.getData().getEquivalentCurrency(), (Object[])new String[]{"RUB"});
        BookingFileRailwayMcoProductCostSumVM sumCell = vm.getSum();
        sumCell.setTariffSumValue(RailwayMcoProductFXHelper.getValue(product.getEquivalentFare(), negate));
        sumCell.setTariffTAXValue(RailwayMcoProductFXHelper.getValue(product.getEquivalentVat(), negate));
        sumCell.setTariffCurrencyValue(gdsCurrency);
        sumCell.setFineSumValue(product.getPenaltyFare());
        sumCell.setFineTAXValue(product.getPenaltyVat());
        sumCell.setTotalSumValue(product.getTotalAmount());
        sumCell.setTotalTAXValue(product.getTotalVat());
        sumCell.setFineTaxCurrencyValue(gdsCurrency);
        sumCell.setTotalTaxCurrencyValue(gdsCurrency);
    }

    private static void toVMRailwaySegments(RailwayMcoProduct product, BookingFileRailwayMcoProductPanelVM productVM) {
        VMHelper.transfer((Collection)product.getSegments(), (Collection)productVM.getSegments(), railwaySegment -> {
            BookingFileRailwayMcoProductSegmentsTableVM result = new BookingFileRailwayMcoProductSegmentsTableVM();
            result.setSegment(railwaySegment.getNumber());
            result.setDeparturePoint(railwaySegment.getDepartureStation());
            result.setArrivalPoint(railwaySegment.getArriveStation());
            result.setTrainNumber(railwaySegment.getTrainNumber());
            result.setCarriageNumber(railwaySegment.getCarriageNumber());
            result.setCarriageType(railwaySegment.getCarriageType());
            result.setPlaces(String.join((CharSequence)", ", railwaySegment.getPlaces()));
            result.setDepartureDate(DateUtils.asLocalDateTime((Date)railwaySegment.getDepartureDate()));
            result.setLocalDepartureDate(DateUtils.asLocalDateTime((Date)railwaySegment.getLocalDepartureDate()));
            result.setFare(railwaySegment.getFare());
            result.setEqFare(railwaySegment.getEquivalentFare());
            result.setVat(railwaySegment.getEquivalentVAT());
            return result;
        });
    }

    private static void toVMControlStatuses(BookingFileProductRailwayStatusesPaneVM vm, RailwayMcoProduct product, RailwayMcoProductUIData productData) {
        vm.setChecked(product.isChecked());
        vm.setFinished(product.isCompleted());
        vm.setHasErrors(productData.isHasErrors());
        vm.setHasWarnings(productData.isHasWarnings());
        vm.setRulesApplied(product.isContractRulesApplied());
    }

    private static void toVMGeneral(BookingFileRailwayMcoGeneralPanelVM generalVM, RailwayMcoProduct product, RailwayMcoProductUIData productData) {
        String providerSystemNumber = product.getProviderSystemNumber();
        if (!TextUtil.isBlank((String)providerSystemNumber)) {
            generalVM.getTicketInfo().setProviderTicketNumberValue(providerSystemNumber);
        }
        generalVM.getTicketInfo().setProductValue(ProductType.RAILWAY_MCO.toString());
        generalVM.getTicketInfo().setTicketNumberValue(product.getSystemNumber());
        generalVM.getTicketInfo().setStatusValue(product.getStatus().toString());
        generalVM.getTicketInfo().setBlankValue(product.getBlankType());
        generalVM.getTicketInfo().setProviderValue(product.getProvider());
        generalVM.getTicketInfo().setCategoryValue(product.getMcoCategory());
        generalVM.getTicketInfo().setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        generalVM.getTicketInfo().setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        generalVM.getTravelerInfo().getInfo().setStationValue(product.getPcc());
        generalVM.getTravelerInfo().getInfo().setReservationValue(product.getReservation().getUid());
        generalVM.getTravelerInfo().getInfo().setTicketTypeValue(product.getTicketType());
        BookingFileProductRailwayPassengerParametersPaneVM passengersVM = generalVM.getTravelerInfo().getPassengers();
        passengersVM.getPassengers().clear();
        product.getPassengers().forEach(traveller -> {
            BookingFileProductRailwayPassengerVM passengerVM = new BookingFileProductRailwayPassengerVM();
            passengerVM.setPassenger(traveller);
            DictionaryReference passengerType = RailwayMcoProductHelper.getPassengerType((RailwayMcoProduct)product, (Traveller)traveller);
            passengerVM.setPassengerType(passengerType);
            passengersVM.getPassengers().add(passengerVM);
        });
        generalVM.getTravelerInfo().getInfo().setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        generalVM.getTravelerInfo().getInfo().setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
        generalVM.getSalesChain().setBlankOwnerValue(product.getBlankOwnerRef());
        generalVM.getSalesChain().setSupplierValue(productData.getSupplier());
        generalVM.getSalesChain().setAgencyValue(productData.getAgency());
        generalVM.getSalesChain().setSubagencyValue(productData.getSubagency());
        generalVM.getSalesChain().setBranchValue(product.getBranch());
        generalVM.getSalesChain().setSalesPointValue(product.getSalesPoint());
        generalVM.getSalesChain().setPrescribeAgentValue(product.getCashier());
    }

    private static void toVMRailwayMcoRelatedProducts(BookingFileRailwayMcoRelatedProductsVM vm, RailwayMcoProduct product) {
        vm.setBookingFile(product.getReservation().getBookingFile());
        vm.setProductUid(product.getUid());
        product.getRelatedProducts().forEach(p -> {
            BookingFileRailwayMcoRelatedProductsTableVM productVM = new BookingFileRailwayMcoRelatedProductsTableVM();
            productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)p));
            productVM.setProductUID(p.getUid());
            vm.getRelatedProducts().add(productVM);
        });
    }

    public static void fromVMRailwayAdditionalParameters(BookingFileRailwayMcoProductPanelVM productVM, RailwayMcoProduct product) {
        product.setComments(productVM.getOtherParameters().getPopups().getComments().getComments());
    }

    public static void fromVMCostVM(BookingFileRailwayMcoProductCostVM vm, RailwayMcoProduct product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileRailwayMcoProductCostSumVM sumCell = vm.getSum();
        product.setEquivalentFare(RailwayMcoProductFXHelper.getValue(sumCell.getTariffSumValue(), negate));
        product.setEquivalentVat(RailwayMcoProductFXHelper.getValue(sumCell.getTariffTAXValue(), negate));
        product.setPenaltyFare(sumCell.getFineSumValue());
        product.setPenaltyVat(sumCell.getFineTAXValue());
        product.setTotalAmount(sumCell.getTotalSumValue());
        product.setTotalVat(sumCell.getTotalTAXValue());
        product.setGdsCurrency(sumCell.getTariffCurrencyValue());
    }

    public static void fromVMSegmentsVM(BookingFileRailwayMcoProductPanelVM productVM, RailwayMcoProduct product) {
        VMHelper.transfer((Collection)productVM.getSegments(), (Collection)product.getSegments(), segmentVM -> {
            RailwaySegment railwaySegment = new RailwaySegment();
            railwaySegment.setDepartureStation(segmentVM.getDeparturePoint());
            railwaySegment.setArriveStation(segmentVM.getArrivalPoint());
            railwaySegment.setTrainNumber(segmentVM.getTrainNumber());
            railwaySegment.setCarriageNumber(segmentVM.getCarriageNumber());
            railwaySegment.setCarriageType(segmentVM.getCarriageType());
            railwaySegment.getPlaces().add(segmentVM.getPlaces());
            railwaySegment.setDepartureDate(DateUtils.asDate((LocalDateTime)segmentVM.getDepartureDate()));
            railwaySegment.setLocalDepartureDate(DateUtils.asDate((LocalDateTime)segmentVM.getLocalDepartureDate()));
            railwaySegment.setFare(segmentVM.getFare());
            railwaySegment.setEquivalentFare(segmentVM.getEqFare());
            railwaySegment.setEquivalentVAT(segmentVM.getVat());
            return railwaySegment;
        });
    }

    public static void fromVMParameters(BookingFileRailwayMcoProductPanelVM productVM, RailwayMcoProduct product, RailwayMcoProductUIData productData) {
        product.setSystemNumber(productVM.getGeneral().getTicketInfo().getTicketNumberValue());
        product.setBlankType(productVM.getGeneral().getTicketInfo().getBlankValue());
        product.setProvider(productVM.getGeneral().getTicketInfo().getProviderValue());
        product.setMcoCategory(productVM.getGeneral().getTicketInfo().getCategoryValue());
        product.setProviderSystemNumber(productVM.getGeneral().getTicketInfo().getProviderTicketNumberValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)productVM.getGeneral().getTicketInfo().getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)productVM.getGeneral().getTicketInfo().getCorrectionDateValue()));
        product.setPcc(productVM.getGeneral().getTravelerInfo().getInfo().getStationValue());
        product.setTicketType(productVM.getGeneral().getTravelerInfo().getInfo().getTicketTypeValue());
        BookingFileProductRailwayPassengerParametersPaneVM passengersVM = productVM.getGeneral().getTravelerInfo().getPassengers();
        List passengers = product.getPassengers();
        passengers.clear();
        product.getPassengerTypes().clear();
        passengersVM.getPassengers().forEach(passengerVM -> {
            if (passengerVM.getPassenger() != null) {
                Traveller traveller = GeneralProductFXHelper.findTraveller((BookingFile)product.getReservation().getBookingFile(), (String)passengerVM.getPassenger().getUid());
                if (traveller != null) {
                    passengers.add(traveller);
                }
                RailwayMcoProductHelper.setPassengerType((RailwayMcoProduct)product, (Traveller)traveller, (DictionaryReference)passengerVM.getPassengerType());
            }
        });
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)productVM.getGeneral().getTravelerInfo().getInfo().getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)productVM.getGeneral().getTravelerInfo().getInfo().getShipmentsDateSubagentValue()));
        product.setBlankOwnerRef(productVM.getGeneral().getSalesChain().getBlankOwnerValue());
        product.setBranch(productVM.getGeneral().getSalesChain().getBranchValue());
        product.setSalesPoint(productVM.getGeneral().getSalesChain().getSalesPointValue());
        product.setCashier(productVM.getGeneral().getSalesChain().getPrescribeAgentValue());
        productData.setSupplier(productVM.getGeneral().getSalesChain().getSupplierValue());
        productData.setAgency(productVM.getGeneral().getSalesChain().getAgencyValue());
        productData.setSubagency(productVM.getGeneral().getSalesChain().getSubagencyValue());
        product.setChecked(productVM.getStatuses().isChecked());
        product.setCompleted(productVM.getStatuses().isFinished());
        product.setContractRulesApplied(productVM.getStatuses().isRulesApplied());
    }

    public static void fromVMRailwayMcoRelatedProducts(BookingFileRailwayMcoRelatedProductsVM productsVM, RailwayMcoProduct product) {
        Map<String, RailwayProduct> productMap = product.getReservation().getBookingFile().getReservations().stream().flatMap(el -> el.getProducts().stream()).filter(el -> el instanceof RailwayProduct).map(el -> (RailwayProduct)el).collect(Collectors.toMap(BaseIdentity::getUid, el -> el));
        product.getRelatedProducts().forEach(prod -> productMap.put(prod.getUid(), (RailwayProduct)prod));
        product.getRelatedProducts().clear();
        product.getRelatedProducts().addAll(productsVM.getRelatedProducts().stream().map(vm -> (RailwayProduct)productMap.get(vm.getProductUID())).collect(Collectors.toList()));
    }

    public static MiscUtil.Pair<RailwayMcoProduct, RailwayMcoProductUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        RailwayMcoProduct product = new RailwayMcoProduct();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((RailwayProductPrototypeService)RpcServiceManager.get().getService(RailwayProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new RailwayMcoProduct(), (Object)new RailwayMcoProductUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileRailwayMcoProductPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(RailwayMcoProduct.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }
}

