/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.handlers.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductChildParametersTicketInfoVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductRailwayMCOGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayMCOPanel;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayMCOPanelVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayMCOParametersPaneVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayReferenceMCOUIData;
import com.gridnine.xtrip.common.fx.railway.rpc.RailwayProductPrototypeService;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDateTime;
import java.util.Date;

public class RailwayReferenceMcoFXHelper {
    public static void toVMParentParametersVM(BookingFileProductRailwayMCOPanelVM view, RailwayReferenceMCO product, RailwayReferenceMCOUIData productData) {
        view.setUid(product.getUid());
        view.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        view.setBookingFile(product.getReservation().getBookingFile());
        view.getStatuses().setChecked(product.isChecked());
        view.getStatuses().setFinished(product.isCompleted());
        view.getStatuses().setHasErrors(productData.isHasErrors());
        view.getStatuses().setHasWarnings(productData.isHasWarnings());
        RailwayReferenceMcoFXHelper.toVMGeneral(view.getGeneral(), product, productData);
        view.getComment().setComments(product.getComments());
    }

    private static void toVMGeneral(BookingFileProductRailwayMCOGeneralPanelVM view, RailwayReferenceMCO product, RailwayReferenceMCOUIData productData) {
        RailwayReferenceMcoFXHelper.toVMTicketInfo(view.getTicketInfo(), product);
        RailwayReferenceMcoFXHelper.toVMParameters(view.getParameters(), product);
    }

    private static void toVMTicketInfo(BookingFileProductChildParametersTicketInfoVM view, RailwayReferenceMCO product) {
        ProductStatus status = product.getStatus();
        view.setProductValue(ProductType.RAILWAY_REFERENCE_MCO.toString());
        view.setTicketNumberValue(product.getSystemNumber());
        view.setScnValue(product.getScn());
        view.setStatusValue(status != null ? status.toString() : null);
        view.setBlankValue(product.getBlankType());
        view.setReservationValue(product.getReservation().getUid());
        view.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        view.setTicketTypeValue(product.getTicketType());
    }

    private static void toVMParameters(BookingFileProductRailwayMCOParametersPaneVM view, RailwayReferenceMCO product) {
        BaseProduct baseProduct = product.getRelatedProduct();
        view.setRelated(baseProduct);
        view.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        view.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
    }

    public static void fromVM(BookingFileProductRailwayMCOPanelVM view, RailwayReferenceMCO product, BookingFile bookingFile) {
        BookingFileProductChildParametersTicketInfoVM ticketInformation = view.getGeneral().getTicketInfo();
        product.setSystemNumber(ticketInformation.getTicketNumberValue());
        product.setScn(ticketInformation.getScnValue());
        product.setBlankType(ticketInformation.getBlankValue());
        product.setRelatedProduct(view.getGeneral().getParameters().getRelated());
        product.setChecked(view.getStatuses().isChecked());
        product.setCompleted(view.getStatuses().isFinished());
        product.setComments(view.getComment().getComments());
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)view.getGeneral().getTicketInfo().getCorrectionDateValue()));
        product.setTicketType(view.getGeneral().getTicketInfo().getTicketTypeValue());
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)view.getGeneral().getParameters().getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)view.getGeneral().getParameters().getShipmentsDateSubagentValue()));
    }

    public static MiscUtil.Pair<RailwayReferenceMCO, RailwayReferenceMCOUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        RailwayReferenceMCO product = new RailwayReferenceMCO();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((RailwayProductPrototypeService)RpcServiceManager.get().getService(RailwayProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new RailwayReferenceMCO(), (Object)new RailwayReferenceMCOUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductRailwayMCOPanel node, BookingFileSpaceVM bookingFileVM) {
    }
}

