/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.railway.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductRefundTask;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.profile.Person;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javafx.scene.Node;

public class RailwayMCOProductRefundDialog {
    protected final RootEntityPane<BookingFile, ?> rootPane;
    private final Node source;
    protected final EntityReference<BookingFile> bookingFileReference;
    protected final RailwayMcoProduct product;
    private final DateTimeValueWidget operationDateWidget;
    private final EntityBoxWidget<Person> agentWidget;
    private final PriceValueWidget usedEquivFareWidget;
    private final PriceValueWidget penaltyAmountWidget;

    public RailwayMCOProductRefundDialog(Node source, EntityReference<BookingFile> bookingFileReference, RailwayMcoProduct product) {
        this(null, source, bookingFileReference, product);
    }

    public RailwayMCOProductRefundDialog(RootEntityPane<BookingFile, ?> rootPane, RailwayMcoProduct product) {
        this(rootPane, (Node)rootPane, null, product);
    }

    public RailwayMCOProductRefundDialog(RootEntityPane<BookingFile, ?> rootPane, Node source, EntityReference<BookingFile> bookingFileReference, RailwayMcoProduct product) {
        this.rootPane = rootPane;
        this.source = source;
        this.product = product;
        this.bookingFileReference = bookingFileReference;
        this.operationDateWidget = new DateTimeValueWidget(false);
        this.operationDateWidget.setValue(DateUtils.asLocalDateTime((Date)new Date()));
        this.agentWidget = new EntityBoxWidget(Person.class, false);
        this.agentWidget.setListParametersSupplier(ControllerInterceptorsHelper::getEmployees);
        this.agentWidget.setValue(Prefetched.getData().getCurrentAgentData().getAgent());
        this.usedEquivFareWidget = new PriceValueWidget(false);
        this.penaltyAmountWidget = new PriceValueWidget(false);
    }

    public void showDialog() {
        CardsContainer cardsContainer = this.createBaseParametersCard();
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.RailwayMcoProduct_refund).setAutoClose(false).setExpandToParent().setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Payback, () -> {
            ProductExchangeRefundProperties properties = new ProductExchangeRefundProperties(this.getOperationDate(), this.getAgent(), false, null, this.getUsedEquivFare(), this.getPenaltyAmount(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null);
            ProductRefundTask task = this.rootPane != null ? new ProductRefundTask(this.product.getUid(), properties, this.rootPane) : new ProductRefundTask(this.product.getUid(), properties, this.bookingFileReference);
            Notifications.get().enqueueAsyncTask((ClientTask)task);
            dialog.close();
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show(this.source);
    }

    private GridContainer createGeneralParamsContainer() {
        GridContainer gridContainer = new GridContainer(2);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Operation_date, (Node)this.operationDateWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Agent, this.agentWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Retention_at_the_equivalent_tariff, (Node)this.usedEquivFareWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Penalty_amount, (Node)this.penaltyAmountWidget);
        cells.add(cell);
        gridContainer.getCells().addAll(cells);
        return gridContainer;
    }

    private CardsContainer createBaseParametersCard() {
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("main", UiCardsContainer.Style.STATIC, Messages.Payback_parameters, (Node)this.createGeneralParamsContainer()));
        return cardsContainer;
    }

    private Date getOperationDate() {
        return DateUtils.asDate((LocalDateTime)this.operationDateWidget.getValue());
    }

    private EntityReference<Person> getAgent() {
        return this.agentWidget.getValue();
    }

    private BigDecimal getUsedEquivFare() {
        return (BigDecimal)this.usedEquivFareWidget.getValue();
    }

    private BigDecimal getPenaltyAmount() {
        return (BigDecimal)this.penaltyAmountWidget.getValue();
    }
}

