/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.kkt.client;

import com.gridnine.kkt.client.RestResponse;
import com.gridnine.kkt.client.RestResponseType;
import com.gridnine.kkt.common.model.JsonSerializable;
import com.gridnine.kkt.common.model.api.BooleanResponse;
import com.gridnine.kkt.common.model.api.DoubleResponse;
import com.gridnine.kkt.common.model.api.ErrorResponse;
import com.gridnine.kkt.common.model.api.StringResponse;
import com.gridnine.kkt.common.model.helper.JsonHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class RestConnector {
    private String baseURL;

    public RestConnector(String baseURL) {
        this.baseURL = baseURL;
    }

    private static void closeQuietly(AutoCloseable resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (Exception e) {
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private static String readEntity(InputStream inputStream) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> RestResponse<T> get(String url, Class<T> type, JsonSerializable param) throws Exception {
        HttpURLConnection connection = null;
        try {
            Throwable throwable;
            Object stream;
            String entity;
            URL uri = new URL(this.baseURL + url);
            connection = (HttpURLConnection)uri.openConnection();
            String responseEntity = null;
            if (param == null) {
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestMethod("GET");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.connect();
            } else {
                entity = JsonHelper.serialize((JsonSerializable)param);
                connection.setRequestProperty("Accept", "application/json");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                stream = connection.getOutputStream();
                throwable = null;
                try (OutputStreamWriter wr = new OutputStreamWriter((OutputStream)stream, "UTF-8");){
                    wr.write(entity);
                    wr.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)stream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStream)stream).close();
                        }
                    }
                }
            }
            try {
                InputStream stream2 = connection.getInputStream();
                stream = null;
                try {
                    responseEntity = RestConnector.readEntity(stream2);
                }
                catch (Throwable throwable4) {
                    stream = throwable4;
                    throw throwable4;
                }
                finally {
                    if (stream2 != null) {
                        if (stream != null) {
                            try {
                                stream2.close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)stream).addSuppressed(throwable5);
                            }
                        } else {
                            stream2.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                stream = connection.getErrorStream();
                throwable = null;
                try {
                    responseEntity = RestConnector.readEntity((InputStream)stream);
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (stream != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            ((InputStream)stream).close();
                        }
                    }
                }
            }
            if (connection.getResponseCode() == 200) {
                if (type == Void.class) {
                    return new RestResponse<Object>(RestResponseType.OK, null);
                }
                if (type == Boolean.class) {
                    BooleanResponse booleanResponse = (BooleanResponse)JsonHelper.deserialize(BooleanResponse.class, (String)responseEntity);
                    return new RestResponse<Boolean>(RestResponseType.OK, booleanResponse.getValue());
                }
                if (type == String.class) {
                    StringResponse stringResponse = (StringResponse)JsonHelper.deserialize(StringResponse.class, (String)responseEntity);
                    return new RestResponse<String>(RestResponseType.OK, stringResponse.getValue());
                }
                if (type == Double.class) {
                    DoubleResponse doubleResponse = (DoubleResponse)JsonHelper.deserialize(DoubleResponse.class, (String)responseEntity);
                    return new RestResponse<Double>(RestResponseType.OK, doubleResponse.getValue());
                }
                if (JsonSerializable.class.isAssignableFrom(type)) {
                    entity = JsonHelper.deserialize(type, (String)responseEntity);
                    return new RestResponse<String>(RestResponseType.OK, entity);
                }
                throw new IllegalArgumentException("Cannot create object of type " + type);
            }
            if (connection.getResponseCode() == 400) {
                ErrorResponse resp = (ErrorResponse)JsonHelper.deserialize(ErrorResponse.class, (String)responseEntity);
                return new RestResponse<Object>(RestResponseType.ERROR_RESPONSE, null, resp.getMessage(), resp.getDetails());
            }
            if (connection.getResponseCode() == 204) {
                return new RestResponse<Object>(RestResponseType.OK, null);
            }
            String message = "Wrong return code received from server: " + connection.getResponseCode();
            return new RestResponse<Object>(RestResponseType.ERROR_RESPONSE, null, message, RestConnector.readEntity(connection.getErrorStream()));
        }
        catch (IOException e) {
            return new RestResponse<Object>(RestResponseType.ERROR_RESPONSE, null, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443", "");
        }
    }
}

