/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.SearchTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomTreeView;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.SortableTreeItem;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardAction;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DelayedChangeListener;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorEmptyRulesPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorRestrictionResourceHandlersRegistry;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorRulesPane;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.security.acl.AclChangeRegistry;
import com.gridnine.xtrip.common.fx.security.acl.AclRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionGroupResources;
import com.gridnine.xtrip.common.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.common.restriction.resource.RestrictionDictResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionEntityResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionGroupResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionIndexResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.restriction.resource.RestrictionUiResource;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.principal.AclPrincipal;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclEditorEntriesEditorPane
extends StackPane
implements DevTool {
    private static final Logger log = LoggerFactory.getLogger(AclEditorEntriesEditorPane.class);
    private TextField filterTextField;
    private CustomTreeView<RestrictionResource> tree;
    private CardsContainer restrictionResourcesCardsPane;
    private CardsContainer rulesCardsPane;
    private final Card<AclEditorEmptyRulesPane> emptyRulesCard;
    private final Card<AclEditorRulesPane> rulesCard;
    private SortableTreeItem<RestrictionResource> selectedItem;
    private AclChangeRegistry.AclEntryData selectedEntryData;
    private final Map<RestrictionResource, AclChangeRegistry.AclEntryData> entryDataCache = new HashMap<RestrictionResource, AclChangeRegistry.AclEntryData>();
    private final AclChangeRegistry.AclPrincipalData<AclPrincipal> principalData;
    private final AclRegistry registry;
    private final AclChangeRegistry changeRegistry;
    private final ObservableMutex mutex;
    private boolean fresh;
    private boolean clean;

    public AclEditorEntriesEditorPane(AclChangeRegistry.AclPrincipalData<AclPrincipal> principalData, AclRegistry registry, AclChangeRegistry changeRegistry, ObservableMutex mutex) {
        this.principalData = principalData;
        this.registry = registry;
        this.changeRegistry = changeRegistry;
        this.mutex = mutex;
        this.emptyRulesCard = new Card("rulesStub", UiCardsContainer.Style.STATIC, null, (Node)new AclEditorEmptyRulesPane());
        this.rulesCard = new Card("rules", UiCardsContainer.Style.STATIC, Messages.Rules, (Node)new AclEditorRulesPane());
        this.rulesCard.getActions().add((Object)new CardAction<AclEditorRulesPane>(){

            public String getName(Card<AclEditorRulesPane> card) {
                return Messages.Clean;
            }

            public String getDescription(Card<AclEditorRulesPane> card) {
                return null;
            }

            public double getWeight() {
                return 0.0;
            }

            public boolean isEnabled(Card<AclEditorRulesPane> card) {
                return AclEditorEntriesEditorPane.this.selectedItem != null;
            }

            public void execute(Card<AclEditorRulesPane> card, boolean alt) {
                if (AclEditorEntriesEditorPane.this.selectedItem != null) {
                    AclEditorEntriesEditorPane.this.selectedEntryData.getEntry().getRules().clear();
                    AclEditorEntriesEditorPane.this.read();
                    AclEditorEntriesEditorPane.this.clean = true;
                }
            }
        });
        this.createGUI();
        this.createBindings();
        this.createListeners();
        Notifications.get().submitTask(() -> this.populate(), mutex);
    }

    private void createGUI() {
        Pane aclPane = this.createAclPane();
        this.getChildren().setAll((Object[])new Node[]{aclPane});
    }

    private Pane createAclPane() {
        Pane restrictionResourcesPane = this.createRestrictionResourcesPane();
        Pane rulesPane = this.createRulesPane();
        GridPane aclPane = new GridPane();
        UiUtil.gridPosition((GridPane)aclPane, (Node)restrictionResourcesPane).col(0).row(0).hGrow(Priority.NEVER).vGrow(Priority.ALWAYS).place();
        UiUtil.gridPosition((GridPane)aclPane, (Node)rulesPane).col(1).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        return aclPane;
    }

    private Pane createRestrictionResourcesPane() {
        this.filterTextField = new SearchTextField();
        this.tree = new CustomTreeView();
        this.tree.setShowRoot(false);
        this.tree.setConverter((StringConverter)new StringConverter<RestrictionResource>(){

            public String toString(RestrictionResource object) {
                return object.getName();
            }

            public RestrictionResource fromString(String string) {
                return null;
            }
        });
        this.tree.setIconSupplier(item -> {
            RestrictionResource value = (RestrictionResource)item.getValue();
            if (value instanceof RestrictionGroupResource) {
                return StandardIconShapes.RESOURCE_GROUP_14X14;
            }
            if (value instanceof RestrictionEntityResource) {
                return StandardIconShapes.RESOURCE_ENTITY_14X14;
            }
            if (value instanceof RestrictionIndexResource) {
                return StandardIconShapes.RESOURCE_INDEX_14X14;
            }
            if (value instanceof RestrictionDictResource) {
                return StandardIconShapes.RESOURCE_DICTIONARY_14X14;
            }
            if (value instanceof RestrictionUiResource) {
                return StandardIconShapes.RESOURCE_UI_14X14;
            }
            return StandardIconShapes.UNDEFINED;
        });
        this.tree.setStyleSupplier(item -> {
            RestrictionResource value = (RestrictionResource)item.getValue();
            return this.registry.getEntry(this.principalData.getPrincipal().getId(), value.getId()) != null ? Collections.singletonList("bold") : Collections.emptyList();
        });
        GridPane pane = new GridPane();
        UiUtil.gridPosition((GridPane)pane, (Node)this.filterTextField).col(0).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
        UiUtil.gridPosition((GridPane)pane, this.tree).col(0).row(1).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        Card card = new Card("resources", UiCardsContainer.Style.STATIC, Messages.Resources, (Node)pane);
        card.setAdaptiveHeight(true);
        this.restrictionResourcesCardsPane = new CardsContainer();
        this.restrictionResourcesCardsPane.getStyleClass().add((Object)"restriction-resources-pane");
        this.restrictionResourcesCardsPane.getCards().add((Object)card);
        return this.restrictionResourcesCardsPane;
    }

    private Pane createRulesPane() {
        this.rulesCardsPane = new CardsContainer();
        this.rulesCardsPane.getStyleClass().add((Object)"restriction-rules-panel");
        this.rulesCardsPane.getCards().add(this.emptyRulesCard);
        return this.rulesCardsPane;
    }

    private void createBindings() {
    }

    private void createListeners() {
        this.mutex.acquiredProperty().addListener((observable, oldValue, newValue) -> this.tree.setDisable(newValue.booleanValue()));
        this.filterTextField.textProperty().addListener((ChangeListener)new DelayedChangeListener<String>(Duration.millis((double)700.0)){

            protected void handle(String filter) {
                SortableTreeItem root = (SortableTreeItem)AclEditorEntriesEditorPane.this.tree.getRoot();
                if (root != null) {
                    AclEditorEntriesEditorPane.this.tree.getSelectionModel().select(null);
                    root.setPredicate(filter != null && !filter.isEmpty() ? value -> TextUtil.isLike((String)value.getId(), (String)filter, (boolean)true, (boolean)false) || TextUtil.isLike((String)value.getName(), (String)filter, (boolean)true, (boolean)false) || TextUtil.isLike((String)value.getDescription(), (String)filter, (boolean)true, (boolean)false) : null);
                    UiUtil.expand((TreeView)AclEditorEntriesEditorPane.this.tree);
                }
            }
        });
        this.tree.getSelectionModel().selectedItemProperty().addListener(observable -> this.select());
    }

    private void populate() throws Exception {
        SortableTreeItem root = new SortableTreeItem();
        root.setComparator(MiscUtil.comparator(item -> (RestrictionResource)item.getValue(), (Comparator)RestrictionsHelper.restrictionResourceComparator));
        List<RestrictionResource> rootResources = RestrictionResourcesRegistry.get().getResources().stream().filter(value -> value.getParentId() == null).collect(Collectors.toList());
        this.populate((SortableTreeItem<RestrictionResource>)root, rootResources);
        Iterator iterator = ((SortableTreeItem)root.getInternalChildren().get(0)).getInternalChildren().iterator();
        while (iterator.hasNext()) {
            TreeItem item2 = (TreeItem)iterator.next();
            if (TextUtil.isSame((String)((RestrictionResource)item2.getValue()).getId(), (String)ModelRestrictionGroupResources.GROUP_ASSET_LIST.getId())) {
                iterator.remove();
                continue;
            }
            if (!Prefetched.getData().isRestrictedAclResources() || !TextUtil.isSame((String)((RestrictionResource)item2.getValue()).getId(), (String)ModelRestrictionGroupResources.GROUP_ENTITY.getId()) && !TextUtil.isSame((String)((RestrictionResource)item2.getValue()).getId(), (String)ModelRestrictionGroupResources.GROUP_INDEX.getId())) continue;
            iterator.remove();
        }
        FxUtil.submitToFxThread(() -> {
            this.tree.setRoot((TreeItem)root);
            UiUtil.expand(this.tree, (int)2);
            this.tree.getSelectionModel().clearSelection();
            this.tree.getSelectionModel().select(this.tree.getRoot() != null && this.tree.getRoot().getChildren().size() > 0 ? (TreeItem)this.tree.getRoot().getChildren().get(0) : null);
        });
    }

    private void populate(SortableTreeItem<RestrictionResource> item, Collection<RestrictionResource> resources) {
        for (RestrictionResource resource : resources) {
            SortableTreeItem resourceItem = new SortableTreeItem();
            resourceItem.setValue((Object)resource);
            item.add((TreeItem)resourceItem);
            ArrayList<RestrictionResource> resourceChildren = new ArrayList<RestrictionResource>();
            for (String groupChildId : RestrictionResourcesRegistry.get().getResourceChildren(resource.getId())) {
                RestrictionResource resourceChild = RestrictionResourcesRegistry.get().getResource(groupChildId);
                if (resourceChild == null) continue;
                resourceChildren.add(resourceChild);
            }
            this.populate((SortableTreeItem<RestrictionResource>)resourceItem, resourceChildren);
        }
    }

    private AclChangeRegistry.AclEntryData getEntryData(RestrictionResource resource) throws Exception {
        AclChangeRegistry.AclEntryData entryData = this.entryDataCache.get(resource);
        if (entryData == null) {
            AclEntry entry = this.registry.getEntry(this.principalData.getPrincipal().getId(), resource.getId());
            if (entry == null) {
                entry = new AclEntry();
                entry.setPrincipalId(this.principalData.getPrincipal().getId());
                entry.setResourceId(resource.getId());
                this.fresh = true;
            }
            entryData = new AclChangeRegistry.AclEntryData();
            entryData.setEntry(entry);
            this.entryDataCache.put(resource, entryData);
        }
        return entryData;
    }

    private boolean check() {
        return this.selectedItem != null && (this.clean || ((AclEditorRulesPane)this.rulesCard.getContent()).isDataChanged());
    }

    private void read() {
        if (this.selectedItem != null) {
            ((AclEditorRulesPane)this.rulesCard.getContent()).readData(this.selectedEntryData);
            this.update();
        }
    }

    private void write() {
        if (this.selectedItem != null) {
            boolean empty;
            boolean check = this.check();
            if (check) {
                ((AclEditorRulesPane)this.rulesCard.getContent()).writeData(this.selectedEntryData);
                this.debugClean("== BEFORE CLEAN =========================");
                AclEditorRestrictionResourceHandlersRegistry.get().getHandler(this.selectedEntryData).clean(this.selectedEntryData);
                this.debugClean("== AFTER CLEAN ==========================");
                empty = AclEditorRestrictionResourceHandlersRegistry.get().getHandler(this.selectedEntryData).isEmpty(this.selectedEntryData);
                if (!empty) {
                    if (this.fresh) {
                        this.registry.addEntry(this.selectedEntryData.getEntry());
                        this.changeRegistry.add(this.selectedEntryData);
                    } else {
                        this.changeRegistry.edit(this.selectedEntryData);
                    }
                } else if (!this.fresh) {
                    this.registry.removeEntry(this.selectedEntryData.getEntry());
                    this.changeRegistry.delete(this.selectedEntryData);
                }
                this.update();
            }
            if (empty = AclEditorRestrictionResourceHandlersRegistry.get().getHandler(this.selectedEntryData).isEmpty(this.selectedEntryData)) {
                this.entryDataCache.remove(this.selectedItem.getValue());
            }
            this.fresh = false;
            this.clean = false;
        }
    }

    private void select() {
        Notifications.get().submitTask(() -> {
            if (this.selectedItem != null) {
                FxUtil.waitForFxThread(() -> {
                    this.write();
                    this.debugState("== DESELECT =============================");
                });
            }
            this.selectedItem = (SortableTreeItem)this.tree.getSelectionModel().getSelectedItem();
            this.selectedEntryData = null;
            if (this.selectedItem != null) {
                this.selectedEntryData = this.getEntryData((RestrictionResource)this.selectedItem.getValue());
                FxUtil.waitForFxThread(() -> {
                    this.rulesCardsPane.getCards().setAll((Object[])new Card[]{this.rulesCard});
                    this.read();
                    this.debugState("== SELECT ===============================");
                });
            } else {
                FxUtil.waitForFxThread(() -> this.rulesCardsPane.getCards().setAll((Object[])new Card[]{this.emptyRulesCard}));
            }
        }, this.mutex);
    }

    public void flush() {
        this.write();
        this.debugState("== FLUSH ================================");
    }

    private void update() {
        Event.fireEvent(this.selectedItem, (Event)new TreeItem.TreeModificationEvent(TreeItem.valueChangedEvent(), this.selectedItem, this.selectedItem.getValue()));
    }

    private void debugClean(String title) {
    }

    private void debugState(String title) {
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Arrays.asList(AclEditorEntriesEditorPane.this.restrictionResourcesCardsPane, AclEditorEntriesEditorPane.this.rulesCardsPane);
            }

            public String getInfo() {
                return ((Object)((Object)AclEditorEntriesEditorPane.this)).getClass().getSimpleName();
            }
        };
    }
}

