/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.SortableCheckBoxTreeItem;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.security.acl.AclChangeRegistry;
import com.gridnine.xtrip.common.fx.security.acl.AclRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

class AclEditorGroupDataPane
extends StackPane {
    private GridCell<TextFieldWidget> nameCell;
    private GridCell<TextFieldWidget> descriptionCell;
    private GridCell<TextFieldWidget> idCell;
    private TreeView<AclGroup> groupsTree;
    private final ReadOnlyBooleanWrapper valid = new ReadOnlyBooleanWrapper(false);
    private final AclRegistry registry;
    private final ObservableMutex mutex;
    private final ObjectProperty<SortableCheckBoxTreeItem<AclGroup>> selectedItem = new SimpleObjectProperty();
    private AclChangeRegistry.AclGroupData data;

    AclEditorGroupDataPane(AclRegistry registry, ObservableMutex mutex) {
        this.registry = registry;
        this.mutex = mutex;
        this.createGUI();
        this.createBindings();
        this.createListeners();
        Notifications.get().submitTask(() -> this.populate(), mutex);
    }

    private void createGUI() {
        Pane editorPane = this.createGroupDataPane();
        this.getChildren().setAll((Object[])new Node[]{editorPane});
    }

    private Pane createGroupDataPane() {
        Pane parametersPane = this.createParametersPane();
        Pane groupsPane = this.createGroupsPane();
        GridPane userPane = new GridPane();
        UiUtil.gridPosition((GridPane)userPane, (Node)parametersPane).col(0).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        UiUtil.gridPosition((GridPane)userPane, (Node)groupsPane).col(1).row(0).hGrow(Priority.NEVER).vGrow(Priority.ALWAYS).place();
        return userPane;
    }

    private Pane createParametersPane() {
        this.nameCell = new GridCell(Messages.Name, (Node)new TextFieldWidget(false));
        this.descriptionCell = new GridCell(Messages.Description, (Node)new TextFieldWidget(false));
        this.idCell = new GridCell(Messages.ID, (Node)new TextFieldWidget(false));
        GridContainer pane = new GridContainer(3);
        pane.getCells().addAll((Object[])new GridCell[]{this.nameCell, this.descriptionCell, GridCell.NEW_ROW_MARKER, this.idCell});
        Card card = new Card("parameters", UiCardsContainer.Style.STATIC, Messages.General_parameters, (Node)pane);
        card.setAdaptiveHeight(true);
        CardsContainer parametersPane = new CardsContainer();
        parametersPane.getStyleClass().add((Object)"parameters-pane");
        parametersPane.getCards().add((Object)card);
        return parametersPane;
    }

    private Pane createGroupsPane() {
        this.groupsTree = new TreeView();
        this.groupsTree.getStyleClass().add((Object)"xtrip-tree-view");
        this.groupsTree.getStyleClass().add((Object)"xtrip-checkbox-tree-view");
        this.groupsTree.setShowRoot(false);
        this.groupsTree.setCellFactory((Callback)new Callback<TreeView<AclGroup>, TreeCell<AclGroup>>(){

            public TreeCell<AclGroup> call(TreeView<AclGroup> param) {
                return new GroupTreeCell();
            }
        });
        GridPane pane = new GridPane();
        UiUtil.gridPosition((GridPane)pane, this.groupsTree).col(0).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        Card card = new Card("groups", UiCardsContainer.Style.STATIC, Messages.Groups, (Node)pane);
        card.setAdaptiveHeight(true);
        CardsContainer groupsPane = new CardsContainer();
        groupsPane.getStyleClass().add((Object)"groups-pane");
        groupsPane.getCards().add((Object)card);
        return groupsPane;
    }

    private void createBindings() {
        this.valid.bind((ObservableValue)Bindings.createBooleanBinding(() -> !TextUtil.isBlank((String)((TextFieldWidget)this.nameCell.getPayload()).getValue()) && !TextUtil.isBlank((String)((TextFieldWidget)this.idCell.getPayload()).getValue(), (boolean)false) && this.selectedItem.get() != null, (Observable[])new Observable[]{((TextFieldWidget)this.nameCell.getPayload()).valueProperty(), ((TextFieldWidget)this.idCell.getPayload()).valueProperty(), this.selectedItem}));
    }

    private void createListeners() {
    }

    private void populate() throws Exception {
        AclGroup rootGroup = new AclGroup();
        rootGroup.setId("root");
        SortableCheckBoxTreeItem rootItem = new SortableCheckBoxTreeItem();
        rootItem.setValue((Object)rootGroup);
        rootItem.setSelected(false);
        rootItem.setIndependent(true);
        rootItem.setComparator(MiscUtil.comparator(item -> (AclGroup)item.getValue(), (Comparator)AclHelper.groupComparator));
        List<AclGroup> rootGroups = this.registry.getGroups().stream().filter(value -> value.getParentId() == null).collect(Collectors.toList());
        this.populate((SortableCheckBoxTreeItem<AclGroup>)rootItem, rootGroups);
        FxUtil.waitForFxThread(() -> {
            this.groupsTree.setRoot((TreeItem)rootItem);
            UiUtil.expand(this.groupsTree);
        });
    }

    private void populate(SortableCheckBoxTreeItem<AclGroup> parent, Collection<AclGroup> groups) {
        for (AclGroup group : groups) {
            if (group == null) continue;
            SortableCheckBoxTreeItem item = new SortableCheckBoxTreeItem();
            item.setValue((Object)group);
            item.setSelected(false);
            item.setIndependent(true);
            item.selectedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    if (this.selectedItem.get() != null) {
                        ((SortableCheckBoxTreeItem)this.selectedItem.get()).setSelected(false);
                    }
                    this.selectedItem.set((Object)item);
                } else {
                    this.selectedItem.set(null);
                }
            });
            parent.add((TreeItem)item);
            List<AclGroup> childGroups = this.registry.getGroupChildren(group.getId()).stream().map(value -> this.registry.getGroup(value)).collect(Collectors.toList());
            this.populate((SortableCheckBoxTreeItem<AclGroup>)item, childGroups);
        }
    }

    private void clear(TreeItem<AclGroup> item) {
        ((SortableCheckBoxTreeItem)item).setSelected(false);
        for (TreeItem childItem : ((SortableCheckBoxTreeItem)item).getInternalChildren()) {
            this.clear((TreeItem<AclGroup>)childItem);
        }
    }

    public void readData(AclChangeRegistry.AclGroupData model) {
        this.data = model;
        ((TextFieldWidget)this.nameCell.getPayload()).setValue(((AclGroup)model.getPrincipal()).getName());
        ((TextFieldWidget)this.descriptionCell.getPayload()).setValue(((AclGroup)model.getPrincipal()).getDescription());
        ((TextFieldWidget)this.idCell.getPayload()).setValue(((AclGroup)model.getPrincipal()).getId());
        ((TextFieldWidget)this.idCell.getPayload()).getViewState().setReadonly(((AclGroup)model.getPrincipal()).getId() != null);
        this.groupsTree.setDisable(true);
        Notifications.get().submitTask(() -> FxUtil.waitForFxThread(() -> {
            AclGroup parentGroup;
            this.clear((TreeItem<AclGroup>)this.groupsTree.getRoot());
            AclGroup aclGroup = parentGroup = ((AclGroup)this.data.getPrincipal()).getParentId() != null ? this.registry.getGroup(((AclGroup)this.data.getPrincipal()).getParentId()) : null;
            if (parentGroup != null) {
                for (TreeItem item : UiUtil.search((TreeItem)this.groupsTree.getRoot(), (Object)parentGroup, (o1, o2) -> MiscUtil.equals((Object)o1, (Object)o2), value -> ((SortableCheckBoxTreeItem)value).getInternalChildren())) {
                    ((SortableCheckBoxTreeItem)item).setSelected(true);
                }
            }
            this.groupsTree.setDisable(AclHelper.isSpecialGroup((AclGroup)((AclGroup)model.getPrincipal())));
        }), this.mutex);
    }

    public void writeData(AclChangeRegistry.AclGroupData model) {
        this.data = model;
        ((AclGroup)model.getPrincipal()).setName(((TextFieldWidget)this.nameCell.getPayload()).getValue());
        ((AclGroup)model.getPrincipal()).setDescription(((TextFieldWidget)this.descriptionCell.getPayload()).getValue());
        ((AclGroup)model.getPrincipal()).setId(((TextFieldWidget)this.idCell.getPayload()).getValue());
        ((AclGroup)model.getPrincipal()).setParentId(this.selectedItem.get() != null ? ((AclGroup)((SortableCheckBoxTreeItem)this.selectedItem.get()).getValue()).getId() : null);
    }

    final ReadOnlyBooleanProperty validProperty() {
        return this.valid.getReadOnlyProperty();
    }

    private static class GroupTreePane
    extends StackPane {
        private final CheckBox selectedCheckBox = new CheckBox();
        private final Label titleLabel;
        private final IconNode rulerButtonIcon;

        GroupTreePane(TreeCell<?> cell) {
            this.selectedCheckBox.getStyleClass().add((Object)"selected-check-box");
            this.titleLabel = new Label();
            this.titleLabel.getStyleClass().add((Object)"title-label");
            this.rulerButtonIcon = new IconNode((IconShape)StandardIconShapes.RULER_14X14, cell, (IconIntention)StandardIconIntentions.TREE_CELL_BUTTON_RULER, cell);
            this.rulerButtonIcon.getStyleClass().add((Object)"button-icon");
            GridPane containerPane = new GridPane();
            containerPane.getStyleClass().add((Object)"container-pane");
            UiUtil.gridPosition((GridPane)containerPane, (Node)this.selectedCheckBox).col(0).row(0).hAlignment(HPos.LEFT).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition((GridPane)containerPane, (Node)this.titleLabel).col(1).row(0).hAlignment(HPos.LEFT).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition((GridPane)containerPane, (Node)this.rulerButtonIcon).col(2).row(0).hAlignment(HPos.LEFT).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            this.getChildren().addAll((Object[])new Node[]{containerPane});
        }

        CheckBox getSelectedCheckBox() {
            return this.selectedCheckBox;
        }

        Label getTitleLabel() {
            return this.titleLabel;
        }

        IconNode getRulerButtonIcon() {
            return this.rulerButtonIcon;
        }
    }

    class GroupTreeCell
    extends CheckBoxTreeCell<AclGroup> {
        private GroupTreePane pane;
        private BooleanProperty selectedProperty;

        GroupTreeCell() {
        }

        public void updateItem(AclGroup value, boolean empty) {
            super.updateItem((Object)value, empty);
            this.setDisclosureNode(null);
            if (!empty) {
                TreeItem item;
                if (this.pane == null) {
                    this.pane = new GroupTreePane((TreeCell<?>)this);
                    this.pane.getRulerButtonIcon().setOnMousePressed(event -> {
                        this.getTreeItem().setExpanded(!this.getTreeItem().isExpanded());
                        event.consume();
                    });
                }
                if ((item = this.getTreeItem()) != null) {
                    if (this.selectedProperty != null) {
                        this.pane.getSelectedCheckBox().selectedProperty().unbindBidirectional((Property)this.selectedProperty);
                    }
                    this.selectedProperty = ((SortableCheckBoxTreeItem)item).selectedProperty();
                    this.pane.getSelectedCheckBox().selectedProperty().bindBidirectional((Property)this.selectedProperty);
                    this.setOnMouseClicked(e -> this.selectedProperty.setValue(Boolean.valueOf(this.pane.getSelectedCheckBox().selectedProperty().getValue() == false)));
                    this.pane.getTitleLabel().setText(item.getValue() != null ? ((AclGroup)item.getValue()).getName() : null);
                    this.pane.getRulerButtonIcon().setVisible(!item.isLeaf());
                }
                this.setGraphic((Node)this.pane);
            } else {
                this.setGraphic(null);
            }
            this.setText(null);
        }
    }
}

