/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclPrincipalChangedEvent;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.security.acl.AclChangeRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Collections;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

class AclEditorGroupParametersPane
extends StackPane
implements AclEditorPane.AclPrincipalEditor<AclGroup, AclChangeRegistry.AclGroupData>,
DevTool {
    private GridCell<TextFieldWidget> nameCell;
    private GridCell<TextFieldWidget> descriptionCell;
    private GridCell<TextFieldWidget> idCell;
    private AclChangeRegistry.AclGroupData data;
    private boolean changed;
    private boolean initialized;

    AclEditorGroupParametersPane() {
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        Pane editorPane = this.createEditorPane();
        this.getChildren().setAll((Object[])new Node[]{editorPane});
    }

    private Pane createEditorPane() {
        this.nameCell = new GridCell(Messages.Name, (Node)new TextFieldWidget(false));
        this.descriptionCell = new GridCell(Messages.Description, (Node)new TextFieldWidget(false));
        this.idCell = new GridCell(Messages.ID, (Node)new TextFieldWidget(false));
        GridContainer editorPane = new GridContainer(3);
        editorPane.getCells().addAll((Object[])new GridCell[]{this.nameCell, this.descriptionCell, GridCell.NEW_ROW_MARKER, this.idCell});
        return editorPane;
    }

    private void createBindings() {
    }

    private void createListeners() {
        ((TextFieldWidget)this.nameCell.getPayload()).valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.initialized) {
                ((AclGroup)this.data.getPrincipal()).setName(!TextUtil.isBlank((String)newValue) ? newValue : null);
                this.changed = true;
                EventBus.get().publishSync((Event)new AclPrincipalChangedEvent(AclPrincipalChangedEvent.ChangeType.NAME));
            }
        });
    }

    @Override
    public Card<Node> getContent() {
        return new Card("parameters", UiCardsContainer.Style.STATIC, Messages.General_parameters, (Node)this);
    }

    @Override
    public boolean isDataChanged() {
        if (this.data == null) {
            return false;
        }
        if (this.changed) {
            return true;
        }
        if (!MiscUtil.equals((Object)((AclGroup)this.data.getPrincipal()).getName(), (Object)((TextFieldWidget)this.nameCell.getPayload()).getValue())) {
            return true;
        }
        if (!MiscUtil.equals((Object)((AclGroup)this.data.getPrincipal()).getDescription(), (Object)((TextFieldWidget)this.descriptionCell.getPayload()).getValue())) {
            return true;
        }
        return !MiscUtil.equals((Object)((AclGroup)this.data.getPrincipal()).getId(), (Object)((TextFieldWidget)this.idCell.getPayload()).getValue());
    }

    @Override
    public void readData(AclChangeRegistry.AclGroupData model) {
        this.initialized = false;
        this.data = model;
        this.changed = false;
        ((TextFieldWidget)this.nameCell.getPayload()).setValue(((AclGroup)model.getPrincipal()).getName());
        ((TextFieldWidget)this.descriptionCell.getPayload()).setValue(((AclGroup)model.getPrincipal()).getDescription());
        ((TextFieldWidget)this.idCell.getPayload()).setValue(((AclGroup)model.getPrincipal()).getId());
        ((TextFieldWidget)this.idCell.getPayload()).getViewState().setReadonly(((AclGroup)model.getPrincipal()).getId() != null);
        this.initialized = true;
    }

    @Override
    public void writeData(AclChangeRegistry.AclGroupData model) {
        this.data = model;
        this.changed = false;
        ((AclGroup)model.getPrincipal()).setName(((TextFieldWidget)this.nameCell.getPayload()).getValue());
        ((AclGroup)model.getPrincipal()).setDescription(((TextFieldWidget)this.descriptionCell.getPayload()).getValue());
        ((AclGroup)model.getPrincipal()).setId(((TextFieldWidget)this.idCell.getPayload()).getValue());
        ((TextFieldWidget)this.idCell.getPayload()).getViewState().setReadonly(((AclGroup)model.getPrincipal()).getId() != null);
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.unmodifiableList(AclEditorGroupParametersPane.this.getChildren());
            }

            public String getInfo() {
                return AclEditorGroupParametersPane.this.getClass().getSimpleName();
            }
        };
    }
}

