/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorRulePane;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.security.acl.AclChangeRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceOperationPermission;
import com.gridnine.xtrip.common.security.acl.rule.AclAction;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;

class AclEditorGroupRulePane
extends AclEditorRulePane
implements DevTool {
    private TableWidgetController<TableWidget<ActionWrapper>, ActionWrapper> actionsTable;
    private final AclChangeRegistry.AclEntryData entryData;

    AclEditorGroupRulePane(AclChangeRegistry.AclEntryData entryData) {
        this.entryData = entryData;
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        Pane rulePane = this.createRulePane();
        this.getChildren().setAll((Object[])new Node[]{rulePane});
    }

    private Pane createRulePane() {
        this.actionsTable = new TableWidgetController<TableWidget<ActionWrapper>, ActionWrapper>(){
            private final TableWidget<ActionWrapper> view = new TableWidget(false);
            {
                this.view.setPlaceholder(Messages.No_data_to_view);
            }

            public TableWidget<ActionWrapper> getView() {
                return this.view;
            }
        };
        ((TableWidget)this.actionsTable.getView()).setItemsProvider(() -> new ActionWrapper());
        ((TableWidget)this.actionsTable.getView()).setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
        ArrayList<ComboBoxWidgetColumn> actionColumns = new ArrayList<ComboBoxWidgetColumn>();
        ComboBoxWidgetColumn operationColumn = new ComboBoxWidgetColumn(action -> action.operation, (action, value) -> {
            action.operation = value;
        });
        operationColumn.setNoNulls(true);
        operationColumn.setItemsSupplier(() -> this.entryData != null ? RestrictionResourcesRegistry.get().getResourceOperations(this.entryData.getEntry().getResourceId()).stream().map(value -> RestrictionResourcesRegistry.get().getOperation(value)).filter(value -> value != null).sorted((value1, value2) -> MiscUtil.compare((Comparable)((Object)value1.getName()), (Comparable)((Object)value2.getName()))).collect(Collectors.toList()) : Collections.emptyList());
        operationColumn.setConverter((StringConverter)new StringConverter<RestrictionResourceOperation>(){

            public String toString(RestrictionResourceOperation object) {
                return object != null ? object.getName() : UiUtil.NULL_TEXT;
            }

            public RestrictionResourceOperation fromString(String string) {
                return null;
            }
        });
        operationColumn.setCaption(Messages.Operation);
        operationColumn.setId("operation");
        operationColumn.setPrefWidth(Double.valueOf(50.0));
        actionColumns.add(operationColumn);
        ComboBoxWidgetColumn permissionColumn = new ComboBoxWidgetColumn(wrapper -> wrapper.permission, (wrapper, value) -> {
            wrapper.permission = value;
        });
        permissionColumn.setNoNulls(true);
        permissionColumn.setItemsSupplier(Suppliers.createEnumSupplier(AclResourceOperationPermission.class));
        permissionColumn.setConverter((StringConverter)new StringConverter<AclResourceOperationPermission>(){

            public String toString(AclResourceOperationPermission object) {
                return object != null ? object.getName() : UiUtil.NULL_TEXT;
            }

            public AclResourceOperationPermission fromString(String string) {
                return null;
            }
        });
        permissionColumn.setCaption(Messages.Permission);
        permissionColumn.setId("permission");
        actionColumns.add(permissionColumn);
        ((TableWidget)this.actionsTable.getView()).setColumns(actionColumns);
        Card actionCard = new Card("actions", UiCardsContainer.Style.STATIC, Messages.Actions, this.actionsTable.getView());
        CardsContainer ruleCardsPane = new CardsContainer();
        ruleCardsPane.getCards().add((Object)actionCard);
        return ruleCardsPane;
    }

    private void createBindings() {
    }

    private void createListeners() {
    }

    private Collection<ActionWrapper> toActionWrappers(Collection<AclAction> actions) {
        ArrayList<ActionWrapper> actionWrappers = new ArrayList<ActionWrapper>();
        Map operations = this.entryData != null ? RestrictionResourcesRegistry.get().getResourceOperations(this.entryData.getEntry().getResourceId()).stream().map(value -> RestrictionResourcesRegistry.get().getOperation(value)).filter(value -> value != null).collect(Collectors.toMap(value -> value.getId(), value -> value)) : Collections.emptyMap();
        for (AclAction action : actions) {
            if (!operations.containsKey(action.getOperationId())) continue;
            ActionWrapper actionWrapper = new ActionWrapper();
            actionWrapper.operation = (RestrictionResourceOperation)operations.get(action.getOperationId());
            actionWrapper.permission = action.getPermission();
            actionWrappers.add(actionWrapper);
        }
        return actionWrappers;
    }

    private Collection<AclAction> toActions(Collection<ActionWrapper> actionWrappers) {
        ArrayList<AclAction> actions = new ArrayList<AclAction>();
        for (ActionWrapper actionWrapper : actionWrappers) {
            AclAction action = new AclAction();
            action.setOperationId(actionWrapper.operation != null ? actionWrapper.operation.getId() : null);
            action.setPermission(actionWrapper.permission);
            actions.add(action);
        }
        return actions;
    }

    @Override
    public boolean isDataChanged() {
        return this.actionsTable.isDataChanged();
    }

    @Override
    public void readData(AclRule model) {
        this.actionsTable.readData(this.toActionWrappers(model.getActions()));
    }

    @Override
    public void writeData(AclRule model) {
        ArrayList<ActionWrapper> actionWrappers = new ArrayList<ActionWrapper>();
        this.actionsTable.writeData(actionWrappers);
        model.getActions().clear();
        model.getActions().addAll(this.toActions(actionWrappers));
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.unmodifiableList(AclEditorGroupRulePane.this.getChildren());
            }

            public String getInfo() {
                return ((Object)((Object)AclEditorGroupRulePane.this)).getClass().getSimpleName();
            }
        };
    }

    private static class ActionWrapper {
        RestrictionResourceOperation operation;
        AclResourceOperationPermission permission;

        private ActionWrapper() {
        }
    }
}

